/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.Messages;
import com.aptana.ui.UIPlugin;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class DialogUtils {
    private DialogUtils() {
    }

    public static int openIgnoreMessageDialogInformation(Shell shell, String title, String message, IPreferenceStore store, String key) {
        MessageDialogWithToggle d;
        if (!store.getString(key).equals("always") && (d = MessageDialogWithToggle.openInformation((Shell)shell, (String)title, (String)message, (String)Messages.DialogUtils_HideMessage, (boolean)false, (IPreferenceStore)store, (String)key)).getReturnCode() == 3) {
            return 1;
        }
        return 0;
    }

    public static int openIgnoreMessageDialogConfirm(Shell shell, String title, String message, IPreferenceStore store, String key) {
        MessageDialogWithToggle d;
        if (!store.getString(key).equals("always") && (d = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)title, (String)message, (String)Messages.DialogUtils_HideMessage, (boolean)false, (IPreferenceStore)store, (String)key)).getReturnCode() == 3) {
            return 1;
        }
        return 0;
    }

    public static int openIgnoreMessageDialogInformation(Shell shell, String title, String message, String dialogKey) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.ui.epl");
        Object[] keys = prefs.get("HiddenMessages", "").split(",");
        Set keysSet = CollectionsUtil.newSet((Object[])keys);
        if (keysSet.contains(dialogKey)) {
            return 1;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)shell, (String)title, (String)message, (String)Messages.DialogUtils_doNotShowMessageAgain, (boolean)false, null, null);
        if (dialog.getReturnCode() == 0 && dialog.getToggleState()) {
            keysSet.add(dialogKey);
            prefs.put("HiddenMessages", StringUtil.join((String)",", (Collection)keysSet));
            try {
                prefs.flush();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
        return dialog.getReturnCode();
    }
}

