/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.program.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.Startup;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.ProgramMainTab;

public class ProgramTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new ProgramMainTab(false), new RefreshTab(), new EnvironmentTab(), new CommonTab(true)};
        this.setTabs(tabs);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String encode;
            if (ProgramTabGroup.isWindows() && configuration instanceof LaunchConfigurationWorkingCopy && (encode = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", null)) == null) {
                ((LaunchConfigurationWorkingCopy)configuration).setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "GB2312");
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.initializeFrom(configuration);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean newConfig = false;
        try {
            newConfig = configuration.getAttribute("editedByExternalToolsMainTab", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.performApply(configuration);
        if (!newConfig) {
            try {
                Startup.getInstance().changeConfiguration((ILaunchConfiguration)configuration);
            }
            catch (Exception e) {
                ExternalToolsPlugin.getDefault().log(e);
            }
        }
    }
}

