/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.internal.keys.BindingService;

public class Startup
implements IStartup,
ILaunchConfigurationListener {
    private Set configCommandIds = new HashSet();
    private static Startup startup = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Startup() {
        startup = this;
    }

    public static Startup getInstance() {
        return startup;
    }

    public void earlyStartup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ICommandService commandService = this.getCommandService();
            Category category = this.getOrDefineCategory(commandService);
            ILaunchConfiguration[] configs = this.getAllConfiguratons(launchManager);
            int i = 0;
            while (i < configs.length) {
                try {
                    ILaunchConfiguration launche = configs[i];
                    Command command = this.getCommand(commandService, launche);
                    if (command != null) {
                        this.defineCommand(category, launche, command);
                    }
                }
                catch (Exception e) {
                    ExternalToolsPlugin.getDefault().log(e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        try {
            launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        }
        catch (Exception e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
    }

    private ILaunchConfiguration[] getAllConfiguratons(ILaunchManager launchManager) throws CoreException {
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(launchType);
        return configs;
    }

    private ICommandService getCommandService() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandService = (ICommandService)iWorkbench.getService((Class)clazz);
        return commandService;
    }

    private Category getOrDefineCategory(ICommandService commandService) {
        Category category = commandService.getCategory("com.pamdora.externaltools");
        if (!category.isDefined()) {
            category.define("\u5916\u90e8\u5de5\u5177", null);
        }
        return category;
    }

    private Command getCommand(ICommandService commandService, ILaunchConfiguration configuration) throws CoreException {
        String commandId = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", "");
        if (commandId != null && !commandId.isEmpty()) {
            return commandService.getCommand(commandId);
        }
        return null;
    }

    private synchronized void defineCommand(Category category, final ILaunchConfiguration launche, Command command) throws Exception {
        String name = "\u5916\u90e8\u5de5\u5177 - " + launche.getName();
        if (!command.isDefined() || !command.getName().equals(name)) {
            if (command.isDefined() && !command.getName().equals(name)) {
                BindingManager bindingManager;
                Binding[] result;
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.keys.IBindingService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((result = (bindingManager = ((BindingService)iWorkbench.getService((Class)clazz)).getBindingManager()).getBindings()) != null) {
                    Binding[] bindings = result;
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$2 = Class.forName("org.eclipse.core.commands.ParameterizedCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Field field = clazz2.getDeclaredField("name");
                    int i = 0;
                    while (i < bindings.length) {
                        ParameterizedCommand parameterizedCommand = bindings[i].getParameterizedCommand();
                        if (parameterizedCommand != null && command.equals((Object)parameterizedCommand.getCommand())) {
                            field.setAccessible(true);
                            field.set(parameterizedCommand, name);
                        }
                        ++i;
                    }
                }
            }
            command.define(name, null, category);
        }
        this.configCommandIds.add(launche.getAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", ""));
        command.setHandler((IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                try {
                    DebugUITools.launch((ILaunchConfiguration)launche, (String)"run");
                }
                catch (Exception e) {
                    ExternalToolsPlugin.getDefault().log(e);
                }
                return Status.OK_STATUS;
            }
        });
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            ICommandService commandService = this.getCommandService();
            Command command = this.getCommand(commandService, configuration);
            if (command != null && !command.isDefined()) {
                this.defineCommand(this.getOrDefineCategory(commandService), configuration, command);
            }
        }
        catch (Exception e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        block10: {
            try {
                if (this.configCommandIds.isEmpty()) break block10;
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfiguration[] configs = this.getAllConfiguratons(launchManager);
                HashSet<String> nowIds = new HashSet<String>();
                int i = 0;
                while (i < configs.length) {
                    nowIds.add(configs[i].getAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", ""));
                    ++i;
                }
                HashSet ids = new HashSet(this.configCommandIds);
                ids.removeAll(nowIds);
                ICommandService commandService = this.getCommandService();
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    BindingManager bindingManager;
                    Binding[] result;
                    String commandId = (String)it.next();
                    Command command = commandService.getCommand(commandId);
                    if (command == null) continue;
                    IWorkbench iWorkbench = PlatformUI.getWorkbench();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.ui.keys.IBindingService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((result = (bindingManager = ((BindingService)iWorkbench.getService((Class)clazz)).getBindingManager()).getBindings()) != null) {
                        Binding[] bindings = result;
                        int i2 = 0;
                        while (i2 < bindings.length) {
                            ParameterizedCommand parameterizedCommand = bindings[i2].getParameterizedCommand();
                            if (parameterizedCommand != null && command.equals((Object)parameterizedCommand.getCommand())) {
                                bindingManager.removeBinding(bindings[i2]);
                            }
                            ++i2;
                        }
                    }
                    command.undefine();
                }
                this.configCommandIds = nowIds;
            }
            catch (Exception e) {
                ExternalToolsPlugin.getDefault().log(e);
            }
        }
    }

    public void changeConfiguration(ILaunchConfiguration configuration) {
        try {
            ICommandService commandService = this.getCommandService();
            Command command = this.getCommand(commandService, configuration);
            if (command != null && command.isDefined()) {
                this.defineCommand(this.getOrDefineCategory(commandService), configuration, command);
            }
        }
        catch (Exception e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
    }
}

