/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.menu;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.LaunchAction;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ExternalToolsContextualLaunchAction
implements IObjectActionDelegate,
IMenuCreator {
    private IAction fDelegateAction;
    private static ILaunchConfigurationType launchType = null;
    private static ILaunchGroup launchGroup = null;
    private boolean fFillMenu = true;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                ExternalToolsContextualLaunchAction.fillMenu(m);
            }
        });
        return menu;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fFillMenu = true;
            if (this.fDelegateAction != action) {
                this.fDelegateAction = action;
                this.fDelegateAction.setMenuCreator((IMenuCreator)this);
            }
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static void fillMenu(Menu menu) {
        if (launchType == null) {
            launchType = ExternalToolsContextualLaunchAction.getLaunchManager().getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        }
        if (launchGroup == null) {
            launchGroup = ExternalToolsContextualLaunchAction.getLaunchConfigurationManager().getLaunchGroup("org.eclipse.ui.externaltools.launchGroup");
        }
        int accelerator = 1;
        try {
            ILaunchConfiguration[] configs = ExternalToolsContextualLaunchAction.getLaunchManager().getLaunchConfigurations(launchType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration launch = configs[i];
                LaunchAction action = new LaunchAction(launch, "run");
                String id = launch.getAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", "");
                if (id != null && !id.isEmpty()) {
                    action.setActionDefinitionId(id);
                }
                ExternalToolsContextualLaunchAction.addToMenu(menu, (IAction)action, accelerator);
                ++accelerator;
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (accelerator > 1) {
            new MenuItem(menu, 2);
        }
        OpenLaunchDialogAction action = new OpenLaunchDialogAction(launchGroup.getIdentifier());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    protected static void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    private static LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }
}

