/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.projects.internal.wizards.Messages;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.page.NewWebProjectWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;

public class NewWebProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = "com.pandora.projects.ui.wizards.NewWebProjectWizard";
    protected NewWebProjectWizardPage newProjectPage = null;

    public void addPages() {
        this.newProjectPage = new NewWebProjectWizardPage("\u521b\u5efaWeb\u9879\u76ee");
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public void createPageControls(Composite pageContainer) {
        Object layoutData = pageContainer.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).grabExcessVerticalSpace = false;
        }
        super.createPageControls(pageContainer);
        IWizardContainer wizardDialog = this.getContainer();
        if (wizardDialog instanceof WizardDialog) {
            try {
                Object object = ReflectUtils.invokeMethod((Object)wizardDialog, (String)"getProgressMonitor");
                if (object instanceof ProgressMonitorPart) {
                    GridData gridData = (GridData)((ProgressMonitorPart)object).getLayoutData();
                    gridData.grabExcessVerticalSpace = false;
                    gridData.verticalAlignment = 0x1000000;
                    gridData.heightHint = 1;
                    gridData.exclude = true;
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
    }

    public boolean performFinish() {
        try {
            final ICreateProjectHandler projectHandler = this.newProjectPage.getProjectHandler();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NewWebProjectWizard.this.runCreateProjectProgress(projectHandler, monitor);
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ProjectException e) {
            e.printStackTrace();
            this.newProjectPage.setErrorMessage(e.getMessage());
        }
        return false;
    }

    protected void runCreateProjectProgress(final ICreateProjectHandler projectHandler, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (NewWebProjectWizard.this.newProjectPage != null) {
                        IProject project = projectHandler.create(monitor);
                        NewWebProjectWizard.this.settingProject(project, monitor);
                        project.refreshLocal(2, monitor);
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e, Messages.AbstractNewProjectWizard_ProjectListener_NoDescriptor_Error);
        }
    }

    protected void setResourceFilter(IProject project, IProgressMonitor monitor) {
        try {
            FileInfoMatcherDescription set = new FileInfoMatcherDescription(FileInfoAttributesMatcher.ID, (Object)this.createFilterArgument("bin"));
            FileInfoMatcherDescription bin = new FileInfoMatcherDescription(FileInfoAttributesMatcher.ID, (Object)this.createFilterArgument("setting"));
            FileInfoMatcherDescription filter = new FileInfoMatcherDescription("org.eclipse.ui.ide.orFilterMatcher", (Object)new FileInfoMatcherDescription[]{set, bin});
            project.createFilter(10, filter, 128, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    protected String createFilterArgument(String path) {
        FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
        argument.key = FileInfoAttributesMatcher.KEY_PROPJECT_RELATIVE_PATH;
        argument.operator = FileInfoAttributesMatcher.OPERATOR_MATCHES;
        argument.pattern = path;
        return FileInfoAttributesMatcher.encodeArguments((FileInfoAttributesMatcher.Argument)argument);
    }

    protected void settingProject(IProject project, IProgressMonitor monitor) {
        ProjectUtils.setJavaScriptVersion((IProject)project, (int)this.newProjectPage.getJavaScriptVersion().getIndex());
        this.setResourceFilter(project, monitor);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("\u521b\u5efaWeb\u9879\u76ee");
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

