/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.wizards;

import com.pandora.core.auth.UserAuth;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.service.ProjectService;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.page.NewHMobileProjectWizardPage;
import com.pandora.projects.ui.wizards.NewWebProjectWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class NewHMobileProjectWizard
extends NewWebProjectWizard {
    public static final String ID = "com.pandora.projects.ui.wizards.NewHMobileProjectWizard";
    private ProjectService projectService = new ProjectService();

    @Override
    public void addPages() {
        this.newProjectPage = new NewHMobileProjectWizardPage("\u521b\u5efa\u79fb\u52a8App");
        this.addPage((IWizardPage)this.newProjectPage);
    }

    @Override
    public boolean performFinish() {
        try {
            String appid = this.createAppid();
            final ICreateProjectHandler projectHandler = this.newProjectPage.getProjectHandler();
            projectHandler.setAppid(appid);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NewHMobileProjectWizard.this.runCreateProjectProgress(projectHandler, monitor);
                }
            });
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.newProjectPage.setErrorMessage(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ProjectException e) {
            e.printStackTrace();
            this.newProjectPage.setErrorMessage(e.getMessage());
        }
        return false;
    }

    protected String createAppid() throws CoreException {
        if (UserAuth.isLoginSucess() == 1) {
            return this.projectService.applyProject(this.newProjectPage.getProjectName());
        }
        return "nologin";
    }

    @Override
    protected void settingProject(IProject project, IProgressMonitor monitor) {
        this.settingProjectProperties(project, monitor);
        ProjectUtils.setJavaScriptVersion((IProject)project, (int)this.newProjectPage.getJavaScriptVersion().getIndex());
        this.setResourceFilter(project, monitor);
    }

    protected void settingProjectProperties(IProject project, IProgressMonitor monitor) {
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("\u521b\u5efa\u79fb\u52a8App");
    }
}

