/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.page;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.aptana.projects.ProjectsPlugin;
import com.pandora.core.JavaScriptVersion;
import com.pandora.core.auth.UserAuth;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.handler.NewAppHandler;
import com.pandora.projects.ui.page.Messages;
import com.pandora.projects.ui.page.NewWebProjectComposite;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NewWebProjectWizardPage
extends WizardPage {
    protected NewWebProjectComposite projectComposite = null;

    public NewWebProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("\u8bf7\u8f93\u5165\u9879\u76ee\u540d\u79f0\u5e76\u4e14\u9009\u62e9\u4e00\u4e2a\u6a21\u677f.");
    }

    public void createControl(Composite parent) {
        ChangedListener listener = new ChangedListener();
        this.projectComposite = this.createPageContentComposite(parent, listener);
        this.setControl((Control)this.projectComposite);
        this.setPageComplete(false);
    }

    protected NewWebProjectComposite createPageContentComposite(Composite parent, ChangedListener listener) {
        List templates = ProjectsPlugin.getDefault().getTemplatesManager().getAllTemplates(new TemplateType[]{TemplateType.WEB});
        return new NewWebProjectComposite(this, parent, 0, templates, listener);
    }

    public ICreateProjectHandler getProjectHandler() {
        IProjectTemplate ptemplate = this.getSelectedProjectTemplate();
        String natureID = "";
        if (ptemplate != null && StringUtil.isNotBlank((String)ptemplate.getNatureID())) {
            natureID = ptemplate.getNatureID();
        }
        String[] natures = new String[]{"com.aptana.projects.webnature"};
        if (Platform.getBundle((String)"com.aptana.editor.php") != null) {
            natures = StringUtil.isNotBlank((String)natureID) ? new String[]{"com.aptana.projects.webnature", "com.aptana.editor.php.phpNature", natureID} : new String[]{"com.aptana.projects.webnature", "com.aptana.editor.php.phpNature"};
        } else if (StringUtil.isNotBlank((String)natureID)) {
            natures = new String[]{"com.aptana.projects.webnature", natureID};
        }
        return new NewAppHandler(this.getProjectName(), this.getCodeLocation(), this.getSelectedProjectTemplate(), natures, new String[]{"com.aptana.ide.core.unifiedBuilder"}, this.getShell());
    }

    public IProjectTemplate getSelectedProjectTemplate() {
        return this.projectComposite.getProjectTemplate();
    }

    public String getProjectName() {
        return this.projectComposite.getProjectNameTxt().getText();
    }

    public String getCodeLocation() {
        return this.projectComposite.getLocationTxt().getText();
    }

    public JavaScriptVersion getJavaScriptVersion() {
        return this.projectComposite.getJavaScriptVersion();
    }

    protected boolean validate() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectName();
        String codelocation = this.getCodeLocation();
        if ("".equals(codelocation)) {
            this.setErrorMessage("\u8bf7\u9009\u62e9\u4e00\u4e2a\u76ee\u5f55\u4fdd\u5b58\u9879\u76ee");
            return false;
        }
        if (!this.isForder(codelocation)) {
            this.setErrorMessage("\u8bf7\u9009\u62e9\u4e00\u4e2a\u76ee\u5f55\u4fdd\u5b58\u9879\u76ee");
            return false;
        }
        if (StringUtil.isEmpty((String)projectFieldContents)) {
            this.setErrorMessage(Messages.NewHMobileProjectWizardPage_6);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectFieldContents);
        if (project.exists()) {
            this.setErrorMessage(Messages.NewHMobileProjectWizardPage_7);
            return false;
        }
        String codeDir = WorkspaceUtil.getCodeDir((String)UserAuth.getUsername());
        if (StringUtil.isEmpty((String)codeDir)) {
            if (workspace.getRoot().getLocation().append(projectFieldContents).makeAbsolute().toFile().exists()) {
                this.setErrorMessage(Messages.NewHMobileProjectWizardPage_8);
                return false;
            }
        } else {
            String projectPath = String.valueOf(codeDir) + File.separator + projectFieldContents;
            File projectFile = new File(projectPath);
            if (projectFile.exists()) {
                this.setErrorMessage(Messages.NewHMobileProjectWizardPage_8);
                return false;
            }
        }
        return true;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(StringUtil.isEmpty((String)newMessage));
    }

    public boolean isForder(String str) {
        File file = new File(str);
        return file.exists() && file.isDirectory();
    }

    protected class ChangedListener
    implements Listener {
        protected ChangedListener() {
        }

        public void handleEvent(Event event) {
            boolean result = NewWebProjectWizardPage.this.validate();
            if (result) {
                NewWebProjectWizardPage.this.setErrorMessage(null);
                NewWebProjectWizardPage.this.setMessage(null);
            }
            NewWebProjectWizardPage.this.setPageComplete(result);
        }
    }
}

