/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.json.JSONUtils;
import com.aptana.editor.json.parsing.ast.JSONParseRootNode;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ui.util.DisplayUtils;
import com.aptana.ui.util.UIUtils;
import com.google.gson.Gson;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.nodejs.NodejsPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class Wechat2AppHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MessageDialog box = this.showMessageDialog(UIUtils.getActiveShell(), "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8f6c\u6362", "\u63a5\u4e0b\u6765\u7684\u64cd\u4f5c\u5c06\u4f1a\u8986\u76d6\u73b0\u6709\u8f6c\u6362\u8fc7\u7684\u4ee3\u7801\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", new String[]{"\u786e\u5b9a", "\u53d6\u6d88"}, 0);
        int selection = box.open();
        if (selection != 0) {
            return null;
        }
        final IProject project = ProjectUtils.getCurrentProject();
        if (project != null) {
            Object dialog;
            String[] from;
            IProjectDescription desc;
            block10: {
                desc = project.getDescription();
                ICommand[] commands = desc.getBuildSpec();
                from = new String[1];
                ICommand weappCommand = null;
                ArrayList<ICommand> builds = new ArrayList<ICommand>();
                if (commands != null) {
                    builds.addAll(Arrays.asList(commands));
                    ICommand[] iCommandArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand cmd = iCommandArray[n2];
                        if ("weapp".equals(cmd.getBuilderName())) {
                            weappCommand = cmd;
                            from[0] = (String)cmd.getArguments().get("from");
                            builds.remove(cmd);
                            break;
                        }
                        ++n2;
                    }
                }
                if (!StringUtil.isEmpty((String)from[0]) && new File(from[0]).exists()) break block10;
                dialog = new DirectoryDialog(UIUtils.getActiveShell(), 0x10000000);
                dialog.setMessage("\u627e\u4e0d\u5230\u4e0a\u6b21\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76ee\u5f55\uff08" + from[0] + "\uff09\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u8be5\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76ee\u5f55");
                dialog.setText("\u8bf7\u91cd\u65b0\u6307\u5b9a\u8be5\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76ee\u5f55");
                String selectedDirectory = dialog.open();
                if (StringUtil.isNotEmpty((String)selectedDirectory) && new File(selectedDirectory).exists()) {
                    from[0] = selectedDirectory;
                    if (weappCommand == null) {
                        weappCommand = desc.newCommand();
                        weappCommand.setBuilderName("weapp");
                    }
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("from", selectedDirectory);
                    weappCommand.setArguments(args);
                    builds.add(weappCommand);
                    desc.setBuildSpec(builds.toArray(new ICommand[0]));
                    break block10;
                }
                return null;
            }
            try {
                dialog = new ProgressMonitorDialog(UIUtils.getActiveShell()){

                    protected Control createDialogArea(Composite parent) {
                        return super.createDialogArea(parent);
                    }
                };
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            project.setDescription(desc, null);
                            Wechat2AppHandler.wechat2app(from[0], project.getLocation().makeAbsolute().toFile().getAbsolutePath(), true, monitor);
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    public MessageDialog showMessageDialog(Shell parent, String title, String message, String[] buttonLabel, int defaultIndex) {
        MessageDialog dialog = new MessageDialog(parent, title, parent.getImage(), message, 2, buttonLabel, defaultIndex);
        return dialog;
    }

    public static void wechat2app(String from, String to, boolean filterManifest, IProgressMonitor monitor) throws Exception {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        File temp = Wechat2AppHandler.getTempTargetDirectory(from);
        try {
            Location location = Platform.getInstallLocation();
            Path toolDir = new Path(location.getURL().getFile());
            if (toolDir.toFile().isDirectory()) {
                toolDir = toolDir.append("tools").append("weapp");
                if (PlatformUtil.isMac()) {
                    File wcsc;
                    File wcc = toolDir.append("wcc").toFile();
                    if (wcc.exists()) {
                        wcc.setExecutable(true);
                    }
                    if ((wcsc = toolDir.append("wcsc").toFile()).exists()) {
                        wcsc.setExecutable(true);
                    }
                }
            }
            String command = NodejsPlugin.getDefault().getNodeExePath();
            ProcessBuilder pb = new ProcessBuilder(command, "index.js", from, temp.getAbsolutePath());
            pb.redirectErrorStream(true);
            pb.directory(toolDir.toFile());
            Process p = pb.start();
            BufferedReader reader = null;
            final ArrayList<String> logs = new ArrayList<String>();
            try {
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (sub.isCanceled()) {
                        p.destroy();
                        break;
                    }
                    logs.add(line);
                    sub.setTaskName(line);
                    sub.worked(15);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (!sub.isCanceled()) {
                final File srcFile = new File(temp, "HBuilderProject");
                File destFile = new File(to);
                if (!srcFile.exists()) {
                    DisplayUtils.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String reason = logs.isEmpty() ? "" : String.valueOf((String)logs.get(logs.size() - 1)) + "\uff0c ";
                            MultiStatus status = new MultiStatus("com.pandora.ui", 1, String.valueOf(reason) + "\u5931\u8d25\u539f\u56e0\u8bf7\u70b9\u51fb\u8be6\u7ec6\u4fe1\u606f\u67e5\u770b", null);
                            for (String log : logs) {
                                status.add((IStatus)new Status(4, "com.pandora.ui", log));
                            }
                            ErrorDialog.openError((Shell)UIUtils.getActiveShell(), (String)"\u8f6c\u6362\u5931\u8d25", (String)"\u5c0f\u7a0b\u5e8f\u8f6c\u6362\u5931\u8d25", (IStatus)status, (int)4);
                        }
                    });
                    throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u8f6c\u6362\u5931\u8d25");
                }
                final boolean filterConfig = new File(destFile, "manifest.json").exists();
                FileUtils.copyDirectory((File)srcFile, (File)destFile, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String fileName = pathname.getName();
                        if (filterConfig && "manifest.json".equals(fileName) && srcFile.equals(pathname.getParentFile())) {
                            return false;
                        }
                        return !".project".equals(fileName);
                    }
                });
                try {
                    sub.setTaskName("\u66f4\u65b0\u9875\u9762\u5f15\u7528\u5173\u7cfb...");
                    Wechat2AppHandler.createWeappPages(srcFile, destFile);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                }
            }
        }
        finally {
            FileUtils.deleteDirectory((File)temp);
        }
    }

    private static void createWeappPages(File srcFile, File destFile) throws Exception {
        String contents;
        File config = new File(destFile, "manifest.json");
        if (!config.exists()) {
            return;
        }
        Gson gson = StreamJsonUtil.createGson();
        Map mc = (Map)gson.fromJson(contents = FileUtils.readFileToString((File)config), Map.class);
        boolean create = !mc.containsKey("dependencies");
        HashMap depens = new HashMap();
        HashMap pages = new HashMap();
        depens.put("pages", pages);
        HashMap launchPage = new HashMap();
        Object launch_path = mc.get("launch_path");
        if (launch_path == null) {
            launch_path = "__weappservice.html";
        }
        pages.put(launch_path, launchPage);
        launchPage.put("href", launch_path);
        launchPage.put("resources", Wechat2AppHandler.getAllResources(srcFile, launch_path));
        depens.put("idle", new HashMap());
        String depensContent = gson.toJson(depens);
        ParseResult result = null;
        try {
            result = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)contents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            return;
        }
        Document document = new Document(contents);
        JSONParseRootNode root = (JSONParseRootNode)result.getRootNode();
        if (create) {
            IParseNode lastChild = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, null);
            StringBuffer sBuffer = new StringBuffer();
            if (lastChild != null) {
                sBuffer.append(",\n\t").append("\"dependencies\"").append(":").append(depensContent.replace("\n", "\n\t"));
                document.replace(lastChild.getEndingOffset() + 1, 0, sBuffer.toString());
            } else {
                LinkedHashMap map = new LinkedHashMap();
                map.put("dependencies", depens);
                document.replace(0, root.getLength(), gson.toJson(map));
            }
        } else {
            IParseNode lastChild = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, (String)"dependencies");
            document.replace(lastChild.getStartingOffset(), lastChild.getLength(), depensContent.replace("\n", "\n\t"));
        }
        FileUtils.writeStringToFile((File)config, (String)document.get());
    }

    private static List<String> getAllResources(File srcFile, Object launchPath) {
        ArrayList<String> result = new ArrayList<String>();
        URI root = srcFile.toURI();
        Stack<File> stack = new Stack<File>();
        stack.push(srcFile);
        while (!stack.isEmpty()) {
            File parent = (File)stack.pop();
            if (parent.isDirectory()) {
                File[] fileArray = parent.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    stack.push(child);
                    ++n2;
                }
                continue;
            }
            if (!parent.isFile()) continue;
            result.add(root.relativize(parent.toURI()).toString());
        }
        result.remove("manifest.json");
        result.remove(".project");
        if (launchPath != null) {
            result.remove(launchPath.toString());
        }
        return result;
    }

    public static File getTempTargetDirectory(String from) {
        String tempConvertPath = String.valueOf(from) + File.separatorChar + ".temp";
        int index = 0;
        File temp = new File(tempConvertPath);
        while (temp.exists()) {
            temp = new File(String.valueOf(tempConvertPath) + index);
            ++index;
        }
        temp.mkdirs();
        return temp;
    }
}

