/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.pandora.core.log.HBLog;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.handler.NewAppHandler;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Shell;

public class NewWap2AppHandler
extends NewAppHandler {
    private String launch;

    public NewWap2AppHandler(String projectName, String location, IProjectTemplate projectTemplate, String[] natureIds, String[] builderIds, Shell shell) {
        super(projectName, location, projectTemplate, natureIds, builderIds, shell);
    }

    @Override
    protected void updateAppConfigFile(IProject project, File file) {
        super.updateAppConfigFile(project, file);
        this.updateWap2appFiles(project);
    }

    @Override
    protected String replaceAppConfigFile(IProject project, String fileText) {
        fileText = super.replaceAppConfigFile(project, fileText);
        fileText = fileText.replaceFirst("\"launch_path\"\\s*\\:\\s*\"[\\w|\\.]*\"", "\"launch_path\":\"" + this.launch + "\"");
        return fileText;
    }

    protected void updateWap2appFiles(IProject project) {
        try {
            File[] files;
            String path;
            String href = this.launch.trim();
            URL uri = new URL(href);
            String domain = uri.getHost();
            int index = domain.lastIndexOf(46) - 1;
            if (index > 0) {
                String string = domain = (index = domain.lastIndexOf(46, index) + 1) > 0 ? domain.substring(index) : domain;
            }
            if ((index = (path = href.substring(href.indexOf("://") + 3)).indexOf("://")) > 0) {
                path = path.substring(index + 3);
            }
            index = path.lastIndexOf(47);
            String url = href;
            String url_with_slash = href;
            if (index == path.length() - 1) {
                url = href.substring(0, href.length() - 1);
            } else if (index > 0) {
                String lastPath = path.substring(index);
                if (!lastPath.matches(".*[\\.\\?\\#\\&]+.*")) {
                    url_with_slash = String.valueOf(href) + "/";
                }
            } else {
                url_with_slash = String.valueOf(href) + "/";
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("{appid}", this.getAppid());
            variables.put("{domain}", domain);
            variables.put("{url}", url);
            variables.put("{url_with_slash}", url_with_slash);
            File projectFile = project.getLocation().makeAbsolute().toFile();
            File[] fileArray = files = projectFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && !pathname.getName().equalsIgnoreCase("manifest.json");
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileText = FileUtils.readFileToString((File)file);
                boolean hasVariable = false;
                for (String key : variables.keySet()) {
                    if (!fileText.contains(key)) continue;
                    fileText = fileText.replace(key, (CharSequence)variables.get(key));
                    hasVariable = true;
                }
                if (hasVariable) {
                    FileUtils.writeStringToFile((File)file, (String)fileText);
                }
                ++n2;
            }
            File cssFile = new File(projectFile, "server_index_append.css");
            if (cssFile.exists()) {
                cssFile.renameTo(new File(projectFile, String.valueOf(this.getAppid()) + ".append.css"));
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void setLaunch(String launch) {
        this.launch = launch;
    }
}

