/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.core.stats.Stats;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.ui.handler.AbstractCreateAppHandler;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.handler.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewAppHandler
extends AbstractCreateAppHandler
implements ICreateProjectHandler {
    protected String projectName = null;
    private IProjectTemplate projectTemplate = null;
    private Shell shell = null;
    private String appid = null;
    private String location = null;
    private String[] natureIds;
    private String[] builderIds;

    public NewAppHandler(String projectName, String location, IProjectTemplate projectTemplate, String[] natureIds, String[] builderIds, Shell shell) {
        this.projectName = projectName;
        this.location = location;
        this.projectTemplate = projectTemplate;
        this.shell = shell;
        this.natureIds = natureIds;
        this.builderIds = builderIds;
    }

    @Override
    public IProject create(IProgressMonitor monitor) throws ProjectException {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(this.projectName);
            if (project.exists()) {
                return project;
            }
            IProjectDescription description = ResourceUtil.getProjectDescription((IPath)this.getCodeDir(workspace, this.projectName, this.location), (String[])this.natureIds, (String[])this.builderIds);
            description.setName(this.projectName);
            description.setComment(Messages.NewAppHandler_0);
            sub.worked(10);
            CreateProjectOperation op = new CreateProjectOperation(description, Messages.NewAppHandler_1);
            try {
                op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
                sub.worked(75);
            }
            catch (ExecutionException e) {
                throw new ProjectException((Throwable)e);
            }
            if (this.projectTemplate != null) {
                this.projectTemplate.apply(project, false);
                Stats.addOperateInfo((String)"template", (String)"NPH", (String)this.projectTemplate.getId());
            }
            if (StringUtil.isNotBlank((String)this.appid)) {
                this.createBasicProject(project, monitor);
            }
            return project;
        }
        catch (Exception e) {
            throw new ProjectException((Throwable)e);
        }
    }

    @Override
    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }
}

