/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.StringUtil;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.ui.handler.NewAppHandler;
import com.pandora.projects.ui.handler.Wechat2AppHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;

public class NewAppFromWechatHandler
extends NewAppHandler {
    private String fWechatPath;

    public NewAppFromWechatHandler(String projectName, String location, IProjectTemplate projectTemplate, String[] natureIds, String[] builderIds, Shell shell) {
        super(projectName, location, projectTemplate, natureIds, builderIds, shell);
    }

    @Override
    protected IProject createBasicProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return project;
    }

    @Override
    public IProject create(IProgressMonitor monitor) throws ProjectException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        IProject project = super.create((IProgressMonitor)sub.newChild(100));
        try {
            String to = project.getLocation().makeAbsolute().toFile().getAbsolutePath();
            Wechat2AppHandler.wechat2app(this.fWechatPath, to, false, (IProgressMonitor)sub.newChild(100));
            IProjectDescription desc = project.getDescription();
            ArrayList<ICommand> builds = new ArrayList<ICommand>(5);
            builds.addAll(Arrays.asList(desc.getBuildSpec()));
            ICommand cmd = desc.newCommand();
            cmd.setBuilderName("weapp");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("from", this.fWechatPath);
            cmd.setArguments(args);
            builds.add(cmd);
            desc.setBuildSpec(builds.toArray(new ICommand[0]));
            project.setDescription(desc, monitor);
            if (StringUtil.isNotBlank((String)this.getAppid())) {
                super.createBasicProject(project, monitor);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            try {
                project.delete(true, monitor);
                throw new ProjectException(e.getMessage());
            }
            catch (CoreException e1) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e1);
            }
        }
        return project;
    }

    public void setWechatPath(String wechatPath) {
        this.fWechatPath = wechatPath;
    }
}

