/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.util.ResourceUtil;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.projects.exception.ProjectException;
import com.pandora.projects.ui.handler.AbstractCreateAppHandler;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import com.pandora.projects.ui.handler.Messages;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewAppFromFolderHandler
extends AbstractCreateAppHandler
implements ICreateProjectHandler {
    private String projectName = null;
    private File localFolder = null;
    private Shell shell = null;
    private String appid = null;

    public NewAppFromFolderHandler(String projectName, File localFolder, Shell shell) {
        this.projectName = projectName;
        this.localFolder = localFolder;
        this.shell = shell;
    }

    @Override
    public IProject create(IProgressMonitor monitor) throws ProjectException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            return project;
        }
        String[] natureIds = null;
        natureIds = new String[]{"com.pandora.projects.ui.MKeyNature", "com.aptana.projects.webnature"};
        IProjectDescription description = ResourceUtil.getProjectDescription((IPath)this.getCodeDir(workspace, this.projectName), (String[])natureIds, (String[])new String[]{"com.pandora.projects.ui.MKeyBuilder", "com.aptana.ide.core.unifiedBuilder"});
        description.setName(this.projectName);
        description.setComment(Messages.NewAppFromFolderHandler_0);
        sub.worked(10);
        CreateProjectOperation op = new CreateProjectOperation(description, Messages.NewAppFromFolderHandler_1);
        try {
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
            sub.worked(75);
            this.createBasicProject(project, monitor);
        }
        catch (Exception e) {
            throw new ProjectException((Throwable)e);
        }
        if (this.localFolder != null && this.localFolder.exists()) {
            try {
                HMobileProject hMobileProject = ProjectUtils.convertToHMobile((IProject)project);
                FileUtils.copyDirectory((File)this.localFolder, (File)hMobileProject.getSourceRoot().makeAbsolute().toFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return project;
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }
}

