/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.handler;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.google.gson.Gson;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.handler.ICreateProjectHandler;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractCreateAppHandler
implements ICreateProjectHandler {
    protected IProject createBasicProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (project == null) {
            return project;
        }
        final IFile appConfigFile = project.getFile("manifest.json");
        if (!appConfigFile.getLocation().makeAbsolute().toFile().exists()) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractCreateAppHandler.this.createAppConfigFile(project, appConfigFile.getLocation().makeAbsolute().toFile());
                }
            }, monitor);
        } else {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractCreateAppHandler.this.updateAppConfigFile(project, appConfigFile.getLocation().makeAbsolute().toFile());
                }
            }, monitor);
        }
        return project;
    }

    protected IPath getCodeDir(IWorkspace workspace, String projectName, String location) {
        IPath codeDir = workspace.getRoot().getLocation().append(projectName);
        String username = UserAuth.getUsername();
        if (StringUtil.isNotEmpty((String)username)) {
            String codeLocation = WorkspaceUtil.getCodeDir((String)username);
            if (codeLocation == null || "".equals(codeLocation)) {
                codeLocation = WorkspaceUtil.getCodeLocation();
            }
            if (!codeLocation.equals(location)) {
                WorkspaceUtil.setNewCodeDir((String)username, (String)location);
                codeLocation = location;
            }
            if (StringUtil.isNotEmpty((String)codeLocation)) {
                codeDir = new Path(codeLocation).append(projectName);
            }
        } else if (StringUtil.isNotBlank((String)location)) {
            codeDir = new Path(location).append(projectName);
        }
        return codeDir;
    }

    protected IPath getCodeDir(IWorkspace workspace, String projectName) {
        String codeLocation;
        IPath codeDir = workspace.getRoot().getLocation().append(projectName);
        String username = UserAuth.getUsername();
        if (StringUtil.isNotEmpty((String)username) && StringUtil.isNotEmpty((String)(codeLocation = WorkspaceUtil.getCodeDir((String)username)))) {
            codeDir = new Path(codeLocation).append(projectName);
        }
        return codeDir;
    }

    protected void updateAppConfigFile(IProject project, File file) {
        try {
            String contents = FileUtils.readFileToString((File)file);
            String result = this.replaceAppConfigFile(project, contents);
            if (result != null) {
                FileUtils.writeStringToFile((File)file, (String)result);
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    protected String replaceAppConfigFile(IProject project, String fileText) {
        String name = project.getName();
        Map ids = CollectionsUtil.newMap((Object[])new String[]{"default", "default", "HelloH5", "HelloH5", "hellomui", "hellomui", "mui_template_login", "mui\u767b\u5f55\u6a21\u677f", "mui_template_nativetab", "nativeObj\u6a21\u5f0f\u5e95\u90e8\u9009\u9879\u5361", "mui", "mui", "mui-login-setting", "mui-login-setting", "CSDN", "CSDN\u8d44\u8baf", "Ratchet", "DCloud_Ratchet", "RADemo", "\u5ba2\u6237\u7ba1\u7406", "__WEAPP_ID", "__WEAPP_NAME", "__W2A__hello.wap2app.liuyingyong.cn", "hello.wap2app.liuyingyong.cn"});
        String result = null;
        for (String id : ids.keySet()) {
            result = this.replaceAppid(fileText, id, (String)ids.get(id), name);
            if (result != null) break;
        }
        return result;
    }

    private String replaceAppid(String contents, String id, String srcName, String destName) {
        if (contents != null && contents.indexOf("\"id\": \"" + id + "\"") >= 0) {
            contents = contents.replace("\"id\": \"" + id + "\"", "\"id\": \"" + (this.getAppid().equals("nologin") ? "" : this.getAppid()) + "\"");
            contents = contents.replace("\"name\": \"" + srcName + "\"", "\"name\": \"" + destName + "\"");
            return contents;
        }
        return null;
    }

    protected boolean createAppConfigFile(IProject project, File appConfigFile) {
        try {
            Gson gson = new Gson();
            ManifastConfiguration configuration = new ManifastConfiguration();
            configuration.setAppid(this.getAppid());
            configuration.setAppName(project.getName());
            Permission permission = new Permission();
            configuration.setPermissions(permission);
            String jsonString = gson.toJson((Object)configuration);
            JSONObject jsonObject = new JSONObject(jsonString);
            jsonString = jsonObject.toString(true);
            FileUtils.writeStringToFile((File)appConfigFile, (String)jsonString);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public abstract String getAppid();
}

