/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.content;

import com.aptana.ide.ui.io.navigator.FileSystemObject;
import com.pandora.core.jslib.LocalFile;
import com.pandora.projects.ui.action.OpenJSLibraryFileAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ProjectExplorerContentProviderWraper
implements ICommonContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Tree tree;
                    if (e.getSource() instanceof Tree && (tree = (Tree)e.getSource()).getSelection().length > 0) {
                        TreeItem treeItem = tree.getSelection()[0];
                        Object obj = treeItem.getData();
                        ProjectExplorerContentProviderWraper.this.handleOpenFileAction(obj);
                    }
                    super.mouseDoubleClick(e);
                }
            });
            viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    Tree tree;
                    super.keyPressed(e);
                    if (e.keyCode != 0x1000050 && e.keyCode != 13) {
                        return;
                    }
                    if (e.getSource() instanceof Tree && (tree = (Tree)e.getSource()).getSelection().length > 0) {
                        TreeItem treeItem = tree.getSelection()[0];
                        Object obj = treeItem.getData();
                        ProjectExplorerContentProviderWraper.this.handleOpenFileAction(obj);
                    }
                }
            });
        }
    }

    protected void handleOpenFileAction(Object data) {
        if (data instanceof IFile) {
            IFile file = (IFile)data;
            if (!"manifest.json".equals(file.getName())) {
                return;
            }
            IProject project = file.getProject();
            try {
                if (!project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"com.aptana.editor.json");
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        } else if (data instanceof LocalFile) {
            this.handleDoubleClickAction((LocalFile)data);
        }
    }

    protected void handleDoubleClickAction(LocalFile obj) {
        if (obj == null) {
            return;
        }
        OpenJSLibraryFileAction openAction = new OpenJSLibraryFileAction(obj);
        openAction.run();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object[] getChildren(Object parentElement) {
        try {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parentElement == null) {
                return null;
            }
            if (parentElement instanceof IContainer) {
                File fContainer;
                File node_modules;
                IProject project;
                IContainer container = (IContainer)parentElement;
                if (container instanceof IProject && !(project = (IProject)container).isOpen()) {
                    return null;
                }
                if (container.findMember("node_modules") == null && container.getParent() != null && (node_modules = new File(fContainer = container.getLocation().makeAbsolute().toFile(), "node_modules")).exists()) {
                    IFileStore store = EFS.getLocalFileSystem().getStore(node_modules.toURI());
                    FileSystemObject fileObj = new FileSystemObject(store, store.fetchInfo());
                    children.add(fileObj);
                }
                children.addAll(Arrays.asList(container.members()));
            } else if (parentElement instanceof FileSystemObject) {
                FileSystemObject nFolder = (FileSystemObject)parentElement;
                if (nFolder.isDirectory()) {
                    IFileStore[] fileStores;
                    IFileStore[] iFileStoreArray = fileStores = nFolder.getFileStore().childStores(0, (IProgressMonitor)new NullProgressMonitor());
                    int n = fileStores.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileStore sto = iFileStoreArray[n2];
                        children.add(new FileSystemObject(sto, sto.fetchInfo()));
                        ++n2;
                    }
                }
            } else {
                if (parentElement instanceof LocalFile) {
                    return null;
                }
                IWorkbenchAdapter adapter = this.getAdapter(parentElement);
                if (adapter != null) {
                    return adapter.getChildren(parentElement);
                }
            }
            return children.toArray(new Object[children.size()]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IWorkbenchAdapter getAdapter(Object element) {
        return (IWorkbenchAdapter)Util.getAdapter((Object)element, IWorkbenchAdapter.class);
    }

    public Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        Object[] children;
        if (element instanceof IFile) {
            return false;
        }
        if (element instanceof IFolder) {
            try {
                IFolder folder = (IFolder)element;
                if (folder.members().length == 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (element instanceof IProject) {
            try {
                IProject project = (IProject)element;
                if (!project.isOpen()) {
                    return false;
                }
                if (project.members().length <= 1) {
                    return false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((children = this.getChildren(element)) == null) {
            return false;
        }
        return children.length > 0;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

