/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util.plist;

import com.pandora.launcher.core.iphone.util.plist.ArrayElement;
import com.pandora.launcher.core.iphone.util.plist.BooleanElement;
import com.pandora.launcher.core.iphone.util.plist.DataElement;
import com.pandora.launcher.core.iphone.util.plist.DateElement;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.IntegerElement;
import com.pandora.launcher.core.iphone.util.plist.JPlistBuilder;
import com.pandora.launcher.core.iphone.util.plist.KeyElement;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.launcher.core.iphone.util.plist.PListSerializer;
import com.pandora.launcher.core.iphone.util.plist.RealElement;
import com.pandora.launcher.core.iphone.util.plist.StringElement;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

public class XMLPListSerializer
implements PListSerializer {
    private static final XMLPListSerializer _INSTANCE = new XMLPListSerializer();

    public static void main(String[] args) {
        PList plist = JPlistBuilder.buildPList(new File("0.shsh"));
        XMLPListSerializer serializer = new XMLPListSerializer();
        String out = serializer.serialize(plist, "\t");
        System.out.println(out);
    }

    public static XMLPListSerializer get() {
        return _INSTANCE;
    }

    @Override
    public String serialize(PList plist) {
        return this.serialize(plist, "\t");
    }

    @Override
    public String serialize(PList plist, String indentString) {
        StringBuilder sb = new StringBuilder(this.getHeader());
        sb.append(this._serialize(plist, 0, indentString));
        return sb.toString();
    }

    private String getHeader() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        return sb.toString();
    }

    private String _serialize(PElement pElement, int indentLevel, String indentString) {
        PElementType vType = pElement.getType();
        StringBuffer sb = new StringBuffer();
        sb.append(this.doIndent(indentLevel, indentString));
        switch (vType) {
            case PLIST: {
                sb.append("<plist version=\"1.0\">");
                sb.append(this._serialize(((PList)pElement).getValue(), indentLevel, indentString));
                sb.append(this.doIndent(indentLevel, indentString));
                sb.append("</plist>");
                break;
            }
            case ARRAY: {
                sb.append("<array>");
                Object children = ((ArrayElement)pElement).getValue();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    PElement child = (PElement)iterator.next();
                    sb.append(this._serialize(child, indentLevel + 1, indentString));
                }
                sb.append(this.doIndent(indentLevel, indentString));
                sb.append("</array>");
                break;
            }
            case BOOLEAN: {
                sb.append(((BooleanElement)pElement).getValue() != false ? "<true />" : "<false />");
                break;
            }
            case KEY: {
                sb.append("<key>");
                sb.append(((StringElement)pElement).getValue());
                sb.append("</key>");
                break;
            }
            case STRING: {
                sb.append("<string>");
                sb.append(((StringElement)pElement).getValue());
                sb.append("</string>");
                break;
            }
            case INTEGER: {
                sb.append("<integer>");
                sb.append(((IntegerElement)pElement).getValue());
                sb.append("</integer>");
                break;
            }
            case DATA: {
                String dValue = this.chop(((DataElement)pElement).getValue().replaceAll("\\s", ""), 60, indentLevel + 1, indentString);
                sb.append("<data>");
                sb.append(dValue);
                if (dValue.indexOf(10) > -1) {
                    sb.append(this.doIndent(indentLevel, indentString));
                }
                sb.append("</data>");
                break;
            }
            case DICTIONARY: {
                sb.append("<dict>");
                Object dict = ((DictionaryElement)pElement).getValue();
                for (Map.Entry entry : dict.entrySet()) {
                    sb.append(this._serialize(new KeyElement((String)entry.getKey()), indentLevel + 1, indentString));
                    sb.append(this._serialize((PElement)entry.getValue(), indentLevel + 1, indentString));
                }
                sb.append(this.doIndent(indentLevel, indentString));
                sb.append("</dict>");
                break;
            }
            case REAL: {
                sb.append("<real>");
                sb.append(((RealElement)pElement).getValue());
                sb.append("</real>");
                break;
            }
            case DATE: {
                sb.append("<date>");
                sb.append(((DateElement)pElement).getValue());
                sb.append("</date>");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Value:" + pElement);
            }
        }
        return sb.toString();
    }

    private String chop(String value, int limit, int level, String indentString) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            if (i + limit < value.length() || value.length() > limit) {
                sb.append(this.doIndent(level, indentString));
            }
            if (i + limit > value.length()) {
                sb.append(value.substring(i));
            } else {
                sb.append(value.substring(i, i + limit));
            }
            i += limit;
        }
        return sb.toString();
    }

    private String doIndent(int level, String indentString) {
        StringBuilder sb = new StringBuilder(level * indentString.length() * level);
        sb.append("\n");
        while (level-- > 0) {
            sb.append(indentString);
        }
        return sb.toString();
    }
}

