/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util.plist;

import com.pandora.launcher.core.iphone.fw.DeviceHardware;
import com.pandora.launcher.core.iphone.fw.DeviceOSVersion;
import com.pandora.launcher.core.iphone.fw.SHSHKeys;
import com.pandora.launcher.core.iphone.util.plist.BooleanElement;
import com.pandora.launcher.core.iphone.util.plist.DataElement;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.IntegerElement;
import com.pandora.launcher.core.iphone.util.plist.JPlistBuilder;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.launcher.core.iphone.util.plist.StringElement;
import com.sun.jna.Platform;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import sun.misc.BASE64Decoder;

public class PListUtil {
    private static Map<String, Set<DeviceOSVersion>> digestVersionMapping = new HashMap<String, Set<DeviceOSVersion>>();

    static {
        DeviceOSVersion[] deviceOSVersionArray = DeviceOSVersion.values();
        int n = deviceOSVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceOSVersion ver = deviceOSVersionArray[n2];
            if (ver.getManifestFile() != null) {
                PList manifest = JPlistBuilder.buildPList(PListUtil.class.getResourceAsStream("/com/semaphore/data/BuildManifest-" + ver.getManifestFile() + ".plist"));
                SHSHKeys[] sHSHKeysArray = SHSHKeys.values();
                int n3 = sHSHKeysArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SHSHKeys key = sHSHKeysArray[n4];
                    if (manifest.get("BuildIdentities").get(0).get("Manifest").asDict().containsKey(key.name())) {
                        String[] stringArray = key.digests();
                        int n5 = stringArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String digest = stringArray[n6];
                            if (manifest.get("BuildIdentities").get(0).get("Manifest").get(key.name()).asDict().containsKey(digest)) {
                                String pdigest = manifest.get("BuildIdentities").get(0).get("Manifest").get(key.name()).get(digest).asData();
                                Set<Object> oses = digestVersionMapping.containsKey(pdigest = pdigest.replaceAll("\\s", "")) ? digestVersionMapping.get(pdigest) : new HashSet();
                                boolean add = true;
                                for (DeviceOSVersion deviceOSVersion : oses) {
                                    if (!deviceOSVersion.getManifestFile().equals(ver.getManifestFile())) continue;
                                    add = false;
                                    break;
                                }
                                if (add) {
                                    oses.add((Object)ver);
                                }
                                digestVersionMapping.put(pdigest, oses);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        PList plist = JPlistBuilder.buildPList(new File("/Users/semaphore/.shsh/2142217631220-ipad-3.2.shsh"));
        DeviceOSVersion version = PListUtil.getVersion(plist);
        System.out.println((Object)version);
        System.out.println(PListUtil.validateSHSH(plist, DeviceOSVersion.iPAD_3_2));
    }

    private static long decodeEcid(String shsh) {
        BASE64Decoder dec = new BASE64Decoder();
        try {
            byte[] data = dec.decodeBuffer(shsh.replaceAll("\\s", ""));
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.position(12);
            return buffer.getLong();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private static String decodeFirstTag(String shsh) {
        BASE64Decoder dec = new BASE64Decoder();
        try {
            byte[] data = dec.decodeBuffer(shsh.replaceAll("\\s", ""));
            ByteBuffer buffer = ByteBuffer.wrap(data);
            byte[] tag = new byte[4];
            buffer.get(tag, 0, 4);
            return new String(tag).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getECID(PList plist) {
        try {
            SHSHKeys[] sHSHKeysArray = SHSHKeys.values();
            int n = sHSHKeysArray.length;
            int n2 = 0;
            while (n2 < n) {
                SHSHKeys value = sHSHKeysArray[n2];
                if (plist.getValue().containsKey(value.name())) {
                    String blob = plist.getValue().get(value.name()).get("Blob").asData();
                    return String.valueOf(PListUtil.decodeEcid(blob));
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public static PList createSHSHRequest(DeviceOSVersion version, String ecid) {
        PList request = new PList();
        DictionaryElement dict = request.getValue();
        PList requestVersion = JPlistBuilder.buildPList(PListUtil.class.getResourceAsStream("/com/semaphore/data/BuildManifest-" + version.getManifestFile() + ".plist"));
        PListUtil.addHeaders(version, dict, ecid, requestVersion);
        PListUtil.addBlobs(dict, requestVersion);
        return request;
    }

    public static PList create4SHSHRequest(DeviceOSVersion version, String ecid, int goldCertId, String bbSerial) {
        PList request = new PList();
        DictionaryElement dict = request.getValue();
        PList requestVersion = JPlistBuilder.buildPList(PListUtil.class.getResourceAsStream("/com/semaphore/data/BuildManifest-" + version.getManifestFile() + ".plist"));
        PListUtil.addHeaders(version, dict, ecid, requestVersion);
        PListUtil.addBlobs(dict, requestVersion);
        PListUtil.addBBHeaders(version, dict, ecid, goldCertId, bbSerial, requestVersion);
        return request;
    }

    private static void addBBHeaders(DeviceOSVersion version, DictionaryElement dict, String ecid, int goldCertId, String bbSerial, PList manifest) {
        dict.put("BbChipID", new IntegerElement(PListUtil.getBbChipId(manifest)));
        dict.put("BbGoldCertId", new IntegerElement(goldCertId));
        dict.put("BbSNUM", new DataElement(bbSerial));
        dict.put("BbSkeyId", PListUtil.getBbSkeyId(manifest));
        String uniqueBuildId = PListUtil.getUniqueBuildID(manifest);
        if (uniqueBuildId.length() > 0) {
            dict.put("UniqueBuildID", new DataElement(uniqueBuildId));
        }
    }

    private static void addBlobs(DictionaryElement dict, PList manifest) {
        SHSHKeys[] sHSHKeysArray = SHSHKeys.values();
        int n = sHSHKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            SHSHKeys key = sHSHKeysArray[n2];
            if (PListUtil.getBuildIdentities(manifest).get(0).get("Manifest").asDict().containsKey(key.name())) {
                DictionaryElement value = (DictionaryElement)PListUtil.getBuildIdentities(manifest).get(0).get("Manifest").get(key.name());
                value.remove("Info");
                dict.put(key.name(), value);
            }
            ++n2;
        }
    }

    private static void addHeaders(DeviceOSVersion version, DictionaryElement dict, String ecid, PList manifest) {
        if (version.is40Version()) {
            dict.put("@APTicket", new BooleanElement(true));
            dict.put("@BBTicket", new BooleanElement(true));
        }
        dict.put("@HostIpAddress", new StringElement("192.168.0.1"));
        dict.put("@HostPlatformInfo", new StringElement(PListUtil.getPlatform()));
        if (version.getHardware() != DeviceHardware.iPhone4) {
            dict.put("@Locality", new StringElement(Locale.getDefault() == null ? "en_US" : Locale.getDefault().toString()));
        }
        dict.put("@VersionInfo", version.is40Version() ? new StringElement("libauthinstall-34") : new StringElement("3.8"));
        dict.put("ApBoardID", new IntegerElement(PListUtil.getBoardId(manifest)));
        dict.put("ApChipID", new IntegerElement(PListUtil.getChipID(manifest)));
        dict.put("ApECID", new StringElement(ecid));
        dict.put("ApProductionMode", new BooleanElement(true));
        dict.put("ApSecurityDomain", new IntegerElement(1));
        String uniqueBuildId = PListUtil.getUniqueBuildID(manifest);
        if (version.getHardware() != DeviceHardware.iPhone4 && uniqueBuildId.length() > 0) {
            dict.put("UniqueBuildID", new DataElement(uniqueBuildId));
        }
    }

    private static PElement getBbSkeyId(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("BbSkeyId");
    }

    private static String getBbChipId(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("BbChipID").asString();
    }

    private static PElement getBbSkeyID(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("BbSkeyId");
    }

    private static PElement getBbChipID(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("BbChipID");
    }

    private static List<PElement> getBuildIdentities(PList manifest) {
        return manifest.get("BuildIdentities").asArray();
    }

    private static String getUniqueBuildID(PList manifest) {
        Map<String, PElement> dict = PListUtil.getBuildIdentities(manifest).get(0).asDict();
        return dict.containsKey("UniqueBuildID") ? dict.get("UniqueBuildID").asData() : "";
    }

    private static String getChipID(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("ApChipID").asString();
    }

    private static String getBoardId(PList manifest) {
        return PListUtil.getBuildIdentities(manifest).get(0).get("ApBoardID").asString();
    }

    public static String getPlatform() {
        if (Platform.isMac()) {
            return "darwin";
        }
        return "windows";
    }

    public static boolean validateSHSH(PList shsh, DeviceOSVersion version) {
        DeviceOSVersion ver = PListUtil.getVersion(shsh);
        return ver == version || ver.getManifestFile().equals(version.getManifestFile());
    }

    public static DeviceOSVersion getVersion(PList shsh) {
        SHSHKeys[] sHSHKeysArray = SHSHKeys.values();
        int n = sHSHKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            SHSHKeys key = sHSHKeysArray[n2];
            if (shsh.getValue().containsKey(key.name())) {
                String[] stringArray = key.digests();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String digest = stringArray[n4];
                    if (shsh.getValue().get(key.name()).asDict().containsKey(digest)) {
                        Set<DeviceOSVersion> oses;
                        String pdigest = shsh.getValue().get(key.name()).get(digest).asData();
                        if (digestVersionMapping.containsKey(pdigest = pdigest.replaceAll("\\s", "")) && (oses = digestVersionMapping.get(pdigest)).size() == 1) {
                            return oses.iterator().next();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return DeviceOSVersion.UNKNOWN;
    }
}

