/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util.plist;

import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.iphone.util.plist.PElementAdapter;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateElement
extends PElementAdapter<String> {
    private static SimpleDateFormat iso_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Date value;

    public DateElement(String date) {
        try {
            if (StringUtil.isNotBlank((String)date)) {
                this.value = iso_8601.parse(date);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad Date Format: must be \"yyyy-MM-dd'T'HH:mm:ss\"");
        }
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return iso_8601.format(this.value);
    }

    @Override
    public void setValue(String value) {
        try {
            if (StringUtil.isNotBlank((String)value)) {
                this.value = iso_8601.parse(value);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad Date Format: must be \"yyyy-MM-dd'T'HH:mm:ss\"");
        }
    }

    @Override
    public PElementType getType() {
        return PElementType.DATE;
    }

    public String toString() {
        return "date : " + this.value;
    }
}

