/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util;

import com.pandora.launcher.core.iphone.util.StringUtil;
import com.pandora.launcher.core.iphone.util.plist.JPlistBuilder;
import com.pandora.launcher.core.iphone.util.plist.PList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class KeyUtil {
    private static PublicKey pubKey;
    private static SecretKeySpec aesKey;
    private static BASE64Encoder encoder;
    private static BASE64Decoder decoder;
    private static final String PROVIDER = "RSA";
    private static final int CHUNK = 256;

    static {
        encoder = new BASE64Encoder();
        decoder = new BASE64Decoder();
        PList encryptionKeyPList = JPlistBuilder.buildPList(StringUtil.class.getResourceAsStream("/com/semaphore/data/key.plist"));
        pubKey = KeyUtil.deserializePublicKey(encryptionKeyPList.get("PubKey").asData().replaceAll("\\s*", ""));
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            aesKey = new SecretKeySpec(raw, "AES");
        }
        catch (Exception exception) {}
    }

    private static byte[] encrypt(byte[] inpBytes) throws Exception {
        Cipher cipher = Cipher.getInstance(PROVIDER);
        cipher.init(1, pubKey);
        return cipher.doFinal(inpBytes);
    }

    public static String decrypt(String message, SecretKeySpec key) {
        try {
            if (key == null) {
                key = aesKey;
            }
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            message = new String(decoder.decodeBuffer(message), "ISO-8859-1");
            return new String(cipher.doFinal(message.getBytes("ISO-8859-1")), "ISO-8859-1");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String encrypt(String message) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            return encoder.encode(cipher.doFinal(message.getBytes("ISO-8859-1")));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String encryptKey() {
        try {
            byte[] enc = KeyUtil.encrypt(aesKey.getEncoded());
            return encoder.encode(enc);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static SecretKeySpec decryptKey(String key, PrivateKey pkey) {
        try {
            key = new String(decoder.decodeBuffer(key), "ISO-8859-1");
            return new SecretKeySpec(KeyUtil.decrypt(key.getBytes("ISO-8859-1"), pkey), "AES");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String olddecrypt(String message, PrivateKey key) {
        StringBuilder sb = new StringBuilder();
        try {
            BASE64Decoder dec = new BASE64Decoder();
            String nmsg = new String(dec.decodeBuffer(message));
            ByteBuffer buffer = ByteBuffer.allocate(nmsg.length());
            if (nmsg.length() > 256) {
                String[] splits;
                String[] stringArray = splits = nmsg.split("\u0000[\r]?\n[\r]?\n\u0000");
                int n = splits.length;
                int n2 = 0;
                while (n2 < n) {
                    String split = stringArray[n2];
                    buffer.put(KeyUtil.decrypt(split.getBytes(), key));
                    ++n2;
                }
                String str = new String(buffer.array());
                sb.append(str);
            } else {
                String str = new String(KeyUtil.decrypt(nmsg.getBytes(), key));
                sb.append(str);
            }
            return sb.toString().trim();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return "";
        }
    }

    public static String oldencrypt(String message) {
        try {
            BASE64Encoder enc = new BASE64Encoder();
            StringBuilder sb = new StringBuilder();
            if (message.length() > 256) {
                String str;
                ByteBuffer buffer = ByteBuffer.allocate(message.length());
                int iters = message.length() / 256;
                int rem = message.length() % 256;
                buffer.put(message.getBytes());
                byte[] dst = new byte[256];
                buffer.position(0);
                while (iters-- > 0) {
                    buffer.get(dst, 0, 256);
                    str = new String(KeyUtil.encrypt(dst));
                    sb.append(str).append("\u0000\n\n\u0000");
                }
                dst = new byte[rem];
                buffer.get(dst, 0, rem);
                str = new String(KeyUtil.encrypt(dst));
                sb.append(str);
            } else {
                sb.append(KeyUtil.encrypt(message.getBytes()));
            }
            String sbb = sb.toString();
            return enc.encode(sbb.getBytes());
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return "";
        }
    }

    private static String chop(String value, int limit, int level, String indentString) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            if ((i + limit < value.length() || value.length() > limit) && sb.length() > 0) {
                sb.append(KeyUtil.doIndent(level, indentString));
            }
            if (i + limit > value.length()) {
                sb.append(value.substring(i));
            } else {
                sb.append(value.substring(i, i + limit));
            }
            i += limit;
        }
        return sb.toString();
    }

    private static String doIndent(int level, String indentString) {
        StringBuilder sb = new StringBuilder(level * indentString.length() * level);
        sb.append("\u0000\u0000\u0000");
        while (level-- > 0) {
            sb.append(indentString);
        }
        return sb.toString();
    }

    public static byte[] decrypt(byte[] inpBytes, PrivateKey key) throws Exception {
        Cipher cipher = Cipher.getInstance(PROVIDER);
        cipher.init(2, key);
        return cipher.doFinal(inpBytes);
    }

    public static PublicKey deserializePublicKey(String s) {
        try {
            byte[] abyte0 = KeyUtil.stringToBytes(s);
            X509EncodedKeySpec x509encodedkeyspec = new X509EncodedKeySpec(abyte0);
            KeyFactory keyfactory = KeyFactory.getInstance(PROVIDER);
            return keyfactory.generatePublic(x509encodedkeyspec);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static PrivateKey deserializePrivateKey(String s) throws IOException {
        try {
            byte[] abyte0 = KeyUtil.stringToBytes(s);
            PKCS8EncodedKeySpec pkcs8encodedkeyspec = new PKCS8EncodedKeySpec(abyte0);
            KeyFactory keyfactory = KeyFactory.getInstance(PROVIDER);
            return keyfactory.generatePrivate(pkcs8encodedkeyspec);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static byte[] stringToBytes(String s) throws Exception {
        return new BASE64Decoder().decodeBuffer(s);
    }
}

