/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.img3;

import com.pandora.launcher.core.iphone.jna.img3.Img3Container;
import com.pandora.launcher.core.iphone.jna.img3.Img3Element;
import com.pandora.launcher.core.iphone.jna.img3.Img3ElementHeader;
import com.pandora.launcher.core.iphone.jna.img3.Img3ElementType;
import com.pandora.launcher.core.iphone.jna.img3.Img3File;
import com.pandora.launcher.core.iphone.jna.img3.Img3Header;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public class Img3Reader {
    private Logger log = Logger.getLogger("Img3Reader");
    private ByteBuffer buffer;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType;

    public Img3Reader(String data) {
        this.buffer = ByteBuffer.wrap(data.getBytes());
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public Img3Reader(ByteBuffer data) {
        this.buffer = data;
    }

    public void replaceSignature(Img3File file, Img3Reader data) {
        Img3Element ecid = data.readImg3Element();
        Img3Element shsh = data.readImg3Element();
        Img3Element cert = data.readImg3Element();
        file.ecid_element = ecid;
        file.shsh_element = shsh;
        file.cert_element = cert;
    }

    public Img3Header readImg3Header() {
        Img3Header hdr = new Img3Header();
        hdr.signature = Img3Container.getType(this.buffer.getInt());
        hdr.full_size = this.buffer.getInt();
        hdr.data_size = this.buffer.getInt();
        hdr.shsh_offset = this.buffer.getInt();
        hdr.image_type = this.buffer.getInt();
        return hdr;
    }

    public Img3ElementHeader readImg3ElementHeader() {
        return this.readImg3ElementHeader(this.buffer);
    }

    public Img3ElementHeader readImg3ElementHeader(ByteBuffer buffer) {
        Img3ElementHeader hdr = new Img3ElementHeader();
        hdr.signature = Img3ElementType.getType(buffer.getInt());
        hdr.full_size = buffer.getInt();
        hdr.data_size = buffer.getInt();
        return hdr;
    }

    public Img3Element readImg3Element() {
        Img3Element element = new Img3Element();
        Img3ElementHeader hdr = this.readImg3ElementHeader();
        byte[] dst = new byte[hdr.full_size];
        this.buffer.get(dst);
        element.data = ByteBuffer.wrap(dst).order(ByteOrder.nativeOrder());
        element.header = this.readImg3ElementHeader(element.data);
        element.type = hdr.signature;
        return element;
    }

    /*
     * Unable to fully structure code
     */
    public Img3File readImg3File() {
        file = new Img3File();
        file.header = this.readImg3Header();
        if (file.header.signature == Img3Container.kImg3Container) ** GOTO lbl46
        return null;
lbl-1000:
        // 1 sources

        {
            current = this.readImg3ElementHeader();
            switch (Img3Reader.$SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType()[current.signature.ordinal()]) {
                case 2: {
                    file.type_element = this.readImg3Element();
                    this.log.info("Parsed TYPE Element.");
                    break;
                }
                case 1: {
                    file.data_element = this.readImg3Element();
                    this.log.info("Parsed DATA Element.");
                    break;
                }
                case 9: {
                    file.vers_element = this.readImg3Element();
                    this.log.info("Parsed VERS Element.");
                    break;
                }
                case 11: {
                    file.sepo_element = this.readImg3Element();
                    this.log.info("Parsed SEPO Element.");
                    break;
                }
                case 10: {
                    file.bord_element = this.readImg3Element();
                    this.log.info("Parsed BORD Element.");
                    break;
                }
                case 3: {
                    if (file.kbag1_element == null) {
                        file.kbag1_element = this.readImg3Element();
                        this.log.info("Parsed KBAG1 Element.");
                        break;
                    }
                    file.kbag2_element = this.readImg3Element();
                    this.log.info("Parsed KBAG2 Element.");
                    break;
                }
                case 12: {
                    file.ecid_element = this.readImg3Element();
                    this.log.info("Parsed ECID Element.");
                    break;
                }
                case 4: {
                    file.shsh_element = this.readImg3Element();
                    this.log.info("Parsed SHSH Element.");
                    break;
                }
                case 5: {
                    file.cert_element = this.readImg3Element();
                    this.log.info("Parsed CERT Element.");
                }
            }
lbl46:
            // 12 sources

            ** while (this.buffer.remaining() > 0)
        }
lbl47:
        // 1 sources

        return file;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType() {
        if ($SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType != null) {
            return $SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType;
        }
        int[] nArray = new int[Img3ElementType.values().length];
        try {
            nArray[Img3ElementType.INVALID.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kBordElement.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kCertElement.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kChipElement.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kDataElement.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kEcidElement.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kKbagElement.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kProdElement.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kSdomElement.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kSepoElement.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kShshElement.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kTypeElement.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Img3ElementType.kVersElement.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$pandora$launcher$core$iphone$jna$img3$Img3ElementType = nArray;
        return nArray;
    }
}

