/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.idevice.linux;

import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.iphone.jna.idevice.IApplicationLogHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IDevice;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceLibrary;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.ILookupApplicationsNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IScheduleHandler;
import com.pandora.launcher.core.iphone.jna.idevice.linux.LinuxDevice;
import com.pandora.launcher.core.iphone.jna.idevice.win.AFCConnection;
import com.pandora.launcher.core.iphone.jna.md.LinMDLibrary;
import com.pandora.launcher.core.iphone.jna.md.MDLibrary;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LinuxDeviceLibrary
implements IDeviceLibrary,
LinMDLibrary.idevice_event_cb_t {
    private Logger log = Logger.getLogger("LinuxDeviceLibrary");
    protected Map<String, PList> devices = new HashMap<String, PList>();
    private IDeviceNotificationHandler handler;

    @Override
    public void addNotificationHandler(IDeviceNotificationHandler callback) {
        this.handler = callback;
        LinMDLibrary.INSTANCE.idevice_event_subscribe(this, Pointer.NULL);
    }

    @Override
    public void addLookupApplicationsNotificationHandler(IDevice device, ILookupApplicationsNotificationHandler callback) {
    }

    @Override
    public AFCConnection addStartServiceHandler(IDevice device, String serviceName) {
        return null;
    }

    @Override
    public AFCConnection addOpenAFCConnectionHandler(AFCConnection afc_service) {
        return null;
    }

    @Override
    public void invoke(LinMDLibrary.idevice_event_t event, Pointer user_data) {
        int msg = event.event;
        String uuid = event.uuid;
        if (msg == 1) {
            String[] uuids;
            PointerByReference pdev = new PointerByReference();
            IntBuffer plen = IntBuffer.allocate(1);
            if (LinMDLibrary.INSTANCE.idevice_get_device_list(pdev, plen) != 0) {
                return;
            }
            String[] stringArray = uuids = pdev.getValue().getStringArray(0L);
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String puuid = stringArray[n2];
                if (puuid.equalsIgnoreCase(uuid)) {
                    this.doHandshake(uuid);
                }
                ++n2;
            }
        } else {
            PList deviceInfo = this.devices.remove(uuid);
            this.handler.onDeviceDisconnected(null, deviceInfo);
        }
    }

    private void doHandshake(String uuid) {
        LinMDLibrary.pidevice_int pidevice = new LinMDLibrary.pidevice_int();
        LinMDLibrary.plockdownd_client_int pclient = new LinMDLibrary.plockdownd_client_int();
        if (LinMDLibrary.INSTANCE.idevice_new(pidevice, uuid) != 0) {
            this.log.severe("ERROR: new idevice...");
            return;
        }
        LinMDLibrary.idevice_int idevice = pidevice.getDevice();
        if (LinMDLibrary.INSTANCE.lockdownd_client_new_with_handshake(idevice, pclient, "HBuilder") != 0) {
            this.log.severe("ERROR: lockdownd handshake...");
            return;
        }
        LinMDLibrary.lockdownd_client_int client = pclient.getClient();
        LinuxDevice ld = new LinuxDevice(idevice, client);
        PList deviceInfo = ld.getDeviceInfo();
        this.devices.put(uuid, deviceInfo);
        this.handler.onDeviceConnected(ld, deviceInfo);
    }

    public MDLibrary.afc_file_ref addAFCFileRefOpenHandler(AFCConnection afc_conn) {
        return null;
    }

    @Override
    public void addAMDeviceInstallApplicationHandler(AFCConnection afcConnection, String path, IScheduleHandler iScheduleHandler) throws OperateException {
    }

    @Override
    public void handleDisconnect(IDevice device) {
    }

    @Override
    public void handleConnect(IDevice device, boolean needCheck) {
    }

    @Override
    public void addAMDeviceTransferApplicationHandler(AFCConnection afcConnection, String path, IScheduleHandler iScheduleHandler) throws OperateException {
    }

    @Override
    public void addAFCRemovePathHandler(AFCConnection afc_service, String filePath, String appid, Set<String> refrences, Apps app) throws OperateException {
    }

    @Override
    public void sendRestartCmd(AFCConnection connection, Apps app) {
    }

    @Override
    public AFCConnection addStartHouseArrestServiceHandler(IDevice device, String serviceName) {
        return null;
    }

    @Override
    public void addAFCFileRefWriteHandler(AFCConnection afc_connection2, String libraryPath, String localPath, Apps app) {
    }

    @Override
    public void addAFCFileWriteHandler(AFCConnection connection, String appid, String resourcePath, String targetPath, Set<String> refrences, Apps app) throws OperateException {
    }

    @Override
    public void addAMDeviceUnInstallApplicationHandler(AFCConnection afcConnection, String path, IScheduleHandler iScheduleHandler) throws OperateException {
    }

    @Override
    public void addAFCFileReadHandler(AFCConnection afc_connection2, String path, IApplicationLogHandler handler) throws OperateException {
    }
}

