/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.cf;

import com.pandora.launcher.core.iphone.jna.cf.CFType;
import com.pandora.launcher.core.iphone.jna.md.LibraryInstance;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;

public class CFString
extends CFType {
    public CFString(Pointer address) {
        super(address);
    }

    public CFString() {
    }

    public static CFString buildString(String str) {
        return LibraryInstance.getCFLibrary().__CFStringMakeConstantString(str);
    }

    public String getString() {
        int lengthInChars = LibraryInstance.getCFLibrary().CFStringGetLength(this).intValue();
        NativeLong potentialLengthInBytes = new NativeLong((long)(3 * lengthInChars + 1));
        ByteBuffer buffer = ByteBuffer.allocate(potentialLengthInBytes.intValue());
        boolean ok = LibraryInstance.getCFLibrary().CFStringGetCString(this, buffer, potentialLengthInBytes, 0x8000100);
        if (!ok) {
            throw new RuntimeException("Could not convert string");
        }
        return Native.toString((byte[])buffer.array());
    }
}

