/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.cf;

import com.pandora.launcher.core.iphone.jna.cf.CFArray;
import com.pandora.launcher.core.iphone.jna.cf.CFBoolean;
import com.pandora.launcher.core.iphone.jna.cf.CFData;
import com.pandora.launcher.core.iphone.jna.cf.CFDate;
import com.pandora.launcher.core.iphone.jna.cf.CFLibrary;
import com.pandora.launcher.core.iphone.jna.cf.CFNumber;
import com.pandora.launcher.core.iphone.jna.cf.CFString;
import com.pandora.launcher.core.iphone.jna.cf.CFType;
import com.pandora.launcher.core.iphone.jna.md.LibraryInstance;
import com.pandora.launcher.core.iphone.util.plist.ArrayElement;
import com.pandora.launcher.core.iphone.util.plist.BooleanElement;
import com.pandora.launcher.core.iphone.util.plist.DataElement;
import com.pandora.launcher.core.iphone.util.plist.DateElement;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.IntegerElement;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PElementAdapter;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.launcher.core.iphone.util.plist.StringElement;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import sun.misc.BASE64Encoder;

public class CFDictionary
extends CFType {
    private BASE64Encoder enc = new BASE64Encoder();

    public CFDictionary(Pointer address) {
        super(address);
    }

    public CFDictionary() {
    }

    public static CFDictionary createCFDictionary(CFString[] keys, CFType[] values, int valueLength) {
        CFLibrary.CFDictionaryKeyCallBacks keyCallBacks = new CFLibrary.CFDictionaryKeyCallBacks();
        CFLibrary.CFDictionaryValueCallBacks valueCallBacks = new CFLibrary.CFDictionaryValueCallBacks();
        NativeLong namevalues = new NativeLong((long)valueLength);
        CFDictionary cfdictionary = LibraryInstance.getCFLibrary().CFDictionaryCreate(null, keys, values, namevalues, keyCallBacks, valueCallBacks);
        return cfdictionary;
    }

    public int keyCount(String key) {
        return LibraryInstance.getCFLibrary().CFDictionaryGetCountOfKey(this, CFString.buildString(key)).intValue();
    }

    public int valueCount(CFType value) {
        return LibraryInstance.getCFLibrary().CFDictionaryGetCountOfValue(this, value).intValue();
    }

    public int size() {
        return LibraryInstance.getCFLibrary().CFDictionaryGetCount(this).intValue();
    }

    public CFType getValue(String key) {
        return LibraryInstance.getCFLibrary().CFDictionaryGetValue(this, CFString.buildString(key));
    }

    public CFString getString(String key) {
        return new CFString(this.getValue(key).getPointer());
    }

    public CFNumber getNumber(String key) {
        return new CFNumber(this.getValue(key).getPointer());
    }

    public CFData getData(String key) {
        return new CFData(this.getValue(key).getPointer());
    }

    public CFDictionary getDict(String key) {
        return new CFDictionary(this.getValue(key).getPointer());
    }

    public CFBoolean getBoolean(String key) {
        return new CFBoolean(this.getValue(key).getPointer());
    }

    public CFArray getArray(String key) {
        return new CFArray(this.getValue(key).getPointer());
    }

    public CFDate getDate(String key) {
        return new CFDate(this.getValue(key).getPointer());
    }

    public DictionaryElement toDictionaryElement() {
        int size = this.size();
        DictionaryElement dict = new DictionaryElement();
        if (size == 0) {
            return dict;
        }
        CFString[] keys = new CFString[size];
        CFType[] values = new CFType[size];
        LibraryInstance.getCFLibrary().CFDictionaryGetKeysAndValues(this, keys, values);
        int i = 0;
        while (i < size) {
            dict.put(keys[i].getString(), this.parseValue(values[i]));
            ++i;
        }
        return dict;
    }

    public PList toPlist() {
        int size = this.size();
        CFString[] keys = new CFString[size];
        CFType[] values = new CFType[size];
        LibraryInstance.getCFLibrary().CFDictionaryGetKeysAndValues(this, keys, values);
        PList plist = new PList();
        DictionaryElement dict = plist.getValue();
        int i = 0;
        while (i < size) {
            try {
                dict.put(keys[i].getString(), this.parseValue(values[i]));
            }
            catch (Throwable throwable) {}
            ++i;
        }
        return plist;
    }

    private PElement parseValue(CFType type) {
        PElementAdapter value;
        if (type == null) {
            return null;
        }
        String desc = type.getTypeDescription();
        if (desc.equalsIgnoreCase("CFArray")) {
            value = this.parseArray(type);
        } else if (desc.equalsIgnoreCase("CFBoolean")) {
            value = new BooleanElement(type.asBoolean().getValue());
        } else if (desc.equalsIgnoreCase("CFString")) {
            value = new StringElement(type.asString().getString());
        } else if (desc.equalsIgnoreCase("CFNumber")) {
            value = new IntegerElement(type.asNumber().getLong());
        } else if (desc.equalsIgnoreCase("CFData")) {
            value = new DataElement(this.enc.encode(type.asData().getBuffer().array()));
        } else if (desc.equalsIgnoreCase("CFDictionary")) {
            value = this.parseDictionary(type);
        } else if (desc.equalsIgnoreCase("CFDate")) {
            value = new DateElement("");
        } else {
            throw new IllegalArgumentException("Unknown Value:" + desc + ":" + (Object)((Object)type));
        }
        return value;
    }

    private DictionaryElement parseDictionary(CFType type) {
        CFDictionary dict = type.asDict();
        return dict.toDictionaryElement();
    }

    private ArrayElement parseArray(CFType type) {
        CFArray array = type.asArray();
        ArrayElement arr = new ArrayElement();
        int size = array.size();
        int i = 0;
        while (i < size) {
            arr.add(this.parseValue(array.getValue(i)));
            ++i;
        }
        return arr;
    }
}

