/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Environment;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.PluginUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.iphone.jna.cf.CFLibrary;
import com.pandora.launcher.core.iphone.jna.cf.LinPropertyList;
import com.pandora.launcher.core.iphone.jna.md.LinMDLibrary;
import com.pandora.launcher.core.iphone.jna.md.MDLibrary;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public abstract class LibraryFinder {
    public static boolean LOADED = false;
    private static boolean IS_INITED = false;
    private static boolean NEEDLOAD = true;
    private static Logger log = Logger.getLogger("LibraryFinder");
    private static MDLibrary MD_INSTANCE = null;
    private static CFLibrary CF_INSTANCE = null;
    private static LinMDLibrary LMD_INSTANCE = null;
    private static LinPropertyList LPL_INSTANCE = null;
    private static final String PATH_WIN32 = "SOFTWARE\\Apple Inc.\\Apple Mobile Device Support\\Shared";
    private static final String PATH_WIN64 = "SOFTWARE\\Wow6432Node\\Apple Inc.\\Apple Mobile Device Support\\Shared";
    private static final String DIR_WIN32 = "SOFTWARE\\Apple Inc.\\Apple Application Support";
    private static final String DIR_WIN64 = "SOFTWARE\\Wow6432Node\\Apple Inc.\\Apple Application Support";
    private static final String PATH_MAC = "/System/Library/PrivateFrameworks/MobileDevice.framework/MobileDevice";
    private static final String DIR_MAC = "/System/Library/Frameworks/CoreFoundation.framework/CoreFoundation";
    public static final String PLUGIN_ID = "com.pandora.launcher.resource.win32.x86_64";
    public static final String FEATURE_ID = "com.pandora.launcher.resource.feature";
    public static String CORE_LIBRARY_PATH = "";
    public static String CORE_LIBRARY_DIR = "";
    public static String MOBILE_DEVICE_LIBRARY_PATH = "";
    private static boolean isInitedWindowsBit;
    private static boolean isWindows64Bit;

    static {
        IS_INITED = LibraryFinder.loadPath();
        Native.setProtected((boolean)true);
        isInitedWindowsBit = false;
        isWindows64Bit = false;
    }

    private static boolean loadPath() {
        if (Platform.isWindows()) {
            File file;
            String dir;
            block6: {
                try {
                    String path = LibraryFinder.getPathByITunesVersionAndSystemVersion();
                    dir = LibraryFinder.getDir();
                    dir = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)dir, (String)"InstallDir");
                    file = new File(path);
                    if (file.exists()) break block6;
                    return false;
                }
                catch (Throwable ignored) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)ignored.getMessage(), (Throwable)ignored);
                    return false;
                }
            }
            String ppp = System.getenv("Path");
            ppp = String.valueOf(dir) + ";" + file.getParent() + ";" + ppp;
            Environment.setEnv((String)"Path", (String)ppp);
            System.setProperty("LD_LIBRARY_PATH", String.valueOf(dir) + ";" + file.getParent() + ";" + System.getProperty("LD_LIBRARY_PATH"));
            System.setProperty("java.library.path", String.valueOf(dir) + ";" + file.getParent() + ";" + System.getProperty("java.library.path"));
            String sqlite3 = String.valueOf(dir) + "/sqlite3.dll";
            File f = new File(sqlite3);
            if (f.exists()) {
                System.load(String.valueOf(dir) + "/sqlite3.dll");
            }
        }
        if (NEEDLOAD) {
            MD_INSTANCE = LibraryFinder.getMDLibrary(true);
            CF_INSTANCE = LibraryFinder.getCFLibrary();
            return MD_INSTANCE != null && CF_INSTANCE != null;
        }
        LMD_INSTANCE = LibraryFinder.getLMDLibrary();
        LPL_INSTANCE = LibraryFinder.getLPLLib();
        return IS_INITED;
    }

    private static String getPath() {
        String path = Platform.is64Bit() ? PATH_WIN64 : PATH_WIN32;
        return path;
    }

    private static String getDir() {
        String dir = Platform.is64Bit() ? DIR_WIN64 : DIR_WIN32;
        return dir;
    }

    public static synchronized MDLibrary getMDLibrary(boolean isInit) {
        if (!IS_INITED && !isInit) {
            NEEDLOAD = false;
            IS_INITED = LibraryFinder.loadPath();
        }
        if (MD_INSTANCE != null) {
            return MD_INSTANCE;
        }
        if (CF_INSTANCE == null) {
            LibraryFinder.getCFLibrary();
        }
        if (LibraryFinder.foundMobileLibrary()) {
            LOADED = true;
            IS_INITED = true;
            MD_INSTANCE = (MDLibrary)Native.loadLibrary(MDLibrary.class);
            return MD_INSTANCE;
        }
        IS_INITED = false;
        LOADED = false;
        log.severe("Could not find the MobileDevice Library!");
        return null;
    }

    public static synchronized CFLibrary getCFLibrary() {
        if (CF_INSTANCE != null) {
            return CF_INSTANCE;
        }
        if (LibraryFinder.foundCoreLibrary()) {
            LOADED = true;
            IS_INITED = true;
            CF_INSTANCE = (CFLibrary)Native.loadLibrary(CFLibrary.class);
            return CF_INSTANCE;
        }
        LOADED = false;
        IS_INITED = false;
        log.severe("Could not find the CoreFoundation Library!");
        return null;
    }

    public static synchronized LinMDLibrary getLMDLibrary() {
        if (!Platform.isLinux()) {
            return null;
        }
        if (LMD_INSTANCE != null) {
            return LMD_INSTANCE;
        }
        if (LibraryFinder.foundLinMDLibrary()) {
            return (LinMDLibrary)Native.loadLibrary((String)LibraryFinder.findLinMDLibrary(), LinMDLibrary.class);
        }
        log.severe("Could not find the imobiledevice Library!");
        return null;
    }

    public static synchronized LinPropertyList getLPLLib() {
        if (!Platform.isLinux()) {
            return null;
        }
        if (LPL_INSTANCE != null) {
            return LPL_INSTANCE;
        }
        if (LibraryFinder.foundLinPropertyList()) {
            return (LinPropertyList)Native.loadLibrary((String)LibraryFinder.findLinPropertyList(), LinPropertyList.class);
        }
        log.severe("Could not find the plist Library!");
        return null;
    }

    public static boolean foundMobileLibrary() {
        String path = LibraryFinder.findMobileLibrary();
        boolean b = LibraryFinder.loadSystemPath(path);
        return b;
    }

    private static boolean loadSystemPath(String path) {
        boolean b = StringUtil.isNotBlank((String)path);
        if (b) {
            File file = new File(path);
            b = file.exists();
            if (b) {
                try {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)("path1======" + path));
                    if (Platform.isWindows()) {
                        path = path.replace("\\\\", "\\");
                        path = path.replace("\\", "\\\\");
                        path = path.replace("/", "\\\\");
                    } else {
                        path = path.replace("\\\\", "\\");
                        path = path.replace("\\", "/");
                    }
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)("path2======" + path));
                    System.load(path);
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"loadSystemPath_05 error", (Throwable)e);
                    b = false;
                }
            } else {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(path) + " is not exits!"));
            }
        }
        return b;
    }

    private static boolean foundCoreLibrary() {
        String path = LibraryFinder.findCoreLibrary();
        boolean b = LibraryFinder.loadSystemPath(path);
        return b;
    }

    private static boolean foundLinMDLibrary() {
        return StringUtil.isNotBlank((String)LibraryFinder.findLinMDLibrary());
    }

    private static boolean foundLinPropertyList() {
        return StringUtil.isNotBlank((String)LibraryFinder.findLinPropertyList());
    }

    private static String findMobileLibrary() {
        String path = "";
        if (Platform.isWindows()) {
            path = LibraryFinder.getWindowsLibrary();
        } else if (Platform.isMac()) {
            path = LibraryFinder.getMacLibrary();
        } else {
            Platform.isLinux();
        }
        MOBILE_DEVICE_LIBRARY_PATH = path;
        return MOBILE_DEVICE_LIBRARY_PATH;
    }

    private static String getMacLibrary() {
        return PATH_MAC;
    }

    private static String getWindowsLibrary() {
        try {
            return LibraryFinder.getPathByITunesVersionAndSystemVersion();
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getPathByITunesVersionAndSystemVersion() {
        String path = "";
        try {
            path = LibraryFinder.getPluginDllPath();
            if (StringUtil.isBlank((String)path) || !new File(path).exists()) {
                path = LibraryFinder.getPath();
                path = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)path, (String)"iTunesMobileDeviceDLL");
            }
        }
        catch (Throwable e) {
            if (e instanceof Win32Exception) {
                path = LibraryFinder.getPluginDllPath();
            }
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        return path;
    }

    public static String getPluginDllPath() {
        String path = "";
        if (LibraryFinder.isWindows64Bit() && LibraryFinder.isITunesInstalled() && LibraryFinder.isPluginInstalled() || org.eclipse.core.runtime.Platform.inDevelopmentMode()) {
            try {
                String dpath;
                URL url;
                File dllFile;
                Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)PLUGIN_ID);
                if (bundle != null && (dllFile = new File(FileLocator.toFileURL((URL)(url = bundle.getResource(dpath = "driver/iTunesMobileDevice.dll"))).getFile())).exists()) {
                    path = dllFile.getAbsolutePath();
                }
            }
            catch (Exception e1) {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)e1.getMessage(), (Throwable)e1);
            }
        }
        return path;
    }

    public static boolean isWindows64Bit() {
        if (!isInitedWindowsBit && PlatformUtil.isWindows()) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            isWindows64Bit = StringUtil.isNotBlank((String)arch) && arch.endsWith("64") || StringUtil.isNotBlank((String)wow64Arch) && wow64Arch.endsWith("64");
            isInitedWindowsBit = true;
        }
        return isWindows64Bit;
    }

    public static boolean isPluginInstalled() {
        return PluginUtils.isPluginInstalled((String)PLUGIN_ID) && PluginUtils.isFeatureInstalled((String)FEATURE_ID);
    }

    private static boolean isITunesInstalled() {
        String path = LibraryFinder.findCoreLibrary();
        return StringUtil.isNotBlank((String)path);
    }

    public static boolean checkPluginInstalled() {
        return LibraryFinder.isWindows64Bit() && LibraryFinder.isITunesInstalled() && !LibraryFinder.isPluginInstalled();
    }

    public static void openInstallDailog() {
        PluginUtils.notifyInstallPlugin((String)PLUGIN_ID, (String)FEATURE_ID, (String)"\u63d2\u4ef6\u5b89\u88c5", (String)"\u4f60\u9700\u8981\u4e0b\u8f7diOS\u8fde\u63a5\u63d2\u4ef6\u624d\u53ef\u4ee5\u572864\u4f4dWindows\u7cfb\u7edf\u4e0a\u8fdb\u884ciOS\u771f\u673a\u8fd0\u884c,\u662f\u5426\u4e0b\u8f7d?\n\u653e\u5f03\u672c\u6b21\u64cd\u4f5c\u540e\u53ef\u4ece\u83dc\u5355\u3010\u5de5\u5177-\u63d2\u4ef6\u5b89\u88c5\u3011\u754c\u9762\u4e2d\u8fdb\u884c\u5b89\u88c5\u672c\u63d2\u4ef6", (String)"downloadITunes64", (boolean)true);
    }

    private static String findCoreLibrary() {
        block7: {
            try {
                if (Platform.isWindows()) {
                    String path = LibraryFinder.getDir();
                    try {
                        path = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)path, (String)"InstallDir");
                        path = String.valueOf(path) + "CoreFoundation.dll";
                        File f = new File(path);
                        if (f.exists()) {
                            CORE_LIBRARY_PATH = path;
                            CORE_LIBRARY_DIR = f.getParent();
                            return path;
                        }
                        break block7;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                if (Platform.isMac()) {
                    CORE_LIBRARY_PATH = DIR_MAC;
                    CORE_LIBRARY_DIR = new File(DIR_MAC).getParent();
                    return DIR_MAC;
                }
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    private static String findLinMDLibrary() {
        if (Platform.isLinux()) {
            return "imobiledevice";
        }
        return "";
    }

    private static String findLinPropertyList() {
        if (Platform.isLinux()) {
            return "plist";
        }
        return "";
    }
}

