/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.fw;

public enum DeviceHardware {
    iPhone4("N90AP", "8A306", true),
    iPhone3GS("N88AP", "8A306", true),
    iPhone3G("N82AP", null, true),
    iPhone("M68AP", null, true),
    iPod3G("N18AP", "8A293"),
    iPod2G("N72AP", "8A293"),
    iPod("N45AP", null),
    iPad("K48AP", "7B405"),
    iPad3G("K48AP", "7B405", true),
    INVALID("", null);

    private String value;
    private String latestBuild;
    private boolean hasBaseband;

    private DeviceHardware(String value, String latestBuild, boolean hasBaseband) {
        this.value = value;
        this.latestBuild = latestBuild;
        this.hasBaseband = hasBaseband;
    }

    private DeviceHardware(String value, String latestBuild) {
        this(value, latestBuild, false);
    }

    public String getLatestVersion() {
        return this.latestBuild;
    }

    public boolean hasBaseband() {
        return this.hasBaseband;
    }

    public static DeviceHardware get(String value, boolean hasBaseband) {
        DeviceHardware[] deviceHardwareArray = DeviceHardware.values();
        int n = deviceHardwareArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceHardware hw = deviceHardwareArray[n2];
            if (hw.value.equalsIgnoreCase(value) && hw.hasBaseband == hasBaseband) {
                return hw;
            }
            ++n2;
        }
        return INVALID;
    }

    public static DeviceHardware get(String value) {
        return DeviceHardware.get(value, false);
    }
}

