/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.Platform;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.log.HBLog;
import com.pandora.core.plist.PListParserFactory;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StatusLineUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.IPrintlnable;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.internal.ApplicationsInfo;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.internal.RemoteDebugObject;
import com.pandora.launcher.core.iphone.Messages;
import com.pandora.launcher.core.iphone.jna.LibraryFinder;
import com.pandora.launcher.core.iphone.jna.idevice.DeviceLibraryRegistry;
import com.pandora.launcher.core.iphone.jna.idevice.IApplicationLogHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IDevice;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceLibrary;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.ILookupApplicationsNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IScheduleHandler;
import com.pandora.launcher.core.iphone.jna.idevice.win.AFCConnection;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.tools.android.AndroidPlugin;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.wink.json4j.JSON;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.PlatformUI;

public class IPhoneLauncher
implements ILauncher {
    private Mobile mobileTarget;
    private HashMap<Mobile, List<ApplicationsInfo>> appMap = new HashMap();
    private boolean isExist = false;
    private IMobileListener listener = null;
    private AFCConnection uploadServiceConnection = null;
    private AFCConnection afcConnection = null;
    private AFCConnection houseArrestService = null;
    private AFCConnection installServiceConnection;
    public static final String SERVICE_NAME_START = "com.apple.afc";
    public static final String SERVICE_NAME_install = "com.apple.mobile.installation_proxy";
    private static IDeviceLibrary deviceLibrary;
    private boolean isReRun = false;
    private boolean isDelete = false;
    private static String regEx;
    private static Pattern pattern;
    Job logJob;
    boolean isStoped = false;
    private String logFileName = "hb.log";
    private boolean isNeedWarnCache;
    ProcessBuilder pb = new ProcessBuilder(new String[0]);

    static {
        regEx = "[\u4e00-\u9fa5]";
        pattern = Pattern.compile(regEx);
    }

    public IPhoneLauncher() {
        deviceLibrary = deviceLibrary == null ? DeviceLibraryRegistry.getDeviceLibrary() : deviceLibrary;
        File file = new File(AndroidPlugin.IOS_REMOTE_DEBUG_PATH);
        if (!file.exists()) {
            return;
        }
        System.setProperty("LD_LIBRARY_PATH", String.valueOf(file.getParent()) + ";" + System.getProperty("LD_LIBRARY_PATH"));
        System.setProperty("java.library.path", String.valueOf(file.getParent()) + ";" + System.getProperty("java.library.path"));
    }

    @Override
    public boolean checkDriver() throws OperateException {
        return LibraryFinder.foundMobileLibrary();
    }

    @Override
    public void connect(Mobile machine) throws OperateException {
        this.mobileTarget = machine;
        this.handleDeviceConnect(this.mobileTarget);
    }

    @Override
    public List<Mobile> getMachineList() {
        return null;
    }

    @Override
    public boolean isAppExists(final Apps app) throws OperateException {
        this.isDelete = false;
        if (this.mobileTarget != null && this.mobileTarget.getDevice() != null) {
            if (this.appMap.containsKey(this.mobileTarget) && this.appMap.get(this.mobileTarget) != null) {
                List<ApplicationsInfo> applist = this.appMap.get(this.mobileTarget);
                for (ApplicationsInfo applicationsInfo : applist) {
                    if (applicationsInfo == null || !applicationsInfo.getCFBundleIdentifier().equals(app.getId())) continue;
                    return true;
                }
            }
            deviceLibrary.addLookupApplicationsNotificationHandler(this.mobileTarget.getDevice(), new ILookupApplicationsNotificationHandler(){

                @Override
                public void LookupApplicationsNotificationHandler(IDevice device, PList deviceInfo) {
                    if (deviceInfo == null) {
                        return;
                    }
                    DictionaryElement de = deviceInfo.getValue();
                    Set<String> keySet = de.keySet();
                    ArrayList<ApplicationsInfo> list = new ArrayList<ApplicationsInfo>();
                    for (String key : keySet) {
                        String version;
                        Node node;
                        if (StringUtil.isBlank((String)key)) continue;
                        Document document = DocumentHelper.createDocument();
                        Element element = document.addElement("appinfo");
                        try {
                            IPhoneLauncher.this.getCFTypeValue(element, de.get(key), key);
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                        ApplicationsInfo applicationsInfo = new ApplicationsInfo();
                        applicationsInfo.setCFBundleIdentifier(key);
                        applicationsInfo.setAppDoc(document);
                        if (key.equals(app.getId()) && (node = document.selectSingleNode("//CFBundleShortVersionString")) != null && StringUtil.isNotBlank((String)(version = node.getText()))) {
                            if (version.equals(app.getBaseVersion())) {
                                IPhoneLauncher.this.isExist = true;
                            } else {
                                try {
                                    IPhoneLauncher.this.unInstallPackage(app.getId());
                                }
                                catch (OperateException e) {
                                    IPhoneLauncher.this.printlnToConsole(e.getMessage(), e);
                                }
                            }
                        }
                        if (key.equals("com.dheaven.h5builder")) {
                            try {
                                IPhoneLauncher.this.unInstallPackage("com.dheaven.h5builder");
                            }
                            catch (OperateException e) {
                                IPhoneLauncher.this.printlnToConsole(e.getMessage(), e);
                            }
                        }
                        list.add(applicationsInfo);
                    }
                    IPhoneLauncher.this.appMap.put(IPhoneLauncher.this.mobileTarget, list);
                }
            });
        }
        return this.isExist;
    }

    private void unInstallPackage(String path) throws OperateException {
        try {
            this.isDelete = true;
            this.connect(this.mobileTarget);
            if (this.installServiceConnection == null) {
                this.installServiceConnection = this.startService(SERVICE_NAME_install);
            }
            if (this.installServiceConnection == null || this.installServiceConnection.getAfc_connection() == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Install_Service_Failed, true);
            }
            deviceLibrary.addAMDeviceUnInstallApplicationHandler(this.installServiceConnection, path, new IScheduleHandler(){

                @Override
                public void scheduleHandlerHandler(String scheduleMessage) {
                }

                @Override
                public boolean isDelete() {
                    return false;
                }
            });
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.unInstallPackage(path);
        }
    }

    @Override
    public void installApplication(Apps app) throws OperateException {
        File tmpFile = null;
        try {
            this.connect(this.mobileTarget);
            this.uploadServiceConnection = this.startService(SERVICE_NAME_START);
            String path = app.getBasePath();
            File ipaPath = new File(path);
            if (StringUtil.isBlank((String)path) || !ipaPath.exists()) {
                if (DefaultMobileManager.isCustom()) {
                    throw new OperateException("\u5b89\u88c5\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u5236\u4f5c\u81ea\u5b9a\u4e49\u57fa\u5ea7");
                }
                throw new OperateException("\u5b89\u88c5HBuilder\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4ece\u5b98\u7f51\u4e0b\u8f7d\u65b0\u7684HBuilder");
            }
            if (pattern.matcher(path).find()) {
                String newPath = "";
                if (PlatformUtil.isWindows()) {
                    if (PlatformUtil.isWindowsXP()) {
                        File tmp;
                        newPath = System.getenv("ComSpec");
                        if (StringUtil.isNotBlank((String)newPath) && (tmp = new File(newPath)).exists() && tmp.isFile()) {
                            newPath = tmp.getParent();
                        }
                    } else {
                        newPath = System.getenv("ProgramData");
                        if (StringUtil.isNotBlank((String)newPath)) {
                            newPath = String.valueOf(newPath) + File.separator + "HBuilder";
                        }
                    }
                } else {
                    URI uri = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    File tmpf = new File(uri);
                    if (tmpf.exists() && tmpf.isDirectory()) {
                        newPath = tmpf.getPath();
                    }
                }
                if (StringUtil.isNotBlank((String)newPath)) {
                    tmpFile = new File(newPath);
                    if (!tmpFile.exists() || !tmpFile.isDirectory()) {
                        tmpFile.mkdirs();
                    }
                    if ((tmpFile = new File(tmpFile, ipaPath.getName())).exists()) {
                        tmpFile.delete();
                    }
                    FileUtil.copyFile((File)ipaPath, (File)tmpFile);
                    path = tmpFile.getAbsolutePath();
                }
            }
            this.upLoadPackage(path);
            this.installPackage(path);
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.installApplication(app);
        }
    }

    private void installPackage(String path) throws OperateException {
        if (this.installServiceConnection == null) {
            this.installServiceConnection = this.startService(SERVICE_NAME_install);
        }
        if (this.installServiceConnection == null || this.installServiceConnection.getAfc_connection() == null) {
            throw new OperateException(Messages.IPhoneLauncher_Open_Install_Service_Failed, true);
        }
        deviceLibrary.addAMDeviceInstallApplicationHandler(this.installServiceConnection, path, new IScheduleHandler(){

            @Override
            public void scheduleHandlerHandler(String scheduleMessage) {
            }

            @Override
            public boolean isDelete() {
                return IPhoneLauncher.this.isDelete;
            }
        });
    }

    private AFCConnection startHouseArrestService(IDevice device, String serviceName) {
        if (this.houseArrestService == null) {
            this.houseArrestService = deviceLibrary.addStartHouseArrestServiceHandler(this.mobileTarget.getDevice(), serviceName);
        }
        int t = 0;
        while (this.houseArrestService == null) {
            ++t;
            this.houseArrestService = deviceLibrary.addStartHouseArrestServiceHandler(this.mobileTarget.getDevice(), serviceName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            if (t > 5) break;
        }
        return this.houseArrestService;
    }

    private void upLoadPackage(String path) throws OperateException {
        if (this.uploadServiceConnection == null) {
            throw new OperateException(Messages.IPhoneLauncher_Select_Phone, true);
        }
        deviceLibrary.addAMDeviceTransferApplicationHandler(this.uploadServiceConnection, path, new IScheduleHandler(){

            @Override
            public void scheduleHandlerHandler(String scheduleMessage) {
            }

            @Override
            public boolean isDelete() {
                return IPhoneLauncher.this.isDelete;
            }
        });
    }

    private void openAFCConnection(AFCConnection connection) throws OperateException {
        if (connection != null && connection.getAfc_connection() != null) {
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                return;
            }
            this.afcConnection = deviceLibrary.addOpenAFCConnectionHandler(connection);
            int t = 0;
            while (this.afcConnection == null) {
                ++t;
                this.afcConnection = deviceLibrary.addOpenAFCConnectionHandler(connection);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (t > 5) break;
            }
            if (this.afcConnection == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Connection_Failed, true);
            }
        } else {
            throw new OperateException(Messages.IPhoneLauncher_Open_Service_Failed, true);
        }
    }

    private AFCConnection startService(String serviceName) throws OperateException {
        AFCConnection connection = null;
        if (this.mobileTarget != null && this.mobileTarget.getDevice() != null) {
            connection = deviceLibrary.addStartServiceHandler(this.mobileTarget.getDevice(), serviceName);
            int t = 0;
            while (connection == null) {
                ++t;
                connection = deviceLibrary.addStartServiceHandler(this.mobileTarget.getDevice(), serviceName);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (t > 5) break;
            }
            if (connection == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Phone_Service_Failed, true);
            }
        } else {
            throw new OperateException(Messages.IPhoneLauncher_Select_Phone, true);
        }
        return connection;
    }

    protected void getCFTypeValue(Element element, PElement pElement, String key) {
        PElementType type = pElement.getType();
        switch (type) {
            case PLIST: {
                break;
            }
            case KEY: {
                break;
            }
            case STRING: {
                element.addElement(key).setText(pElement.asString());
                break;
            }
            case REAL: {
                break;
            }
            case INTEGER: {
                element.addElement(key).setText(Long.toString(pElement.asLong()));
                break;
            }
            case DATE: {
                element.addElement(key).setText(pElement.asDate());
                break;
            }
            case BOOLEAN: {
                element.addElement(key).setText(Boolean.toString(pElement.asBoolean()));
                break;
            }
            case DATA: {
                element.addElement(key).setText(pElement.asData());
                break;
            }
            case ARRAY: {
                break;
            }
            case DICTIONARY: {
                Map<String, PElement> map = pElement.asDict();
                Set<String> keySet = map.keySet();
                for (String mapKey : keySet) {
                    PElement pe = map.get(mapKey);
                    this.getCFTypeValue(element, pe, mapKey);
                }
                break;
            }
        }
    }

    @Override
    public void deletePackage(Apps app) throws OperateException {
        try {
            AFCConnection connection;
            this.connect(this.mobileTarget);
            if ((this.afcConnection == null || this.afcConnection.getAfc_connection() == null) && (connection = this.startHouseArrestService(this.mobileTarget.getDevice(), app.getId())) != null && connection.getAfc_connection() != null) {
                this.openAFCConnection(connection);
            }
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, "/", app.getAppid(), null, app);
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, this.getLogFilePath(app), app.getAppid(), null, app);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                this.printlnToConsole(e.getMessage(), e);
                return;
            }
            this.isReRun = true;
            this.deletePackage(app);
        }
        catch (Exception e) {
            if (this.isReRun) {
                this.isReRun = false;
                e.printStackTrace();
                return;
            }
            this.isReRun = true;
            this.deletePackage(app);
        }
    }

    @Override
    public void pushResource(Apps app, String resourcePath, String resourceRefPath, String targetPath) throws OperateException {
        try {
            Set<String> fs = HMobileDeviceLauncher.getFileReference(app.getProject(), resourceRefPath);
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCFileWriteHandler(this.afcConnection, app.getAppid(), resourcePath, targetPath, fs, app);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.connect(this.mobileTarget);
            this.pushResource(app, resourcePath, resourceRefPath, targetPath);
        }
    }

    @Override
    public void sendRestartCmd(Apps app) throws OperateException {
        try {
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.sendRestartCmd(this.afcConnection, app);
            }
        }
        catch (Exception exception) {
            if (this.isReRun) {
                this.isReRun = false;
                throw new OperateException("");
            }
            this.isReRun = true;
            this.connect(this.mobileTarget);
            this.sendRestartCmd(app);
        }
    }

    @Override
    public void pushPackage(Apps app) throws OperateException {
        try {
            this.connect(this.mobileTarget);
            String appid = app.getAppid();
            String localPath = "";
            localPath = app.getResourcePath() != null && app.getResourcePath().exists() ? app.getResourcePath().getAbsolutePath() : app.getProject().getLocation().toOSString();
            this.createDirAndFile(localPath, app.getId(), appid, app);
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.pushPackage(app);
        }
    }

    private void createDirAndFile(String localPath, String serviceName, String appid, Apps app) throws OperateException {
        AFCConnection connection;
        if ((this.afcConnection == null || this.afcConnection.getAfc_connection() == null) && (connection = this.startHouseArrestService(this.mobileTarget.getDevice(), serviceName)) != null && connection.getAfc_connection() != null) {
            this.openAFCConnection(connection);
        }
        if (this.afcConnection == null || this.afcConnection.getAfc_connection() == null) {
            throw new OperateException(Messages.IPhoneLauncher_Open_Write_File_Service_Failed, true);
        }
        deviceLibrary.addAFCFileRefWriteHandler(this.afcConnection, appid, localPath, app);
    }

    @Override
    public void startApplication(Apps app) throws OperateException {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(LauncherCoreActivator.PLUGIN_ID);
        boolean isFirstRunIphoe = true;
        try {
            isFirstRunIphoe = prefs.getBoolean("first_launch_iphone", true);
            if (!isFirstRunIphoe) {
                if (!DefaultMobileManager.isCustom()) {
                    this.printlnToConsole("\u8054\u673a\u8c03\u8bd5\u5e76\u975e\u6253\u5305\uff0c\u8c03\u8bd5\u57fa\u5ea7 HBuilder \u662f\u9ed8\u8ba4\u7684\u6d4b\u8bd5\u5305\uff0c\u6743\u9650\u3001\u56fe\u6807\u90fd\u4e0d\u53ef\u81ea\u5b9a\u4e49\u3002\u53ea\u6709\u5728\u70b9\u83dc\u5355\"\u53d1\u884c-\u53d1\u884c\u4e3a\u539f\u751f\u5b89\u88c5\u5305\"\u65f6\u624d\u80fd\u81ea\u5b9a\u4e49\u8fd9\u4e9b\u8bbe\u7f6e", new OperateException(null));
                }
                prefs.putBoolean("first_launch_iphone", false);
                prefs.flush();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
        this.printlnToConsole("iOS\u8bbe\u5907\u53ef\u4f7f\u7528console.log()\u8f93\u51fa\u5185\u5bb9\u5230\u63a7\u5236\u53f0\uff0c\u4f46\u662f\u53ef\u80fd\u53ea\u80fd\u8f93\u51faplusready\u4e4b\u540e\u7684\u8c03\u8bd5\u5185\u5bb9", new OperateException(null));
        if (DefaultMobileManager.isCustom()) {
            this.printlnToConsole("\u8bf7\u624b\u52a8\u91cd\u542f\u624b\u673a\u4e0a\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7App...", new OperateException(null));
        } else {
            String version = this.mobileTarget.getVersion();
            if (StringUtil.isNotBlank((String)version) && version.startsWith("9")) {
                this.printlnToConsole("iOS9.0\u53ca\u4ee5\u4e0a\u7cfb\u7edf\u9700\u8981\u5728\"\u8bbe\u7f6e\"-\"\u901a\u7528\"-\"\u63cf\u8ff0\u6587\u4ef6\"(\u6216\"\u8bbe\u5907\u7ba1\u7406\")\u4e2d\u4fe1\u4efbDCloud\u4f01\u4e1a\u8bc1\u4e66(Digital Heaven\u5f00\u5934\u7684\u8bc1\u4e66)\u624d\u53ef\u4ee5\u6b63\u5e38\u4f7f\u7528", new OperateException(null));
            }
            this.printlnToConsole(Messages.IPhoneLauncher_Initiative_Start_App, new OperateException(null));
        }
        HMobileDeviceLauncher.openPerspective();
    }

    public void printlnToConsole(String message, OperateException exception) {
        if (this.listener instanceof IPrintlnable) {
            IPrintlnable print = (IPrintlnable)((Object)this.listener);
            if (exception == null) {
                print.printlnToConsole(message);
            } else {
                print.printlnToConsole(message, exception);
            }
        }
    }

    @Override
    public void stopApplication(Apps app) throws OperateException {
    }

    @Override
    public void addLauncherListener(IMobileListener listener) {
        this.listener = listener;
    }

    private boolean isExistMobile(Mobile mobile, List<Mobile> mobileList) {
        boolean isExist = false;
        if (mobile == null) {
            return isExist;
        }
        for (Mobile mobi : mobileList) {
            if (!mobi.getUuid().equals(mobile.getUuid())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private Mobile coverPListToMobile(PList deviceInfo) {
        if (deviceInfo == null) {
            return null;
        }
        DictionaryElement dictionaryElement = deviceInfo.getValue();
        Mobile mobile = new Mobile(dictionaryElement.get("DeviceName").asString(), this.getIcon());
        mobile.setUuid(dictionaryElement.get("UniqueDeviceID").asString());
        mobile.setVersion(dictionaryElement.get("ProductVersion") == null ? "" : dictionaryElement.get("ProductVersion").asString());
        return mobile;
    }

    private String getIcon() {
        return "/icons/ipad.png";
    }

    @Override
    public Apps getTestApp(IProject project) {
        if (DefaultMobileManager.isCustom()) {
            File packageFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)project, (String)("unpackage" + File.separator + "debug" + File.separator + "iOS_debug.ipa"));
            try {
                String packageName = null;
                String appid = null;
                String version = null;
                ZipFile zipfile = new ZipFile(packageFile);
                String infoPlistFileName = "Payload/DCloud_Pandora.app/Info.plist";
                File file = this.getFileByEntryName(infoPlistFileName, zipfile);
                packageName = this.getPackageName(file);
                ZipEntry entry = this.getManifestZipEntry(zipfile);
                if (entry == null) {
                    throw new OperateException("\u65e0\u6cd5\u8bc6\u522b\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7\u5305\uff0c\u53ef\u4ece\u83dc\u5355\uff1a\u8fd0\u884c-\u771f\u673a\u8fd0\u884c-\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u8c03\u8bd5\u57fa\u5ea7 \u8fdb\u884c\u5236\u4f5c", true, true);
                }
                InputStream input = zipfile.getInputStream(entry);
                String content = IOUtil.read((InputStream)input);
                JsonElement jsonElement = new JsonParser().parse(content);
                JsonObject jsonObiect = jsonElement.getAsJsonObject();
                appid = jsonObiect.get("id").getAsString();
                version = jsonObiect.get("version").getAsJsonObject().get("name").getAsString();
                return new Apps(packageName, "", appid, project, packageFile.getAbsolutePath(), version);
            }
            catch (Exception e) {
                this.printlnToConsole("\u65e0\u6cd5\u8bc6\u522b\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7\u5305\uff0c\u53ef\u4ece\u83dc\u5355\uff1a\u8fd0\u884c-\u771f\u673a\u8fd0\u884c-\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u8c03\u8bd5\u57fa\u5ea7 \u8fdb\u884c\u5236\u4f5c", new OperateException(null));
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                return null;
            }
        }
        return new Apps("io.dcloud.HBuilder", "", "HBuilder", project, AndroidPlugin.IPHONE_BASE, AndroidPlugin.IPHONE_BASE_VERSION);
    }

    public ZipEntry getManifestZipEntry(ZipFile zipfile) {
        String manifestFileName = "/www/manifest.json";
        Enumeration<? extends ZipEntry> en = zipfile.entries();
        ZipEntry entry = null;
        while (en.hasMoreElements()) {
            entry = en.nextElement();
            if (entry == null || !entry.getName().endsWith(manifestFileName)) continue;
            return entry;
        }
        return null;
    }

    private String getPackageName(File file) {
        try {
            Map map = PListParserFactory.parse((File)file);
            Object object = map.get("CFBundleIdentifier");
            if (object != null) {
                return object.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public File getFileByEntryName(String androidManifestFileName, ZipFile zipfile) throws IOException, FileNotFoundException {
        ZipEntry entry = zipfile.getEntry(androidManifestFileName);
        InputStream input = zipfile.getInputStream(entry);
        File file = AndroidPlugin.getDefault().getBundle().getDataFile(androidManifestFileName);
        if (!file.getParentFile().exists() || !file.getParentFile().isDirectory()) {
            file.getParentFile().mkdirs();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        int length = -1;
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer)) != -1) {
            bos.write(buffer, 0, length);
        }
        bos.close();
        input.close();
        return file;
    }

    @Override
    public void listeningDeviceList() {
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.IPhoneLauncher_21);
        Job job = new Job("iPhone device"){

            protected IStatus run(IProgressMonitor monitor) {
                if (deviceLibrary == null) {
                    return Status.CANCEL_STATUS;
                }
                deviceLibrary.addNotificationHandler(new IDeviceNotificationHandler(){

                    @Override
                    public void onDeviceConnected(IDevice device, PList deviceInfo) {
                        List<Mobile> mobileList;
                        if (deviceInfo == null) {
                            return;
                        }
                        Mobile mobile = IPhoneLauncher.this.coverPListToMobile(deviceInfo);
                        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(mobile.getName()) + "\u5df2\u8fde\u63a5\u7535\u8111"));
                        mobile.setDevice(device);
                        mobile.setPlatform(Platform.IPHONE);
                        if (IPhoneLauncher.this.listener != null) {
                            IPhoneLauncher.this.listener.connected(mobile);
                        }
                        if (!(mobileList = LauncherCoreActivator.getMobileList()).contains(mobile) && !IPhoneLauncher.this.isExistMobile(mobile, mobileList)) {
                            LauncherCoreActivator.addMobile(mobile);
                            String message = String.valueOf(mobile.getName()) + Messages.IPhoneLauncher_Connected_PC;
                            StatusLineUtils.showStatusMessage((String)message, (long)5000L);
                        }
                        AndroidPlugin.restartRemoteDebug();
                    }

                    @Override
                    public void onDeviceDisconnected(IDevice device, PList deviceInfo) {
                        Mobile mobile = null;
                        List<Mobile> list = LauncherCoreActivator.getMachineList(Platform.IPHONE);
                        mobile = list.size() == 1 ? list.get(0) : IPhoneLauncher.this.coverPListToMobile(deviceInfo);
                        if (mobile != null) {
                            System.out.println(String.valueOf(mobile.getName()) + "\u5df2\u65ad\u5f00\u8fde\u63a5");
                            LauncherCoreActivator.removeMobile(mobile.getUuid(), Platform.IPHONE);
                            if (IPhoneLauncher.this.mobileTarget != null && mobile.getUuid().equals(IPhoneLauncher.this.mobileTarget.getUuid())) {
                                IPhoneLauncher.this.mobileTarget = null;
                            }
                            if (IPhoneLauncher.this.listener != null) {
                                IPhoneLauncher.this.listener.disConnected(mobile);
                            }
                            String message = String.valueOf(mobile.getName()) + Messages.IPhoneLauncher_Existed_PC;
                            StatusLineUtils.showStatusMessage((String)message, (long)5000L);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    private void handleDeviceConnect(Mobile mobile) throws OperateException {
        this.deviceDisconnected(mobile);
        this.deviceConnected(mobile);
    }

    private void deviceDisconnected(Mobile mobile) {
        deviceLibrary.handleDisconnect(mobile.getDevice());
    }

    private void deviceConnected(Mobile mobile) throws OperateException {
        deviceLibrary.handleConnect(mobile.getDevice(), true);
    }

    @Override
    public void getApplicationLog(final Apps app) throws OperateException {
        final int[] index = new int[1];
        this.logJob = new Job("\u83b7\u53d6\u65e5\u5fd7"){

            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled() || IPhoneLauncher.this.isStoped) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        final String wp = "/Documents/Pandora/apps/" + app.getAppid() + "/www/";
                        final int wpLength = wp.length();
                        if (IPhoneLauncher.this.afcConnection != null && IPhoneLauncher.this.afcConnection.getAfc_connection() != null) {
                            deviceLibrary.addAFCFileReadHandler(IPhoneLauncher.this.afcConnection, IPhoneLauncher.this.getLogFilePath(app), new IApplicationLogHandler(){

                                @Override
                                public void readBytes(byte[] logBytes) {
                                    int bl;
                                    int i;
                                    if (logBytes == null) {
                                        return;
                                    }
                                    byte[] pbyte = null;
                                    boolean isCompleted = false;
                                    int length = logBytes.length;
                                    int pl = 0;
                                    boolean needDelete = false;
                                    String newFileName = "";
                                    if (logBytes.length > 9216) {
                                        ArrayList<Byte> fnameByteList = new ArrayList<Byte>();
                                        i = logBytes.length - 1;
                                        while (i > 0) {
                                            if (i > 0 && logBytes[i] == 10 && logBytes[i - 1] == 13) break;
                                            ++pl;
                                            fnameByteList.add(logBytes[i]);
                                            --i;
                                        }
                                        if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                            return;
                                        }
                                        int size = fnameByteList.size();
                                        if (size > 8 && (Byte)fnameByteList.get(0) == -1 && (Byte)fnameByteList.get(1) == -1 && (Byte)fnameByteList.get(2) == -1 && (Byte)fnameByteList.get(3) == -1 && (Byte)fnameByteList.get(size - 1) == -1 && (Byte)fnameByteList.get(size - 2) == -1 && (Byte)fnameByteList.get(size - 3) == -1 && (Byte)fnameByteList.get(size - 4) == -1) {
                                            byte[] fnameByte = new byte[fnameByteList.size() - 8];
                                            int i2 = 0;
                                            int j = fnameByteList.size() - 5;
                                            while (j > 3) {
                                                fnameByte[i2] = (Byte)fnameByteList.get(j);
                                                ++i2;
                                                --j;
                                            }
                                            if (fnameByte.length > 0) {
                                                newFileName = new String(fnameByte);
                                                needDelete = true;
                                                isCompleted = true;
                                            }
                                        }
                                        if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                            return;
                                        }
                                    }
                                    int unReadLen = logBytes.length - index[0];
                                    if (index[0] == 0 && pl < 1 || unReadLen < 0) {
                                        pbyte = logBytes;
                                    } else {
                                        pbyte = new byte[unReadLen];
                                        i = index[0];
                                        while (i < length - pl) {
                                            pbyte[i - index[0]] = logBytes[i];
                                            ++i;
                                        }
                                    }
                                    index[0] = isCompleted ? 0 : logBytes.length;
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                    String logContent = new String(pbyte);
                                    String[] logs = logContent.split("\r\n");
                                    int l = logs.length - 1;
                                    if (l > -1 && !logContent.endsWith("\r\n") && StringUtil.isNotBlank((String)logs[l]) && index[0] > (bl = logs[l].getBytes().length)) {
                                        index[0] = index[0] - bl;
                                        logs[l] = "";
                                    }
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                    String[] stringArray = logs;
                                    int n = logs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String log = stringArray[n2];
                                        if (!StringUtil.isBlank((String)log) && !log.contains("\ufffd\ufffd\ufffd\ufffd")) {
                                            if ((log = HMobileDeviceLauncher.transSourceMapLog(log, sourceMap)).startsWith("[ERROR] :")) {
                                                int findex = log.indexOf("file:///");
                                                int windex = log.indexOf(wp);
                                                if (findex > 0 && windex > 0) {
                                                    String tmp = log.substring(findex, windex + wpLength);
                                                    log = log.replace(tmp, "");
                                                    log = log.replace("filename:", "file name:");
                                                    log = log.replace("lineno:", "line no:");
                                                }
                                                IPhoneLauncher.this.printlnToConsole(log, new OperateException(null));
                                            } else {
                                                IPhoneLauncher.this.printlnToConsole(log, null);
                                            }
                                        }
                                        ++n2;
                                    }
                                    if (needDelete) {
                                        try {
                                            deviceLibrary.addAFCRemovePathHandler(IPhoneLauncher.this.afcConnection, IPhoneLauncher.this.getLogFilePath(app), app.getAppid(), null, app);
                                            if (StringUtil.isNotBlank((String)newFileName)) {
                                                IPhoneLauncher.this.setLogFileName(newFileName);
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (PlatformUI.isWorkbenchRunning()) {
                        this.schedule(1000L);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.logJob.setUser(false);
        this.logJob.setSystem(true);
        this.logJob.schedule();
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    private String getLogFilePath(Apps app) {
        return "/Documents/Pandora/apps/" + app.getAppid() + "/log/" + this.getLogFileName();
    }

    @Override
    public void clearApplicationLog(Apps app) throws OperateException {
        if (this.logJob != null) {
            this.logJob.cancel();
        }
        this.isStoped = true;
    }

    @Override
    public void deleteResource(Apps app, String resourceRefPath, String targetPath) throws OperateException {
        try {
            Set<String> fs = HMobileDeviceLauncher.getFileReference(app.getProject(), resourceRefPath);
            this.connect(this.mobileTarget);
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, targetPath, app.getAppid(), fs, app);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.deleteResource(app, resourceRefPath, targetPath);
        }
    }

    public boolean isNeedWarnCache() {
        return this.isNeedWarnCache;
    }

    @Override
    public void setNeedWarnCache(boolean b) {
        this.isNeedWarnCache = b;
    }

    @Override
    public Map<String, List<RemoteDebugObject>> getRemoteDebugUrls(Mobile mobile) throws OperateException {
        String exePath = AndroidPlugin.IOS_REMOTE_DEBUG_PATH;
        if (StringUtil.isBlank((String)exePath)) {
            AndroidPlugin.initTools();
            exePath = AndroidPlugin.IOS_REMOTE_DEBUG_PATH;
        }
        if (StringUtil.isBlank((String)exePath)) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"IOS_REMOTE_DEBUG_PATH \u4e3a\u7a7a\uff0c\u786e\u8ba4\u662f\u5426\u5b58\u5728\uff01");
            return null;
        }
        File file = new File(exePath);
        if (!file.exists()) {
            return null;
        }
        if (AndroidPlugin.REMOTE_DEBUG_PROCESS == null) {
            AndroidPlugin.restartRemoteDebug();
        }
        HashMap<String, List<RemoteDebugObject>> remoteDebugObjectMap = new HashMap<String, List<RemoteDebugObject>>();
        String url = "http://localhost:9221/json";
        try {
            Map<String, String> uuidMap = this.getUUIDs(url);
            if (uuidMap == null || uuidMap.size() < 1) {
                return remoteDebugObjectMap;
            }
            Set<String> uuidSet = uuidMap.keySet();
            for (String uuid : uuidSet) {
                String uri = uuidMap.get(uuid);
                if (StringUtil.isBlank((String)uri)) continue;
                if (!uri.startsWith("http://")) {
                    uri = "http://" + uri;
                }
                uri = String.valueOf(uri) + "/json";
                remoteDebugObjectMap.put(uuid, this.getAppLinks(uri, uuid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return remoteDebugObjectMap;
    }

    private List<RemoteDebugObject> getAppLinks(String url, String pid) {
        ArrayList<RemoteDebugObject> list = new ArrayList<RemoteDebugObject>();
        JSONArtifact jsonArtifact = this.getJSONArtifact(url);
        if (jsonArtifact instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jsonArtifact;
            int i = 0;
            while (i < jsonArray.size()) {
                try {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    list.add(this.transferRemoteDebugObject(jsonObject, pid));
                }
                catch (Exception exception) {}
                ++i;
            }
        } else if (jsonArtifact instanceof JSONObject) {
            try {
                JSONObject jsonObject = (JSONObject)jsonArtifact;
                list.add(this.transferRemoteDebugObject(jsonObject, pid));
            }
            catch (Exception exception) {}
        }
        RemoteDebugObject[] remoteDebugObjects = list.toArray(new RemoteDebugObject[list.size()]);
        Arrays.sort(remoteDebugObjects, new Comparator<RemoteDebugObject>(){

            @Override
            public int compare(RemoteDebugObject o, RemoteDebugObject o1) {
                if (o != null && o1 != null && o.getAppName().equals(o1.getAppName())) {
                    return 1;
                }
                return 0;
            }
        });
        return Arrays.asList(remoteDebugObjects);
    }

    private RemoteDebugObject transferRemoteDebugObject(JSONObject jsonObject, String pid) throws JSONException, OperateException, JsonSyntaxException, FileNotFoundException, IOException {
        RemoteDebugObject remoteDebugObject = new RemoteDebugObject();
        remoteDebugObject.setUri(this.getValue(jsonObject, "devtoolsFrontendUrl"));
        String url = this.getValue(jsonObject, "url");
        if (StringUtil.isNotBlank((String)url)) {
            String prefix = "file://";
            if (url.startsWith(prefix)) {
                url = url.substring(prefix.length());
            }
            remoteDebugObject.setRemoteFilePath(url);
            prefix = "/Pandora/apps/";
            int index = url.indexOf(prefix);
            if (index > 0) {
                String appid = url.substring(index + prefix.length());
                if ((index = appid.indexOf(prefix = "/www/")) > -1) {
                    remoteDebugObject.setFilePath(appid.substring(index + prefix.length()));
                }
                appid = appid.substring(0, appid.indexOf("/"));
                remoteDebugObject.setAppName(appid);
            }
        } else {
            throw new NullPointerException("url is null");
        }
        remoteDebugObject.setId(this.getValue(jsonObject, "appId"));
        remoteDebugObject.setTitle(this.getValue(jsonObject, "title"));
        remoteDebugObject.setWebSocketDebuggerUrl(this.getValue(jsonObject, "webSocketDebuggerUrl"));
        remoteDebugObject.setPid(pid);
        return remoteDebugObject;
    }

    public Map<String, String> getUUIDs(String url) {
        LinkedHashMap<String, String> uuidMap;
        block9: {
            uuidMap = new LinkedHashMap<String, String>();
            try {
                JSONArtifact jsonArtifact = this.getJSONArtifact(url);
                if (jsonArtifact instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)jsonArtifact;
                    int i = 0;
                    while (i < jsonArray.size()) {
                        try {
                            this.processMobileJsonObiect(uuidMap, jsonArray.getJSONObject(i));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    break block9;
                }
                if (jsonArtifact instanceof JSONObject) {
                    try {
                        this.processMobileJsonObiect(uuidMap, (JSONObject)jsonArtifact);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uuidMap;
    }

    public JSONArtifact getJSONArtifact(String url) {
        DefaultHttpClient httpclient = HttpClientUtils.createHttpClient();
        try {
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String httpResponse = (String)httpclient.execute((HttpUriRequest)new HttpGet(url), (ResponseHandler)responseHandler);
            JSONArtifact jSONArtifact = JSON.parse((String)httpResponse);
            return jSONArtifact;
        }
        catch (Exception exception) {
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public void processMobileJsonObiect(Map<String, String> uuidMap, JSONObject jsonObject) throws JSONException {
        String uri;
        String uuid = this.getValue(jsonObject, "deviceId");
        if (StringUtil.isNotBlank((String)uuid) && StringUtil.isNotBlank((String)(uri = this.getValue(jsonObject, "url")))) {
            uuidMap.put(uuid, uri);
        }
    }

    public String getValue(JSONObject jsonObject, String key) throws JSONException {
        String value = null;
        if (jsonObject.containsKey((Object)key)) {
            value = jsonObject.getString(key);
        }
        return value;
    }
}

