/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.ios_sim;

import com.pandora.core.Platform;
import com.pandora.core.log.HBLog;
import com.pandora.core.plist.PListParserFactory;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.IPrintlnable;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.internal.RemoteDebugObject;
import com.pandora.tools.android.AndroidPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.PlatformUI;

public class IOSSimulatorLauncher
implements ILauncher {
    private static boolean isLoaded = false;
    private static final String[] XCODES = new String[]{"/Applications/Xcode.app/Contents/MacOS/Xcode", "/Applications/Xcode-Beta.app/Contents/MacOS/Xcode", "/Applications/Xcode-beta.app/Contents/MacOS/Xcode", "/Applications/Xcode Beta.app/Contents/MacOS/Xcode", "/Applications/Xcode beta.app/Contents/MacOS/Xcode", "/Applications/Xcode-Bast.app/Contents/MacOS/Xcode", "/Applications/Xcode-bast.app/Contents/MacOS/Xcode", "/Applications/Xcode Bast.app/Contents/MacOS/Xcode", "/Applications/Xcode bast.app/Contents/MacOS/Xcode"};
    private static final String XCRUN = "xcrun";
    private static final String SIMCTL = "simctl";
    private IMobileListener listener = null;
    private final ProcessBuilder pb = new ProcessBuilder(new String[0]);
    private static String user_home_path = "";
    private Mobile targetMobile = null;
    private String dataFilePath;
    boolean isStoped = false;
    Job logJob;
    String defaultName = "hb.log";
    String currentFileName = "";
    int currentIndex = 0;
    private boolean isNeedWarnCache;

    @Override
    public boolean checkDriver() throws OperateException {
        boolean exist = false;
        String[] stringArray = XCODES;
        int n = XCODES.length;
        int n2 = 0;
        while (n2 < n) {
            String xcode = stringArray[n2];
            if (new File(xcode).exists()) {
                exist = true;
                break;
            }
            ++n2;
        }
        if (!exist) {
            return false;
        }
        final boolean[] result = new boolean[]{true};
        this.executeXCRUNCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                if (line.contains("command not found")) {
                    result[0] = false;
                }
                return false;
            }
        }, "--version");
        return result[0];
    }

    @Override
    public void connect(Mobile machine) throws OperateException {
        this.targetMobile = machine;
        LauncherCoreActivator.addSimulatorIntoMobile(machine);
        List<Mobile> mobiles = LauncherCoreActivator.getMachineList(Platform.IOS_SIMULATOR, DefaultMobileManager.MobileStatus.RUNNING);
        for (Mobile mobile : mobiles) {
            if (mobile.equals(machine)) continue;
            DefaultMobileManager.getInstance().stoped(mobile.getProject(), mobile);
        }
        this.executeXCRUNCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                return false;
            }
        }, "instruments", "-w", machine.getUuid());
    }

    @Override
    public boolean isAppExists(Apps app) throws OperateException {
        return false;
    }

    @Override
    public void installApplication(Apps app) throws OperateException {
        if (!new File(AndroidPlugin.IOS_SIMULATOR_BASE).exists()) {
            if (DefaultMobileManager.isCustom()) {
                throw new OperateException("\u5b89\u88c5\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u5236\u4f5c\u81ea\u5b9a\u57fa\u5ea7App");
            }
            throw new OperateException("\u5b89\u88c5HBuilder\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4ece\u5b98\u7f51\u4e0b\u8f7d\u65b0\u7684HBuilder");
        }
        this.executeXCRUNCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                return false;
            }
        }, SIMCTL, "install", "booted", AndroidPlugin.IOS_SIMULATOR_BASE);
        this.initAppDataPath(app);
    }

    @Override
    public void deletePackage(Apps app) throws OperateException {
        String logDir;
        File logDirFile;
        String wwwDir = this.getWWWPath(app);
        File wwwFile = new File(wwwDir);
        if (wwwFile.exists() && wwwFile.isDirectory()) {
            FileUtil.deleteRecursively((File)wwwFile);
        }
        if ((logDirFile = new File(logDir = this.getLogDirPath(app))).exists() && logDirFile.isDirectory()) {
            FileUtil.deleteRecursively((File)logDirFile);
        }
    }

    @Override
    public void pushPackage(Apps app) throws OperateException {
        String wwwDir = this.getWWWPath(app);
        String localPath = "";
        localPath = app.getResourcePath() != null && app.getResourcePath().exists() ? app.getResourcePath().getAbsolutePath() : app.getProject().getLocation().toOSString();
        File wwwFile = new File(wwwDir);
        if (wwwFile.exists()) {
            this.deletePackage(app);
            wwwFile.mkdirs();
        }
        this.copyDirectiory(localPath, wwwFile.getAbsolutePath(), new File(localPath));
    }

    private void copyDirectiory(String sourceDir, String targetDir, File project) {
        File[] files;
        new File(targetDir).mkdirs();
        File[] fileArray = files = new File(sourceDir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                String fname = file.getName();
                if (!HMobileDeviceLauncher.isSpecName(project, file)) {
                    if (file.isFile()) {
                        File sourceFile = file;
                        File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + fname);
                        FileUtil.copyFile((File)sourceFile, (File)targetFile);
                    }
                    if (file.isDirectory()) {
                        String dir1 = String.valueOf(sourceDir) + "/" + fname;
                        String dir2 = String.valueOf(targetDir) + "/" + fname;
                        this.copyDirectiory(dir1, dir2, project);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void pushResource(Apps app, String resourcePath, String resourceRefPath, String targetPath) throws OperateException {
        String wwwDir = this.getWWWPath(app);
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        FileUtil.copyFile((File)new File(resourcePath), (File)new File(String.valueOf(wwwDir) + targetPath));
        this.wirteRefreshFile(app, resourceRefPath, targetPath);
        this.checkStatus(app, resourcePath);
    }

    @Override
    public void sendRestartCmd(Apps app) throws OperateException {
        String wwwDir = this.getWWWPath(app);
        StringBuffer content = new StringBuffer();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        IProject project = app.getProject();
        try {
            if (project != null && project.hasNature("com.pandora.projects.ui.Wap2AppNature")) {
                content.append("<root cmd=\"restart\">\n");
                content.append("</root>");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String rfilePath = String.valueOf(wwwDir) + ".debug/.debug";
        try {
            File refreshFile = new File(rfilePath);
            if (refreshFile.exists()) {
                refreshFile.delete();
            }
            FileUtils.writeStringToFile((File)new File(rfilePath), (String)content.toString(), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkStatus(final Apps app, final String resourcePath) {
        Job checkRunningJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                block19: {
                    if (resourcePath.endsWith("manifest.json")) {
                        return Status.CANCEL_STATUS;
                    }
                    final boolean[] isRunning = new boolean[1];
                    try {
                        IOSSimulatorLauncher.this.executeXCRUNCommand(new IConsoleLineReader(){

                            @Override
                            public boolean readLine(String line) throws OperateException {
                                if (line.contains(IOSSimulatorLauncher.this.targetMobile.getUuid()) && line.toLowerCase().contains("booted")) {
                                    isRunning[0] = true;
                                }
                                return false;
                            }
                        }, new String[]{IOSSimulatorLauncher.SIMCTL, "list", "devices"});
                    }
                    catch (OperateException e) {
                        e.printStackTrace();
                    }
                    if (!isRunning[0]) {
                        IOSSimulatorLauncher.this.printlnToConsole("iOS \u6a21\u62df\u5668\u5df2\u505c\u6b62\u8fd0\u884c\uff0c\u8bf7\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5...", new OperateException(null));
                        if (IOSSimulatorLauncher.this.listener != null) {
                            IOSSimulatorLauncher.this.listener.disConnected(IOSSimulatorLauncher.this.targetMobile);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ProcessBuilder pidPB = null;
                    Process pidProcess = null;
                    Scanner pidIn = null;
                    InputStream input = null;
                    try {
                        try {
                            ArrayList<String> pidCMDS = new ArrayList<String>();
                            pidCMDS.add("sh");
                            pidCMDS.add("-c");
                            pidCMDS.add("ps aux | grep " + app.getPackageName());
                            pidPB = new ProcessBuilder(pidCMDS);
                            pidProcess = pidPB.start();
                            pidProcess.getOutputStream().flush();
                            pidProcess.getOutputStream().close();
                            input = pidProcess.getInputStream();
                            pidIn = new Scanner(input);
                            boolean appIsRunning = false;
                            String line = null;
                            while (pidIn.hasNextLine()) {
                                line = pidIn.nextLine();
                                if (StringUtil.isBlank((String)line) || !line.contains(String.valueOf(app.getPackageName()) + "/")) continue;
                                appIsRunning = true;
                                break;
                            }
                            if (!appIsRunning) {
                                try {
                                    if (DefaultMobileManager.isCustom()) {
                                        IOSSimulatorLauncher.this.printlnToConsole("\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u672a\u542f\u52a8\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8...", null);
                                    } else {
                                        IOSSimulatorLauncher.this.printlnToConsole("\u5e94\u7528HBuilder\u672a\u542f\u52a8\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8...", null);
                                    }
                                    IOSSimulatorLauncher.this.startApplication(app);
                                }
                                catch (OperateException e) {
                                    e.printStackTrace();
                                }
                            }
                            pidIn.close();
                            IOSSimulatorLauncher.this.close(null, pidProcess, input);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (pidIn != null) {
                                pidIn.close();
                            }
                            IOSSimulatorLauncher.this.close(null, pidProcess, input);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pidIn != null) {
                            pidIn.close();
                        }
                        IOSSimulatorLauncher.this.close(null, pidProcess, input);
                        throw throwable;
                    }
                    if (pidIn != null) {
                        pidIn.close();
                    }
                    IOSSimulatorLauncher.this.close(null, pidProcess, input);
                }
                return Status.OK_STATUS;
            }
        };
        checkRunningJob.setUser(false);
        checkRunningJob.setSystem(true);
        checkRunningJob.schedule();
    }

    public void wirteRefreshFile(Apps app, String resourcePath, String targetPath) {
        String wwwDir = this.getWWWPath(app);
        Set<String> refrences = HMobileDeviceLauncher.getFileReference(app.getProject(), resourcePath);
        StringBuffer content = new StringBuffer();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        content.append("<root>\n");
        if (refrences == null || refrences.isEmpty()) {
            content.append("\t<item path=\"" + targetPath + "\"/>\n");
        } else {
            for (String refrence : refrences) {
                if (refrence.startsWith("/")) {
                    refrence = refrence.substring(1);
                }
                content.append("\t<item path=\"" + refrence + "\"/>\n");
            }
        }
        content.append("</root>");
        String rfilePath = String.valueOf(wwwDir) + ".debug/.debug";
        try {
            File refreshFile = new File(rfilePath);
            if (refreshFile.exists()) {
                refreshFile.delete();
            }
            FileUtils.writeStringToFile((File)new File(rfilePath), (String)content.toString(), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getWWWPath(Apps app) {
        return String.valueOf(this.getAppDataFilePath(app)) + "Documents/Pandora/apps/" + app.getAppid() + "/www/";
    }

    private static String getUserHomePath() {
        if (StringUtil.isBlank((String)user_home_path)) {
            user_home_path = System.getProperty("user.home");
        }
        return user_home_path;
    }

    private void initAppDataPath(Apps app) {
        String newAppendPath;
        File file;
        boolean isIos7 = false;
        if (this.targetMobile.getName().toLowerCase().contains("ios 7")) {
            isIos7 = true;
        }
        String dataApplicationPath = "";
        boolean isContainer = false;
        String appendPath = "Containers/data/Application/";
        if (isIos7) {
            dataApplicationPath = String.valueOf(this.getAppDataPath()) + "Applications/";
            file = new File(dataApplicationPath);
            if (!file.exists()) {
                dataApplicationPath = String.valueOf(this.getAppDataPath()) + appendPath;
                isContainer = true;
            }
        } else {
            dataApplicationPath = String.valueOf(this.getAppDataPath()) + appendPath;
        }
        if (!(file = new File(dataApplicationPath)).exists() && !(file = new File(dataApplicationPath = dataApplicationPath.replace(appendPath, newAppendPath = "Containers/Data/Application/"))).exists()) {
            return;
        }
        File[] dirs = file.listFiles();
        String plistName = ".com.apple.mobile_container_manager.metadata.plist";
        String pName = "";
        String fName = "";
        fName = isIos7 && !isContainer ? (pName = app.getPackageName()) : plistName;
        File dataFile = null;
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File plistFile;
            File dir = fileArray[n2];
            if (dir.isDirectory() && (plistFile = new File(dir, fName)).exists()) {
                if (isIos7 && !isContainer) {
                    dataFile = dir;
                    break;
                }
                try {
                    String indentifer;
                    Map map = PListParserFactory.parse((File)plistFile);
                    Object object = map.get("MCMMetadataIdentifier");
                    if (object != null && !StringUtil.isBlank((String)(indentifer = object.toString())) && indentifer.equals(app.getId())) {
                        dataFile = dir;
                        break;
                    }
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
        if (dataFile == null) {
            return;
        }
        this.dataFilePath = String.valueOf(dataFile.getAbsolutePath()) + "/";
    }

    private String getAppDataFilePath(Apps app) {
        if (StringUtil.isBlank((String)this.dataFilePath)) {
            this.initAppDataPath(app);
        }
        return this.dataFilePath;
    }

    private String getAppDataPath() {
        return String.valueOf(IOSSimulatorLauncher.getUserHomePath()) + "/Library/Developer/CoreSimulator/Devices/" + this.targetMobile.getUuid() + "/data/";
    }

    @Override
    public void startApplication(Apps app) throws OperateException {
        if (DefaultMobileManager.isCustom()) {
            this.printlnToConsole("\u6b63\u5728\u542f\u52a8\u81ea\u5b9a\u4e49\u57fa\u5ea7App...", null);
        } else {
            this.printlnToConsole("\u6b63\u5728\u542f\u52a8\u5e94\u7528HBuilder...", null);
        }
        this.executeXCRUNCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                return false;
            }
        }, SIMCTL, "launch", "booted", app.getId());
        try {
            if (DefaultMobileManager.isCustom()) {
                IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(LauncherCoreActivator.PLUGIN_ID);
                boolean isFirstRunIosSim = true;
                isFirstRunIosSim = prefs.getBoolean("first_launch_ios_sim", true);
                if (isFirstRunIosSim) {
                    this.printlnToConsole("\u6a21\u62df\u5668\u8c03\u8bd5\u5e76\u975e\u6253\u5305\uff0c\u8c03\u8bd5\u5305\u662f HBuilder\u9ed8\u8ba4\u7684\u6d4b\u8bd5\u5305\uff0c\u6743\u9650\u3001\u56fe\u6807\u90fd\u4e0d\u53ef\u81ea\u5b9a\u4e49\u3002\u53ea\u6709\u5728\u70b9\u83dc\u5355\u53d1\u884c-App\u6253\u5305\u65f6\u624d\u80fd\u81ea\u5b9a\u4e49\u8fd9\u4e9b\u8bbe\u7f6e", new OperateException(null));
                    prefs.putBoolean("first_launch_ios_sim", false);
                    prefs.flush();
                }
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
        this.printlnToConsole("iOS\u6a21\u62df\u5668\u53ef\u4f7f\u7528console.log()\u8f93\u51fa\u5185\u5bb9\u5230\u63a7\u5236\u53f0\uff0c\u4f46\u662f\u53ef\u80fd\u53ea\u80fd\u8f93\u51faplusready\u4e4b\u540e\u7684\u8c03\u8bd5\u5185\u5bb9", new OperateException(null));
        if (DefaultMobileManager.isCustom()) {
            this.printlnToConsole("\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5df2\u542f\u52a8\uff08\u5982\u672a\u542f\u52a8\u8bf7\u624b\u52a8\u542f\u52a8\u6a21\u62df\u5668\u4e0a\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7App\uff09...", new OperateException(null));
        } else {
            this.printlnToConsole("\u5e94\u7528HBuilder\u5df2\u542f\u52a8\uff08\u5982\u672a\u542f\u52a8\u8bf7\u624b\u52a8\u542f\u52a8\u6a21\u62df\u5668\u4e0a\u7684HBuilder\u5e94\u7528\uff09...", new OperateException(null));
        }
    }

    @Override
    public void addLauncherListener(IMobileListener listener) {
        this.listener = listener;
    }

    @Override
    public Apps getTestApp(IProject project) {
        return new Apps("io.dcloud.HBuilder", "Pandora_simulator.app", "HBuilder", project, AndroidPlugin.IOS_SIMULATOR_BASE, AndroidPlugin.IOS_SIMULATOR_BASE_VERSION);
    }

    public void printlnToConsole(String message, OperateException exception) {
        if (this.listener instanceof IPrintlnable) {
            IPrintlnable print = (IPrintlnable)((Object)this.listener);
            if (exception == null) {
                print.printlnToConsole(message);
            } else {
                print.printlnToConsole(message, exception);
            }
        }
    }

    @Override
    public void listeningDeviceList() {
        if (isLoaded) {
            return;
        }
        Job listenSimulatorDeviceThread = new Job("\u6b63\u5728\u68c0\u6d4b\u6a21\u62df\u5668\uff0c\u8bf7\u7a0d\u540e..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!IOSSimulatorLauncher.this.checkDriver()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    final ArrayList simulators = new ArrayList();
                    final String[] osVersion = new String[1];
                    IOSSimulatorLauncher.this.executeXCRUNCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws OperateException {
                            if (line.startsWith("-- ") && line.endsWith(" --") && !line.contains("Unavailable:") && line.length() > 6) {
                                osVersion[0] = line.substring(3, line.length() - 3).trim();
                            }
                            if (line.contains("(") && line.contains(")") && !line.contains("runtime profile not found")) {
                                isLoaded = true;
                                int bindex = line.lastIndexOf("(");
                                line = line.substring(0, bindex);
                                bindex = line.lastIndexOf("(");
                                int eindex = line.lastIndexOf(")");
                                if (eindex > bindex) {
                                    String name = line.substring(0, bindex).trim();
                                    if (StringUtil.isNotBlank((String)osVersion[0])) {
                                        name = String.valueOf(name) + " (" + osVersion[0] + ")";
                                    }
                                    String devicesID = line.substring(bindex + 1, eindex);
                                    Mobile m = new Mobile(name, "/icons/ios_sim.png");
                                    m.setUuid(devicesID);
                                    m.setPlatform(Platform.IOS_SIMULATOR);
                                    if (IOSSimulatorLauncher.this.listener != null) {
                                        IOSSimulatorLauncher.this.listener.connected(m);
                                    }
                                    simulators.add(m);
                                }
                            }
                            return false;
                        }
                    }, new String[]{IOSSimulatorLauncher.SIMCTL, "list", "devices"});
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    List<Mobile> mobileList = LauncherCoreActivator.getSimulatorList();
                    for (Mobile m : simulators) {
                        if (m.getName().toLowerCase().startsWith("iphone 5s")) {
                            LauncherCoreActivator.addSimulatorIntoMobile(m);
                        }
                        if (mobileList.contains(m) || IOSSimulatorLauncher.this.isExistMobile(m, mobileList)) continue;
                        LauncherCoreActivator.addSimulator(m);
                    }
                }
                catch (OperateException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        listenSimulatorDeviceThread.setUser(false);
        listenSimulatorDeviceThread.setSystem(true);
        listenSimulatorDeviceThread.schedule();
    }

    private boolean isExistMobile(Mobile mobile, List<Mobile> mobileList) {
        boolean isExist = false;
        if (mobile == null) {
            return isExist;
        }
        for (Mobile mobi : mobileList) {
            if (mobi == null || !mobile.getUuid().equals(mobi.getUuid())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    public void deleteResource(Apps app, String resourceRefPath, String targetPath) throws OperateException {
        String wwwDir = this.getWWWPath(app);
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        try {
            File tFile = new File(String.valueOf(wwwDir) + targetPath);
            tFile.delete();
            if (tFile.exists()) {
                String[] cmd = new String[]{"rm", "-rf", String.valueOf(wwwDir) + targetPath};
                Process process = Runtime.getRuntime().exec(cmd);
                process.getOutputStream().flush();
                process.getOutputStream().close();
                process.destroy();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wirteRefreshFile(app, resourceRefPath, targetPath);
    }

    private boolean executeXCRUNCommand(IConsoleLineReader lineReader, String ... command) throws OperateException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(XCRUN);
        commands.addAll(Arrays.asList(command));
        this.pb.command(commands.toArray(new String[commands.size()]));
        this.pb.redirectErrorStream(true);
        BufferedReader reader = null;
        Process process = null;
        InputStream is = null;
        boolean result = false;
        try {
            try {
                process = this.pb.start();
                process.getOutputStream().flush();
                process.getOutputStream().close();
                is = process.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (StringUtil.isEmpty((String)line)) continue;
                    result = lineReader.readLine(line);
                }
                this.close(reader, process, is);
            }
            catch (IOException e) {
                throw new OperateException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.close(reader, process, is);
            throw throwable;
        }
        this.close(reader, process, is);
        return result;
    }

    public void close(BufferedReader reader, Process process, InputStream is) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (process != null) {
            process.destroy();
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getLogDirPath(Apps app) {
        return String.valueOf(this.getAppDataFilePath(app)) + "Documents/Pandora/apps/" + app.getAppid() + "/log/";
    }

    @Override
    public void getApplicationLog(final Apps app) throws OperateException {
        this.logJob = new Job("\u83b7\u53d6\u65e5\u5fd7"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled() || IOSSimulatorLauncher.this.isStoped) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IOSSimulatorLauncher.this.readFile(IOSSimulatorLauncher.this.getLogDirPath(app), IOSSimulatorLauncher.this.getLogFileName());
                    if (monitor.isCanceled() || IOSSimulatorLauncher.this.isStoped) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (PlatformUI.isWorkbenchRunning()) {
                        this.schedule(1000L);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.logJob.setUser(false);
        this.logJob.setSystem(true);
        this.logJob.schedule();
    }

    @Override
    public void clearApplicationLog(Apps app) throws OperateException {
        if (this.logJob != null) {
            this.logJob.cancel();
        }
        this.isStoped = true;
    }

    @Override
    public void stopApplication(Apps app) throws OperateException {
    }

    @Override
    public List<Mobile> getMachineList() {
        return null;
    }

    public boolean checkLogFile(String rootPath, String name) {
        boolean result = false;
        if (StringUtil.isBlank((String)name)) {
            return result;
        }
        if (!name.equals(this.getLogFileName())) {
            if (name.equals(this.defaultName)) {
                this.setLogFileName(this.defaultName);
            } else {
                return result;
            }
        }
        result = new File(String.valueOf(rootPath) + name).exists();
        return result;
    }

    public synchronized void readFile(String rootPath, String name) {
        if (!this.checkLogFile(rootPath, name)) {
            return;
        }
        File file = new File(String.valueOf(rootPath) + name);
        try {
            int bl;
            int i;
            if (this.isStoped) {
                return;
            }
            int wpLength = "/Documents/Pandora/apps/HBuilder/www/".length();
            byte[] logBytes = FileUtils.readFileToByteArray((File)file);
            if (this.isStoped) {
                return;
            }
            if (logBytes == null) {
                return;
            }
            byte[] pbyte = null;
            boolean isCompleted = false;
            int length = logBytes.length;
            int pl = 0;
            boolean needDelete = false;
            String newFileName = "";
            if (logBytes.length > 9216 - this.getLogFileName().length()) {
                ArrayList<Byte> fnameByteList = new ArrayList<Byte>();
                i = logBytes.length - 1;
                while (i > 0) {
                    if (i > 0 && logBytes[i] == 10 && logBytes[i - 1] == 13) break;
                    ++pl;
                    fnameByteList.add(logBytes[i]);
                    --i;
                }
                int size = fnameByteList.size();
                if (size > 8 && (Byte)fnameByteList.get(0) == -1 && (Byte)fnameByteList.get(1) == -1 && (Byte)fnameByteList.get(2) == -1 && (Byte)fnameByteList.get(3) == -1 && (Byte)fnameByteList.get(size - 1) == -1 && (Byte)fnameByteList.get(size - 2) == -1 && (Byte)fnameByteList.get(size - 3) == -1 && (Byte)fnameByteList.get(size - 4) == -1) {
                    byte[] fnameByte = new byte[fnameByteList.size() - 8];
                    int i2 = 0;
                    int j = fnameByteList.size() - 5;
                    while (j > 3) {
                        fnameByte[i2] = (Byte)fnameByteList.get(j);
                        ++i2;
                        --j;
                    }
                    if (fnameByte.length > 0) {
                        isCompleted = true;
                        newFileName = new String(fnameByte);
                        needDelete = true;
                    }
                }
            }
            if (this.isStoped) {
                return;
            }
            int unReadLen = logBytes.length - this.currentIndex;
            if (this.currentIndex == 0 && pl < 1 || unReadLen < 0) {
                pbyte = logBytes;
            } else {
                pbyte = new byte[unReadLen];
                i = this.currentIndex;
                while (i < length - pl) {
                    pbyte[i - this.currentIndex] = logBytes[i];
                    ++i;
                }
            }
            this.currentIndex = isCompleted ? 0 : logBytes.length;
            if (this.isStoped) {
                return;
            }
            String logContent = new String(pbyte);
            String[] logs = logContent.split("\r\n");
            int l = logs.length - 1;
            if (l > -1 && !logContent.endsWith("\r\n") && StringUtil.isNotBlank((String)logs[l]) && this.currentIndex > (bl = logs[l].getBytes().length)) {
                this.currentIndex -= bl;
                logs[l] = "";
            }
            if (this.isStoped) {
                return;
            }
            String[] stringArray = logs;
            int n = logs.length;
            int n2 = 0;
            while (n2 < n) {
                String log = stringArray[n2];
                if (!StringUtil.isBlank((String)log) && !log.contains("\ufffd\ufffd\ufffd\ufffd")) {
                    if ((log = HMobileDeviceLauncher.transSourceMapLog(log, sourceMap)).startsWith("[ERROR] :")) {
                        int findex = log.indexOf("file:///");
                        int windex = log.indexOf("/Documents/Pandora/apps/HBuilder/www/");
                        if (findex > 0 && windex > 0) {
                            String tmp = log.substring(findex, windex + wpLength);
                            log = log.replace(tmp, "");
                            log = log.replace("filename:", "file name:");
                            log = log.replace("lineno:", "line no:");
                        }
                        this.printlnToConsole(log, new OperateException(null));
                    } else {
                        this.printlnToConsole(log, null);
                    }
                }
                ++n2;
            }
            if (needDelete) {
                FileUtil.deleteRecursively((File)file);
                if (StringUtil.isNotBlank((String)newFileName)) {
                    this.setLogFileName(newFileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getLogFileName() {
        if (StringUtil.isBlank((String)this.currentFileName)) {
            this.currentFileName = this.defaultName;
        }
        return this.currentFileName;
    }

    private void setLogFileName(String fname) {
        this.currentFileName = fname;
    }

    public boolean isNeedWarnCache() {
        return this.isNeedWarnCache;
    }

    @Override
    public void setNeedWarnCache(boolean b) {
        this.isNeedWarnCache = b;
    }

    @Override
    public Map<String, List<RemoteDebugObject>> getRemoteDebugUrls(Mobile mobile) throws OperateException {
        return null;
    }

    static interface IConsoleLineReader {
        public boolean readLine(String var1) throws OperateException;
    }
}

