/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.android;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.CoreActivator;
import com.pandora.core.Platform;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.log.HBLog;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.InputStreamRunnable;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StatusLineUtils;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.IJobRunnable;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.IPrintlnable;
import com.pandora.launcher.core.IProgressMonitorAware;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.Messages;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.idevice.CommonToolLibraryRegistry;
import com.pandora.launcher.core.idevice.IAndroidDeviceListHandler;
import com.pandora.launcher.core.idevice.ICommonToolLibrary;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.internal.RemoteDebugObject;
import com.pandora.launcher.core.listener.IAutoTransfor;
import com.pandora.tools.android.AndroidPlugin;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.wink.json4j.JSON;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class AndroidLauncher
implements ILauncher,
IProgressMonitorAware {
    public static final String UPDATE_ALL_COMMAND = "snc:update all";
    public static final String UPDATE_CURRENT_COMMAND = "snc:update current";
    public static final String UPDATE_SINGLE_FILE_PATTERN = "snc:update {0}";
    public static final String ROOT_PATH_COMMAND = "sconn:request_root_path";
    private static int CHROME_DEBUG_PORT = 9323;
    private static String CHROME_DEBUG_PORT_PROXY_SERVER = "127.0.0.1";
    public static int BASE_PORT = 13131;
    private int forwardPort = BASE_PORT;
    private static String regEx = "[\u4e00-\u9fa5]";
    private static Pattern pattern = Pattern.compile(regEx);
    private static String modelReg = "model:(.*)device:";
    private final ProcessBuilder pb = new ProcessBuilder(new String[0]);
    private IMobileListener launcherListener = null;
    private Mobile targetMobile = null;
    private IProgressMonitor monitor = null;
    private static ICommonToolLibrary deviceLibrary = null;
    private static String EXTERNAL_STORAGE = "$EXTERNAL_STORAGE";
    private static String ENV_SECONDARY_STORAGE = "$SECONDARY_STORAGE";
    private boolean needSetInstallLoation = false;
    private Job listenDeviceThread;
    private String installPath;
    private long previousTimeStamp = 0L;
    private static boolean isAdded = false;
    private String appName;
    private Thread logThread;
    private boolean isLogcating = false;
    private Job streamAppJSonJob;
    IJobRunnable jobRunnable;
    private boolean isNeedWarnCache;

    public AndroidLauncher() {
        deviceLibrary = deviceLibrary == null ? CommonToolLibraryRegistry.getDeviceLibrary() : deviceLibrary;
    }

    @Override
    public boolean checkDriver() throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) {
                System.out.println(line);
                return false;
            }
        }, "version");
        return true;
    }

    public void killADBServer(boolean needRemoveHandler) {
        if (needRemoveHandler) {
            this.removeNotificationHandler();
        }
        this.stopJobs();
        this.killADBProcess();
    }

    private void removeNotificationHandler() {
        if (deviceLibrary != null) {
            deviceLibrary.removeNotificationHandler();
        }
    }

    private void stopAdbServer() {
        try {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) {
                    HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                    return false;
                }
            }, "kill-server");
        }
        catch (OperateException e) {
            e.printStackTrace();
        }
    }

    public void stopJobs() {
        if (this.logThread != null) {
            this.logThread.interrupt();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeADBCommand(IConsoleLineReader lineReader, String ... command) throws OperateException {
        String adbPath = "";
        try {
            adbPath = AndroidPlugin.ADB_PATH;
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)("executeADBCommand AndroidPlugin.ADB_PATH error======" + e.getMessage()));
        }
        boolean result = false;
        if (StringUtil.isEmpty((String)adbPath)) {
            return false;
        }
        File file = new File(adbPath);
        if (file.exists()) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(file.getAbsolutePath());
            commands.addAll(Arrays.asList(command));
            if (!commands.contains("devices")) {
                HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)StringUtil.join((String)" ", commands));
            }
            this.pb.command(commands.toArray(new String[commands.size()]));
            this.pb.redirectErrorStream(true);
            BufferedReader reader = null;
            Process process = null;
            InputStream is = null;
            boolean needRestart = false;
            boolean needRestartCommand = false;
            try {
                try {
                    block40: {
                        process = this.pb.start();
                        Thread t = new Thread((Runnable)new InputStreamRunnable(process.getErrorStream(), "ADB Error"));
                        t.start();
                        process.getOutputStream().flush();
                        process.getOutputStream().close();
                        is = process.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        boolean contains = commands.contains("webview_devtools_remote");
                        final Process pc = process;
                        Job job = new Job("processJob"){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                try {
                                    pc.destroy();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        if (contains) {
                            job.schedule(2000L);
                        } else if (!commands.contains("logcat")) {
                            job.schedule(60000L);
                        }
                        try {
                            if (commands.contains("logcat")) {
                                while (reader.read() != -1) {
                                    try {
                                        line = reader.readLine();
                                        if (!StringUtil.isNotEmpty((String)line)) continue;
                                        if (line.contains("device not found")) {
                                            if (this.logThread != null) {
                                                this.logThread.interrupt();
                                            }
                                            this.isLogcating = false;
                                            String name = null;
                                            if (this.targetMobile != null) {
                                                name = StringUtil.isNotBlank((String)this.targetMobile.getModel()) ? this.targetMobile.getModel() : this.targetMobile.getName();
                                            }
                                            LauncherCoreActivator.removeMobile(this.targetMobile.getName(), Platform.ANDROID);
                                            throw new OperateException("Android\u8bbe\u5907[" + name + "]\u5df2\u5931\u53bb\u8fde\u63a5", true, true);
                                        }
                                        result = lineReader.readLine(line);
                                    }
                                    catch (BreakException e) {
                                        this.close(reader, process, is);
                                        if (e.isStop()) {
                                            throw new OperateException(e.getMessage());
                                        }
                                        break block40;
                                    }
                                }
                                break block40;
                            }
                            while ((line = reader.readLine()) != null) {
                                try {
                                    if (StringUtil.isEmpty((String)line)) continue;
                                    if (line.contains("device not found")) {
                                        if (this.logThread != null) {
                                            this.logThread.interrupt();
                                        }
                                        this.isLogcating = false;
                                        String name = null;
                                        if (this.targetMobile != null) {
                                            name = StringUtil.isNotBlank((String)this.targetMobile.getModel()) ? this.targetMobile.getModel() : this.targetMobile.getName();
                                        }
                                        LauncherCoreActivator.removeMobile(this.targetMobile.getName(), Platform.ANDROID);
                                        throw new OperateException("Android\u8bbe\u5907[" + name + "]\u5df2\u5931\u53bb\u8fde\u63a5", true, true);
                                    }
                                    if (line.contains("ADB server didn't ACK")) {
                                        if (AndroidPlugin.ADB_PATH.equals(AndroidPlugin.ADB_PATH_32) && !contains) {
                                            needRestartCommand = true;
                                            AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_31);
                                            break;
                                        }
                                        if (AndroidPlugin.ADB_PATH.equals(AndroidPlugin.ADB_PATH_31) && !contains) {
                                            String pid = AndroidPlugin.getADBPID();
                                            if (StringUtil.isNotBlank((String)pid)) {
                                                String[] adbPaths = AndroidPlugin.getAdbByPid((String)pid);
                                                String exeName = adbPaths[0];
                                                String adbp = adbPaths[1];
                                                String adbFilePath = this.getAdbFileDir();
                                                if (adbp.startsWith(adbFilePath)) {
                                                    throw new OperateException("\u68c0\u6d4b\u5230ADB\u5f02\u5e38\uff0c\u8fdb\u7a0bID\u4e3a\uff1a" + pid + "\uff0c\u8fdb\u7a0b\u540d\u79f0\u4e3a\uff1a" + exeName + "\uff0c\u8bf7\u4ece\u4efb\u52a1\u7ba1\u7406\u5668\u7ed3\u675f\u8be5\u8fdb\u7a0b\uff0c\u7136\u540e\u91cd\u8bd5\u3002", true, true);
                                                }
                                                throw new OperateException("\u68c0\u6d4b\u5230ADB\u51b2\u7a81\uff0c\u8fdb\u7a0bID\u4e3a\uff1a" + pid + "\uff0c\u8fdb\u7a0b\u540d\u79f0\u4e3a\uff1a" + exeName + "\uff0c\u8bf7\u4ece\u4efb\u52a1\u7ba1\u7406\u5668\u7ed3\u675f\u8be5\u8fdb\u7a0b\uff0c\u7136\u540e\u91cd\u8bd5\u3002", true, true);
                                            }
                                        } else {
                                            needRestartCommand = true;
                                            AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_32);
                                        }
                                        break;
                                    }
                                    if (!commands.contains("start-server") && line.contains("out of date")) continue;
                                    if (line.startsWith("*") && line.endsWith("*")) {
                                        if (commands.contains("start-server") || line.contains("daemon not running") && line.contains("starting it now on port 5037") || !line.contains("daemon started successfully")) continue;
                                        continue;
                                    }
                                    result = lineReader.readLine(line);
                                }
                                catch (BreakException e) {
                                    this.close(reader, process, is);
                                    if (e.isStop()) {
                                        throw new OperateException(e.getMessage());
                                    }
                                    break;
                                }
                            }
                        }
                        finally {
                            if (contains && job != null) {
                                job.cancel();
                            }
                        }
                    }
                    this.close(reader, process, is);
                }
                catch (Throwable e) {
                    throw new OperateException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.close(reader, process, is);
                throw throwable;
            }
            this.close(reader, process, is);
            if (needRestart) {
                this.stopAdbServer();
                AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_32);
                this.executeADBCommand(new IConsoleLineReader(){

                    @Override
                    public boolean readLine(String line) {
                        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                        return false;
                    }
                }, "start-server");
                this.executeADBCommand(lineReader, command);
            }
            if (needRestartCommand) {
                this.executeADBCommand(lineReader, command);
            }
        }
        return result;
    }

    public void close(BufferedReader reader, Process process, InputStream is) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (process != null) {
            process.destroy();
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startADBServer(final boolean needChage) {
        Job startADBJob = new Job("Start ADB Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final boolean[] needRestart = new boolean[1];
                    AndroidLauncher.this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws OperateException {
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                            if (needChage && line.contains("out of date")) {
                                needRestart[0] = true;
                            }
                            return false;
                        }
                    }, new String[]{"start-server"});
                    if (needRestart[0]) {
                        AndroidLauncher.this.stopAdbServer();
                        AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_31);
                        AndroidLauncher.this.executeADBCommand(new IConsoleLineReader(){

                            @Override
                            public boolean readLine(String line) {
                                HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                                return false;
                            }
                        }, new String[]{"start-server"});
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        startADBJob.setSystem(true);
        startADBJob.schedule();
    }

    protected void println(String line, OperateException exception) {
        if (this.launcherListener instanceof IPrintlnable) {
            IPrintlnable print = (IPrintlnable)((Object)this.launcherListener);
            if (exception == null) {
                print.printlnToConsole(line);
            } else {
                print.printlnToConsole(line, exception);
            }
        }
    }

    @Override
    public void connect(Mobile mobile) throws OperateException {
        this.targetMobile = mobile;
        this.forwardPort = BASE_PORT++;
        this.isLogcating = false;
        this.setNeedSetInstallLoation(false);
        this.checkAdb();
        final HashMap seriaNums = new HashMap();
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException, OperateException {
                if (StringUtil.isNotBlank((String)line)) {
                    String[] results = line.split("\t");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < results.length - 1) {
                        if (StringUtil.isNotBlank((String)results[i])) {
                            sb.append(results[i]);
                        }
                        ++i;
                    }
                    String seriaNum = sb.toString();
                    String status = "";
                    int length = results.length;
                    if (length > 1) {
                        status = results[length - 1];
                        status = status.toLowerCase();
                    }
                    if (StringUtil.isNotEmpty((String)seriaNum) && seriaNum.equals(AndroidLauncher.this.targetMobile.getName())) {
                        if (seriaNums.containsKey(seriaNum)) {
                            AndroidLauncher.this.println("\u63d0\u793a\uff1a\u68c0\u6d4b\u5230\u4e24\u4e2a\u76f8\u540c\u5e8f\u5217\u53f7\u8bbe\u5907\uff0c\u6709\u53ef\u80fd\u5bfc\u81f4HBuilder\u5b89\u88c5\u57fa\u5ea7App\u6216\u540c\u6b65\u8d44\u6e90\u4e0d\u6210\u529f\uff0c\n\u5982\u679c\u53d1\u73b0\u4e0d\u6210\u529f\u7684\u60c5\u51b5\uff0c\u8bf7\u5173\u6389\u6240\u6709\u624b\u673a\u52a9\u624b\u6216\u8005\u66f4\u6362\u624b\u673a\u52a9\u624b\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5", new OperateException(""));
                            String status_ = (String)seriaNums.get(seriaNum);
                            if (StringUtil.isNotBlank((String)status_) && (status_.equals("offline") || status_.equals("unauthorized"))) {
                                seriaNums.put(seriaNum, status);
                            }
                        } else {
                            seriaNums.put(seriaNum, status);
                        }
                    }
                }
                return false;
            }
        }, "devices");
        String status = (String)seriaNums.get(this.targetMobile.getName());
        if ("offline".equals(status)) {
            throw new OperateException("\u771f\u673a\u8fd0\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u624b\u673a\u4e0eHBuilder\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u62d4\u6389\u624b\u673a\u91cd\u65b0\u63d2\u5165\u6216\u91cd\u5f00USB\u8c03\u8bd5\u6a21\u5f0f\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5");
        }
        if ("unauthorized".equals(status)) {
            throw new OperateException("\u771f\u673a\u8fd0\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u624b\u673a\u4e0a\u6ca1\u6709\u4fe1\u4efb\u672c\u8ba1\u7b97\u673a\u7684\u6388\u6743\uff0c\u8bf7\u5728\u624b\u673a\u4e0a\u4fe1\u4efb\u8be5\u6388\u6743");
        }
        this.forwardToMobile();
        if (this.launcherListener != null) {
            this.launcherListener.connected(mobile);
        }
        this.setSDcardDir(EXTERNAL_STORAGE);
    }

    public void checkAdb() {
        try {
            String[] paths = AndroidPlugin.setADB(null);
            if (paths != null) {
                String pid = paths[0];
                if (StringUtil.isBlank((String)pid)) {
                    return;
                }
                String exeName = paths[1];
                String path = paths[2];
                if (StringUtil.isBlank((String)path)) {
                    return;
                }
                String fPath = path.toLowerCase();
                String adbFilePath = this.getAdbFileDir();
                boolean b = false;
                if (StringUtil.isNotBlank((String)AndroidPlugin.CUSTOM_ADB_PATH)) {
                    if (!fPath.startsWith(adbFilePath) && !fPath.startsWith(AndroidPlugin.CUSTOM_ADB_PATH)) {
                        b = true;
                    }
                } else if (!fPath.startsWith(adbFilePath)) {
                    b = true;
                }
                if (b) {
                    this.println("\u6ce8\uff1a\u68c0\u6d4b\u5230\u5f53\u524d\u4f7f\u7528\u7684ADB\u4e0d\u662fHBuilder\u5185\u7f6e\u6216\u81ea\u5b9a\u4e49ADB\uff1a\nPID\u4e3a\uff1a" + pid + "\uff0c\u8fdb\u7a0b\u540d\u79f0\uff1a" + exeName + "\n\u8def\u5f84\u4e3a\uff1a" + path + "\n\u53ef\u80fd\u5b58\u5728adb\u51b2\u7a81\u9020\u6210\u771f\u673a\u8fd0\u884c\u5f02\u5e38\u7684\u60c5\u51b5\uff0c\u5982\u679c\u6b63\u5e38\u5219\u5ffd\u7565" + "\n\u5982\u679c\u9047\u5230\u5f02\u5e38\u60c5\u51b5\uff0c\u70b9\u51fb\u68c0\u67e5adb\u51b2\u7a81\u3002", new OperateException(""));
                }
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    public String getAdbFileDir() {
        if (StringUtil.isBlank((String)this.installPath)) {
            try {
                this.installPath = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)org.eclipse.core.runtime.Platform.getInstallLocation().getURL()));
                this.installPath = this.installPath.toLowerCase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File adbFile = new File(String.valueOf(this.installPath) + "/tools/adbs/");
        String adbFilePath = adbFile.getAbsolutePath();
        adbFilePath = adbFilePath.toLowerCase();
        return adbFilePath;
    }

    private void forwardToMobile() throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                if (StringUtil.isNotEmpty((String)line)) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "forward", "tcp:" + this.forwardPort, "tcp:13131");
    }

    public boolean isNeedSetInstallLoation() {
        return this.needSetInstallLoation;
    }

    public void setNeedSetInstallLoation(boolean needSetInstallLoation) {
        this.needSetInstallLoation = needSetInstallLoation;
    }

    private void setSDcardDir(String evn) throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                if (StringUtil.isNotBlank((String)line) && line.startsWith("/")) {
                    AndroidLauncher.this.targetMobile.setSdcardDir(line);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "echo", EXTERNAL_STORAGE);
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                if (StringUtil.isNotBlank((String)line) && line.startsWith("/")) {
                    AndroidLauncher.this.setNeedSetInstallLoation(true);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "echo", ENV_SECONDARY_STORAGE);
    }

    @Override
    public boolean isAppExists(Apps app) throws OperateException {
        boolean appExists;
        block8: {
            appExists = false;
            String adbPath = AndroidPlugin.ADB_PATH;
            File file = new File(adbPath);
            if (file.exists()) {
                this.pb.command(file.getAbsolutePath(), "-s", this.targetMobile.getName(), "shell", "pm", "list", "packages");
                this.pb.redirectErrorStream(true);
                BufferedReader reader = null;
                Process process = null;
                InputStream is = null;
                try {
                    try {
                        process = this.pb.start();
                        is = process.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                            if (line.endsWith(app.getId())) {
                                boolean bl = appExists = !this.needUpdate(app);
                            }
                            if (!line.endsWith("com.dheaven.HBuilder")) continue;
                            this.uninstallApplication(new Apps("com.dheaven.HBuilder", "io.dcloud.PandoraEntry", "HBuilder", app.getProject(), app.getBasePath(), app.getBaseVersion()));
                        }
                        this.worked(15);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                        this.close(reader, process, is);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.close(reader, process, is);
                    throw throwable;
                }
                this.close(reader, process, is);
            }
        }
        return appExists;
    }

    private boolean needUpdate(Apps app) {
        boolean needUpdate;
        block7: {
            needUpdate = false;
            String adbPath = AndroidPlugin.ADB_PATH;
            File file = new File(adbPath);
            if (file.exists()) {
                this.pb.command(file.getAbsolutePath(), "-s", this.targetMobile.getName(), "shell", "dumpsys", "package", app.getId());
                this.pb.redirectErrorStream(true);
                BufferedReader reader = null;
                Process process = null;
                InputStream is = null;
                try {
                    try {
                        process = this.pb.start();
                        is = process.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                            if (!line.contains("versionName")) continue;
                            String versionCode = line.substring(line.indexOf("versionName=") + "versionName=".length(), line.length());
                            if (app.getBaseVersion().equals(versionCode)) continue;
                            needUpdate = this.uninstallApplication(app);
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                        this.close(reader, process, is);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(reader, process, is);
                    throw throwable;
                }
                this.close(reader, process, is);
            }
        }
        return needUpdate;
    }

    private void worked(int i) {
        if (this.monitor != null) {
            this.monitor.worked(i);
        }
    }

    public Job getListenDeviceThread() {
        return this.listenDeviceThread;
    }

    @Override
    public void listeningDeviceList() {
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)com.pandora.launcher.core.android.Messages.AndroidLauncher_Start_Andriod_Lisener);
        try {
            if (StringUtil.isBlank((String)this.installPath)) {
                this.installPath = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)org.eclipse.core.runtime.Platform.getInstallLocation().getURL()));
                this.installPath = this.installPath.toLowerCase();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.addNotificationHandler();
        this.listAndroidDevices();
    }

    public void listAndroidDevices() {
        long timeStamp = System.currentTimeMillis();
        if (this.isRunning()) {
            if (this.previousTimeStamp != 0L && timeStamp - this.previousTimeStamp < 3000L) {
                return;
            }
            this.killADBServer(false);
        }
        this.previousTimeStamp = timeStamp;
        this.listenDeviceThread = new Job("\u6b63\u5728\u68c0\u6d4b\u624b\u673a\uff0c\u8bf7\u7a0d\u540e..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!org.eclipse.core.runtime.Platform.isRunning()) {
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    List<Mobile> mobiles = AndroidLauncher.this.getMachineList();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (mobiles != null) {
                        String message;
                        List<Mobile> mobileList = LauncherCoreActivator.getMobileList();
                        ArrayList<Mobile> removeList = new ArrayList<Mobile>();
                        for (Mobile m : mobileList) {
                            if (m.getPlatform() != Platform.ANDROID || mobiles.contains(m)) continue;
                            removeList.add(m);
                        }
                        for (Mobile m : removeList) {
                            LauncherCoreActivator.removeMobile(m.getName(), Platform.ANDROID);
                            if (AndroidLauncher.this.launcherListener != null) {
                                AndroidLauncher.this.launcherListener.disConnected(m);
                            }
                            message = String.valueOf(com.pandora.launcher.core.android.Messages.AndroidLauncher_Phone) + (StringUtil.isNotBlank((String)m.getModel()) ? m.getModel() : m.getName()) + com.pandora.launcher.core.android.Messages.AndroidLauncher_Connected_Existed;
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)message);
                            StatusLineUtils.showStatusMessage((String)message, (long)5000L);
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        for (Mobile m : mobiles) {
                            if (mobileList.contains(m)) continue;
                            if (AndroidLauncher.this.launcherListener != null) {
                                AndroidLauncher.this.launcherListener.connected(m);
                            }
                            message = String.valueOf(com.pandora.launcher.core.android.Messages.AndroidLauncher_Phone) + (StringUtil.isNotBlank((String)m.getModel()) ? m.getModel() : m.getName()) + com.pandora.launcher.core.android.Messages.AndroidLauncher_Connected;
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)message);
                            StatusLineUtils.showStatusMessage((String)message, (long)10000L);
                            LauncherCoreActivator.addMobile(m);
                        }
                        if (AndroidLauncher.this.jobRunnable != null) {
                            if (mobiles.size() > 0) {
                                AndroidLauncher.this.jobRunnable.hasDevices();
                            } else {
                                AndroidLauncher.this.jobRunnable.isRunnabled();
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                catch (Throwable e) {
                    Stats.addExceptionInfo((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        this.listenDeviceThread.setSystem(true);
        this.listenDeviceThread.setUser(false);
        this.listenDeviceThread.schedule();
    }

    public void addNotificationHandler() {
        if (isAdded || deviceLibrary == null) {
            return;
        }
        HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"\u6dfb\u52a0Android\u8bbe\u5907\u76d1\u542c......");
        deviceLibrary.addNotificationHandler(new IAndroidDeviceListHandler(){

            @Override
            public void invoke(boolean b) {
                AndroidLauncher.this.listAndroidDevices();
            }
        });
        isAdded = true;
    }

    public boolean isRunning() {
        return this.listenDeviceThread != null && this.listenDeviceThread.getState() == 4;
    }

    @Override
    public void installApplication(Apps app) throws OperateException {
        boolean appExists = false;
        if (StringUtil.isBlank((String)app.getBasePath()) || !new File(app.getBasePath()).exists()) {
            if (DefaultMobileManager.isCustom()) {
                throw new OperateException("\u5b89\u88c5\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u5236\u4f5c\u81ea\u5b9a\u4e49\u57fa\u5ea7App");
            }
            throw new OperateException("\u5b89\u88c5HBuilder\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4ece\u5b98\u7f51\u4e0b\u8f7d\u65b0\u7684HBuilder");
        }
        if (this.checkVersion()) {
            this.println("\u6ce8\uff1a\u53ef\u80fd\u9700\u8981\u70b9\u4eae\u624b\u673a\u5c4f\u5e55\u5e76\u70b9\u51fb\u3010\u7ee7\u7eed\u5b89\u88c5\u3011\u6309\u94ae\u624d\u80fd\u5b89\u88c5\u6210\u529f\u3002\n\u53ef\u4ee5\u6253\u5f00\u624b\u673a\u4e0a\u7684\u201c\u5b89\u5168\u4e2d\u5fc3\u201d\u5e94\u7528\uff0c\u70b9\u51fb\uff1a\u6388\u6743\u7ba1\u7406-\u53f3\u4e0a\u89d2\u8bbe\u7f6e\u56fe\u6807-USB\u5b89\u88c5\u7ba1\u7406\uff0c\u5173\u95ed\u540e\u5c31\u4e0d\u518d\u63d0\u9192\u4e86", new OperateException(""));
        }
        int i = 0;
        while (i < 3) {
            if (i == 1) {
                this.println("\u6ce8\uff1a\u6709\u4e9b\u624b\u673a\u9700\u8981\u70b9\u4eae\u624b\u673a\u5c4f\u5e55\u5e76\u70b9\u51fb\u3010\u5b89\u88c5\u3011\u6309\u94ae\u624d\u80fd\u5b89\u88c5\u6210\u529f", null);
            }
            this.installApp(app);
            appExists = this.checkAppExists(app);
            if (appExists) break;
            if (i == 2) {
                if (DefaultMobileManager.isCustom()) {
                    throw new OperateException("\u5b89\u88c5\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
                }
                throw new OperateException("\u5b89\u88c5HBuilder\u57fa\u5ea7App\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
            }
            ++i;
        }
        this.worked(10);
    }

    public boolean checkVersion() {
        block10: {
            int v;
            String str;
            String[] versions;
            block12: {
                block11: {
                    String version;
                    block9: {
                        block8: {
                            if (!StringUtil.isBlank((String)this.targetMobile.getBrand()) && "xiaomi".equals(this.targetMobile.getBrand().toLowerCase())) break block8;
                            return false;
                        }
                        version = this.targetMobile.getVersion();
                        if (!StringUtil.isBlank((String)version)) break block9;
                        return false;
                    }
                    versions = version.split("\\.");
                    if (versions.length <= 0) break block10;
                    Matcher matcher = Pattern.compile("(\\d+)\\.").matcher(version);
                    str = versions[0];
                    if (matcher.find()) {
                        str = matcher.group(1);
                    }
                    if ((v = Integer.valueOf(str).intValue()) <= 6) break block11;
                    return true;
                }
                if (v != 6 || versions.length <= 1) break block10;
                str = versions[1];
                v = Integer.valueOf(str);
                if (v <= 5) break block12;
                return true;
            }
            try {
                if (v == 5 && versions.length > 2 && (v = Integer.valueOf(str = versions[2]).intValue()) >= 5) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean checkAppExists(Apps app) throws OperateException {
        boolean appExists;
        block7: {
            appExists = false;
            String adbPath = AndroidPlugin.ADB_PATH;
            File file = new File(adbPath);
            if (file.exists()) {
                this.pb.command(file.getAbsolutePath(), "-s", this.targetMobile.getName(), "shell", "pm", "list", "packages");
                this.pb.redirectErrorStream(true);
                BufferedReader reader = null;
                Process process = null;
                InputStream is = null;
                try {
                    try {
                        process = this.pb.start();
                        is = process.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)line);
                            if (!line.endsWith(app.getId())) continue;
                            appExists = true;
                            break;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                        this.close(reader, process, is);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(reader, process, is);
                    throw throwable;
                }
                this.close(reader, process, is);
            }
        }
        return appExists;
    }

    private void installApp(final Apps app) throws OperateException {
        if (this.isNeedSetInstallLoation()) {
            this.reInstallApplication(app);
        } else {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws OperateException {
                    if (line.toLowerCase().indexOf("failed") > -1) {
                        AndroidLauncher.this.reInstallApplication(app);
                    } else {
                        if (line.toLowerCase().indexOf("failure") > -1) {
                            if (line.toLowerCase().indexOf("install_canceled_by_user") > -1) {
                                throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u624b\u52a8\u70b9\u4eae\u624b\u673a\u5c4f\u5e55\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\uff0c\u6ce8\uff1a\u53ef\u80fd\u9700\u8981\u5728\u624b\u673a\u4e0a\u786e\u8ba4\u5b89\u88c5\u3002");
                            }
                            throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
                        }
                        AndroidLauncher.this.println(line, null);
                    }
                    return false;
                }
            }, "-s", this.targetMobile.getName(), "install", "-r", app.getBasePath());
        }
    }

    protected void reInstallApplication(final Apps app) throws OperateException {
        String sdcardAPKDir = String.valueOf(this.getSdcardDir()) + "/";
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException, OperateException {
                if (line.toLowerCase().indexOf("failed") > -1 || line.toLowerCase().indexOf("failure") > -1) {
                    throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
                }
                AndroidLauncher.this.println(line, null);
                return false;
            }
        }, "-s", this.targetMobile.getName(), "push", app.getBasePath(), sdcardAPKDir);
        final String[] options = new String[]{"0"};
        if (this.isNeedSetInstallLoation()) {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) {
                    if (StringUtil.isNotBlank((String)(line = line.trim())) && (line.equals("0") || line.equals("1") || line.equals("2"))) {
                        options[0] = line;
                    }
                    return false;
                }
            }, "-s", this.targetMobile.getName(), "shell", "pm", "get-install-location");
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) {
                    return false;
                }
            }, "-s", this.targetMobile.getName(), "shell", "pm", "set-install-location", "1");
        }
        File apkFile = new File(app.getBasePath());
        final String sdcardAPKPath = String.valueOf(sdcardAPKDir) + apkFile.getName();
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                if (line.toLowerCase().indexOf("failed") > -1) {
                    throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
                }
                if (line.toLowerCase().indexOf("failure") > -1) {
                    if (line.toLowerCase().indexOf("install_canceled_by_user") > -1) {
                        throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u624b\u52a8\u70b9\u4eae\u624b\u673a\u5c4f\u5e55\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5");
                    }
                    throw new OperateException("\u5b89\u88c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line + "\u3002\n\u8bf7\u4f7f\u7528\u624b\u673a\u52a9\u624b\u624b\u52a8\u5b89\u88c5" + app.getBasePath() + "\u5230\u624b\u673a\u4e0a\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002");
                }
                AndroidLauncher.this.println(line, null);
                if ("Success".equals(line)) {
                    AndroidLauncher.this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) {
                            return false;
                        }
                    }, new String[]{"-s", AndroidLauncher.this.targetMobile.getName(), "shell", "rm", "-r", sdcardAPKPath});
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "pm", "install", "-r", sdcardAPKPath);
        if (this.isNeedSetInstallLoation()) {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) {
                    return false;
                }
            }, "-s", this.targetMobile.getName(), "shell", "pm", "set-install-location", options[0]);
        }
    }

    public String getSdcardDir() {
        return this.targetMobile.getSdcardDir();
    }

    private boolean uninstallApplication(Apps app) throws OperateException {
        this.deletePackage(app);
        if (DefaultMobileManager.isCustom()) {
            this.println("\u68c0\u6d4b\u5230\u81ea\u5b9a\u4e49\u57fa\u5ea7\u6709\u66f4\u65b0,\u6b63\u5728\u5220\u9664\u65e7\u7248\u672c...", null);
        } else {
            this.println("\u68c0\u6d4b\u5230HBuilder\u8c03\u8bd5\u57fa\u5ea7\u6709\u66f4\u65b0,\u6b63\u5728\u5220\u9664\u65e7\u7248\u672c...", null);
        }
        return this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) {
                if ("Success".equals(line)) {
                    if (DefaultMobileManager.isCustom()) {
                        AndroidLauncher.this.println("\u5220\u9664\u65e7\u7248\u81ea\u5b9a\u4e49\u57fa\u5ea7\u57fa\u5ea7\u6210\u529f", null);
                    } else {
                        AndroidLauncher.this.println("\u5220\u9664\u65e7\u7248HBuilder\u8c03\u8bd5\u57fa\u5ea7\u6210\u529f", null);
                    }
                    return true;
                }
                if (DefaultMobileManager.isCustom()) {
                    AndroidLauncher.this.println("\u5220\u9664\u65e7\u7248\u81ea\u5b9a\u4e49\u57fa\u5ea7\u5931\u8d25", null);
                } else {
                    AndroidLauncher.this.println("\u5220\u9664\u65e7\u7248HBuilder\u8c03\u8bd5\u57fa\u5ea7\u5931\u8d25", null);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "uninstall", app.getId());
    }

    @Override
    public void deletePackage(Apps app) throws OperateException {
        this.setTaskName(com.pandora.launcher.core.android.Messages.AndroidLauncher_Delecting_Resource);
        String wwwroot = this.getWWWROOTDir(app);
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) {
                if (line.indexOf("failed") > -1) {
                    AndroidLauncher.this.println(line, new OperateException(line, true));
                } else {
                    AndroidLauncher.this.println(line, null);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "rm", "-r", wwwroot);
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) {
                if (line.indexOf("failed") > -1) {
                    if (!line.endsWith(", File exists")) {
                        AndroidLauncher.this.println(line, new OperateException(line, true));
                    }
                } else {
                    AndroidLauncher.this.println(line, null);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "mkdir", wwwroot);
    }

    @Override
    public void pushPackage(Apps app) throws OperateException {
        this.setTaskName(com.pandora.launcher.core.android.Messages.AndroidLauncher_Synchronizing_Resource);
        final String wwwroot = this.getWWWROOTDir(app);
        IProject project = app.getProject();
        final PrimitiveValue<String> prefixPath = new PrimitiveValue<String>("");
        if (app.getResourcePath() != null && app.getResourcePath().exists()) {
            prefixPath.setValue(app.getResourcePath().getAbsolutePath());
        } else {
            prefixPath.setValue(project.getLocation().toOSString());
        }
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException, OperateException {
                if (line.startsWith("failed")) {
                    String rLine = line.replace(wwwroot, "");
                    rLine = rLine.replace((CharSequence)prefixPath.getValue(), "");
                    if (pattern.matcher(rLine).find()) {
                        AndroidLauncher.this.println(line, new OperateException(""));
                        throw new OperateException("\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u540d\u662f\u5426\u5408\u6cd5");
                    }
                    if (!HMobileDeviceLauncher.isSpecFile(line)) {
                        if (line.endsWith("No such file or directory")) {
                            AndroidLauncher.this.println("\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line, new OperateException(""));
                            throw new OperateException("\u8bbf\u95eesdcard\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u624b\u673asdcard\u76ee\u5f55\u53ef\u4f7f\u7528\uff1b\u82e5\u4f7f\u7528\u624b\u673a\u6a21\u62df\u5668\uff0c\u8bf7\u4e3a\u6a21\u62df\u5668\u5206\u914dsdcard");
                        }
                        throw new OperateException("\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + line);
                    }
                }
                if (AndroidLauncher.this.isExited()) {
                    throw new BreakException();
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "push", String.valueOf(prefixPath.getValue()) + "/.", wwwroot);
    }

    private boolean isExited() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.monitor.done();
            return true;
        }
        return false;
    }

    private void setTaskName(String string) {
        if (this.monitor != null) {
            this.monitor.setTaskName(string);
        }
    }

    @Override
    public void pushResource(Apps app, String resourcePath, String resourceRefPath, String targetPath) throws OperateException {
        String wwwroot = this.getWWWROOTDir(app);
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)wwwroot);
        final String fileTPath = targetPath;
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException, OperateException {
                if (line.contains("out of date")) {
                    return false;
                }
                if (line.startsWith("failed")) {
                    if (!HMobileDeviceLauncher.isSpecFile(line)) {
                        AndroidLauncher.this.println(line, new OperateException(""));
                    }
                    if (pattern.matcher(fileTPath).find()) {
                        throw new OperateException("\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u540d\u662f\u5426\u5408\u6cd5\u3002");
                    }
                } else {
                    AndroidLauncher.this.println(line, null);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "push", resourcePath, String.valueOf(wwwroot) + targetPath);
        this.sendFlushCommand(app, resourceRefPath, targetPath);
    }

    @Override
    public void sendRestartCmd(Apps app) throws OperateException {
        IProject project = app.getProject();
        try {
            if (project != null && project.hasNature("com.pandora.projects.ui.Wap2AppNature")) {
                this.sendFlushCommand("snc:script restart", true, app);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendFlushCommand(String command, boolean needReConnect, Apps app) throws OperateException {
        block48: {
            InputStream input;
            OutputStream commandExecutor;
            Socket socket;
            block44: {
                boolean[] isSetted;
                block47: {
                    String oldDir;
                    block46: {
                        String line;
                        block45: {
                            if (StringUtil.isEmpty((String)command)) {
                                return;
                            }
                            socket = null;
                            commandExecutor = null;
                            input = null;
                            socket = new Socket("127.0.0.1", this.forwardPort);
                            commandExecutor = socket.getOutputStream();
                            commandExecutor.write(command.getBytes());
                            commandExecutor.flush();
                            if (!command.contains(ROOT_PATH_COMMAND)) break block44;
                            input = socket.getInputStream();
                            line = IOUtils.toString((InputStream)input);
                            input.close();
                            if (!StringUtil.isBlank((String)line)) break block45;
                            try {
                                this.close(null, null, input);
                                if (socket != null) {
                                    socket.close();
                                }
                                if (commandExecutor != null) {
                                    commandExecutor.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                        oldDir = this.getSdcardDir();
                        if (!line.endsWith("/0") && !line.equals(oldDir) && !line.equals(String.valueOf(oldDir) + "/")) break block46;
                        try {
                            this.close(null, null, input);
                            if (socket != null) {
                                socket.close();
                            }
                            if (commandExecutor != null) {
                                commandExecutor.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    isSetted = new boolean[1];
                    this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws OperateException {
                            if (StringUtil.isNotBlank((String)line) && line.startsWith("/")) {
                                AndroidLauncher.this.println("\u83b7\u53d6\u5916\u7f6esdcard\u76ee\u5f55\u4e3a\uff1a" + line, null);
                                AndroidLauncher.this.targetMobile.setSdcardDir(line);
                                isSetted[0] = true;
                            }
                            return false;
                        }
                    }, "-s", this.targetMobile.getName(), "shell", "echo", ENV_SECONDARY_STORAGE);
                    boolean isSuccessed = false;
                    if (isSetted[0]) {
                        this.println("\u68c0\u6d4b\u5230sdcard\u76ee\u5f55\u4e3a\uff1a" + this.getSdcardDir(), null);
                        this.println("\u9ed8\u8ba4sdcard\u76ee\u5f55\u4e3a\uff1a" + oldDir, null);
                        if (DefaultMobileManager.isCustom()) {
                            this.println("\u68c0\u6d4b\u5230\u624b\u673a\u4e0a\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u4f7f\u7528\u7684\u8d44\u6e90\u76ee\u5f55\u4e0e\u540c\u6b65\u76ee\u5f55\u4e0d\u4e00\u81f4\uff0c\u5c06\u91cd\u65b0\u540c\u6b65\u8d44\u6e90\u5e76\u91cd\u542f", new OperateException(""));
                        } else {
                            this.println("\u68c0\u6d4b\u5230\u624b\u673a\u4e0aHBuilder\u57fa\u5ea7App\u4f7f\u7528\u7684\u8d44\u6e90\u76ee\u5f55\u4e0e\u540c\u6b65\u76ee\u5f55\u4e0d\u4e00\u81f4\uff0c\u5c06\u91cd\u65b0\u540c\u6b65\u8d44\u6e90\u5e76\u91cd\u542f", new OperateException(""));
                        }
                        try {
                            this.println("\u91cd\u65b0\u540c\u6b65\u66ff\u6362\u8d44\u6e90...", null);
                            this.pushPackage(app);
                            isSuccessed = true;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if (!isSuccessed) break block47;
                    this.stopApplication(app);
                    this.startHBuilderApp(app, false);
                    try {
                        this.close(null, null, input);
                        if (socket != null) {
                            socket.close();
                        }
                        if (commandExecutor != null) {
                            commandExecutor.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    if (isSetted[0]) {
                        this.executeADBCommand(new IConsoleLineReader(){

                            @Override
                            public boolean readLine(String line) throws OperateException {
                                if (StringUtil.isNotBlank((String)line) && line.startsWith("/")) {
                                    AndroidLauncher.this.targetMobile.setSdcardDir(line);
                                }
                                return false;
                            }
                        }, "-s", this.targetMobile.getName(), "shell", "echo", EXTERNAL_STORAGE);
                    }
                }
                catch (UnknownHostException e) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"Socket connection problem (Unknown host)", (Throwable)e);
                    try {
                        this.close(null, null, input);
                        if (socket != null) {
                            socket.close();
                        }
                        if (commandExecutor != null) {
                            commandExecutor.close();
                        }
                        break block48;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block48;
                }
                catch (Throwable throwable) {
                    try {
                        if (needReConnect) {
                            this.forwardToMobile();
                            needReConnect = false;
                            this.sendFlushCommand(command, needReConnect, app);
                        }
                        break block48;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        try {
                            this.close(null, null, input);
                            if (socket != null) {
                                socket.close();
                            }
                            if (commandExecutor != null) {
                                commandExecutor.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            try {
                this.close(null, null, input);
                if (socket != null) {
                    socket.close();
                }
                if (commandExecutor != null) {
                    commandExecutor.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startApplication(Apps app) throws OperateException {
        if (DefaultMobileManager.isCustom()) {
            this.setTaskName("\u6b63\u5728\u542f\u52a8\u81ea\u5b9a\u4e49\u57fa\u5ea7...");
        } else {
            this.setTaskName(Messages.HMobileDeviceLauncher_Starting_App);
        }
        boolean isStarted = this.startHBuilderApp(app, true);
        if (isStarted) {
            HMobileDeviceLauncher.openPerspective();
        }
    }

    @Override
    public Map<String, List<RemoteDebugObject>> getRemoteDebugUrls(final Mobile mobile) throws OperateException {
        Set<String> pids;
        this.targetMobile = mobile;
        HashMap<String, List<RemoteDebugObject>> remoteDebugObjectMap = new HashMap<String, List<RemoteDebugObject>>();
        mobile.clearPid();
        final boolean[] added = new boolean[1];
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws OperateException {
                String wdr = "webview_devtools_remote_";
                if (StringUtil.isNotBlank((String)line) && line.contains(wdr)) {
                    int index = line.indexOf(wdr);
                    mobile.addPid(line.substring(index));
                    added[0] = true;
                }
                return false;
            }
        }, "-s", mobile.getName(), "shell", "grep", "-a", "webview_devtools_remote", "/proc/net/unix");
        if (!added[0]) {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws OperateException {
                    String wdr = "webview_devtools_remote_";
                    if (StringUtil.isNotBlank((String)line) && line.contains(wdr)) {
                        int index = line.indexOf(wdr);
                        mobile.addPid(line.substring(index));
                        added[0] = true;
                    }
                    return false;
                }
            }, "-s", mobile.getName(), "shell", "cat", "/proc/net/unix", "|", "grep", "webview_devtools_remote");
        }
        if ((pids = mobile.getPids()).size() < 1) {
            return remoteDebugObjectMap;
        }
        int port = IOUtil.findFreePort((int)9888);
        for (String pid : pids) {
            block17: {
                this.appName = null;
                if (StringUtil.isNotBlank((String)pid)) {
                    this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws OperateException {
                            return false;
                        }
                    }, "-s", mobile.getName(), "forward", "tcp:" + port, "localabstract:" + pid);
                    DefaultHttpClient httpclient = HttpClientUtils.createHttpClient();
                    try {
                        try {
                            BasicResponseHandler responseHandler = new BasicResponseHandler();
                            String httpResponse = (String)httpclient.execute((HttpUriRequest)new HttpGet("http://localhost:" + port + "/json"), (ResponseHandler)responseHandler);
                            JSONArtifact jsonArtifact = JSON.parse((String)httpResponse);
                            ArrayList<RemoteDebugObject> urls = new ArrayList<RemoteDebugObject>();
                            if (jsonArtifact instanceof JSONArray) {
                                JSONArray jsonArray = (JSONArray)jsonArtifact;
                                int i = 0;
                                while (i < jsonArray.size()) {
                                    try {
                                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                                        urls.add(this.transferRemoteDebugObject(mobile, jsonObject, pid));
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    ++i;
                                }
                            } else if (jsonArtifact instanceof JSONObject) {
                                try {
                                    JSONObject jsonObject = (JSONObject)jsonArtifact;
                                    urls.add(this.transferRemoteDebugObject(mobile, jsonObject, pid));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            remoteDebugObjectMap.put(pid, urls);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            httpclient.getConnectionManager().shutdown();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        httpclient.getConnectionManager().shutdown();
                        throw throwable;
                    }
                    httpclient.getConnectionManager().shutdown();
                }
            }
            port = IOUtil.findFreePort((int)(port + 1));
        }
        return remoteDebugObjectMap;
    }

    private RemoteDebugObject transferRemoteDebugObject(Mobile mobile, JSONObject jsonObject, String pid) throws JSONException, OperateException, JsonSyntaxException, FileNotFoundException, IOException {
        String url;
        String devtoolsFrontendUrl;
        RemoteDebugObject remoteDebugObject = new RemoteDebugObject();
        String key = "devtoolsFrontendUrl";
        if (jsonObject.containsKey((Object)key) && StringUtil.isNotBlank((String)(devtoolsFrontendUrl = jsonObject.getString(key)))) {
            remoteDebugObject.setDevtoolsFrontendUrl(devtoolsFrontendUrl);
            int index = devtoolsFrontendUrl.indexOf("?");
            if (index > 0) {
                String uri = devtoolsFrontendUrl.substring(index);
                uri = "chrome-devtools://devtools/bundled/inspector.html" + uri;
                remoteDebugObject.setUri(uri);
            }
        }
        if (jsonObject.containsKey((Object)(key = "url")) && StringUtil.isNotBlank((String)(url = jsonObject.getString(key)))) {
            remoteDebugObject.setRemoteFilePath(url);
            String p = "www";
            int index = url.indexOf(p);
            if (url.indexOf("/io.dcloud.HBuilder/") > 0 && index > 1) {
                String filePath = url.substring(index + p.length() + 1);
                remoteDebugObject.setFilePath(filePath);
                if (StringUtil.isBlank((String)this.appName)) {
                    String wwwPath = url.substring(0, index + p.length() + 1);
                    wwwPath = wwwPath.replace("file://", "");
                    String manifestPath = String.valueOf(wwwPath) + "manifest.json";
                    File tmpManifest = CoreActivator.getDefault().getBundle().getDataFile("manifest.json");
                    File parent = tmpManifest.getParentFile();
                    if (!parent.exists() || !parent.isDirectory()) {
                        parent.mkdirs();
                    }
                    this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws OperateException {
                            return false;
                        }
                    }, "-s", mobile.getName(), "pull", manifestPath, tmpManifest.getAbsolutePath());
                    if (tmpManifest.exists()) {
                        try {
                            JsonElement jsonElement = new JsonParser().parse(IOUtils.toString((InputStream)new FileInputStream(tmpManifest), (Charset)Charset.forName("UTF-8")));
                            JsonObject jsonObiect = jsonElement.getAsJsonObject();
                            this.appName = jsonObiect.get("name").getAsString();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (jsonObject.containsKey((Object)(key = "id"))) {
            remoteDebugObject.setId(jsonObject.getString(key));
        }
        if (jsonObject.containsKey((Object)(key = "title"))) {
            remoteDebugObject.setTitle(jsonObject.getString(key));
        }
        if (jsonObject.containsKey((Object)(key = "webSocketDebuggerUrl"))) {
            remoteDebugObject.setWebSocketDebuggerUrl(jsonObject.getString(key));
        }
        remoteDebugObject.setPid(pid);
        remoteDebugObject.setAppName(this.appName);
        return remoteDebugObject;
    }

    public boolean startHBuilderApp(Apps app, boolean needSend) throws OperateException {
        if (DefaultMobileManager.isCustom()) {
            this.println("\u6b63\u5728\u542f\u52a8\u81ea\u5b9a\u4e49\u57fa\u5ea7...", null);
        } else {
            this.println(Messages.HMobileDeviceLauncher_Starting_App, null);
        }
        int i = 0;
        boolean isStarted = false;
        while (i < 3) {
            ++i;
            this.startApp(app);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            isStarted = this.checkAppIsStarted(app);
            if (isStarted) break;
        }
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(LauncherCoreActivator.PLUGIN_ID);
        boolean isFirstRunIphoe = true;
        try {
            isFirstRunIphoe = prefs.getBoolean("first_launch_android", true);
        }
        catch (Exception exception) {}
        if (isFirstRunIphoe) {
            if (!DefaultMobileManager.isCustom()) {
                this.println("\u521d\u6b21\u4f7f\u7528\u6ce8\u610f\uff1a\n1\u3001\u8054\u673a\u8c03\u8bd5\u5e76\u975e\u6253\u5305\uff0c\u8c03\u8bd5\u57fa\u5ea7 HBuilder \u662f\u9ed8\u8ba4\u7684\u6d4b\u8bd5\u5305\uff0c\u6743\u9650\u3001\u56fe\u6807\u90fd\u4e0d\u53ef\u81ea\u5b9a\u4e49\u3002\u53ea\u6709\u5728\u70b9\u83dc\u5355\"\u53d1\u884c-\u53d1\u884c\u4e3a\u539f\u751f\u5b89\u88c5\u5305\"\u65f6\u624d\u80fd\u81ea\u5b9a\u4e49\u8fd9\u4e9b\u8bbe\u7f6e\n2\u3001\u66f4\u6539\u6587\u4ef6\u4fdd\u5b58\u540e\u4f1a\u81ea\u52a8\u540c\u6b65\u5230\u624b\u673a\u5e76\u5237\u65b0\u754c\u9762\n3\u3001Android\u624b\u673a\u53ef\u4f7f\u7528console.log()\u8c03\u8bd5", new OperateException(null));
            } else {
                this.println("\u521d\u6b21\u4f7f\u7528\u6ce8\u610f\uff1a\n1\u3001\u66f4\u6539\u6587\u4ef6\u4fdd\u5b58\u540e\u4f1a\u81ea\u52a8\u540c\u6b65\u5230\u624b\u673a\u5e76\u5237\u65b0\u754c\u9762\n2\u3001Android\u624b\u673a\u53ef\u4f7f\u7528console.log()\u8c03\u8bd5", new OperateException(null));
            }
            prefs.putBoolean("first_launch_android", false);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
            }
        }
        if (this.isNeedWarnCache()) {
            this.println("\u5f53\u524dApp\u771f\u673a\u8fd0\u884c\u72b6\u6001\u4e3a\u4e0d\u4f7f\u7528\u7f13\u5b58\u7684\u6a21\u5f0f\uff0c\u6b64\u6a21\u5f0f\u4e0b\u624b\u673a\u7aefApp\u8fd0\u884c\u6548\u7387\u53ef\u80fd\u4e0b\u964d\uff0c\u4f46\u53ef\u51c6\u786e\u83b7\u53d6\u9875\u9762\u5f15\u7528\u5173\u7cfb\u3002\n\u4e3a\u751f\u6210\u5168\u9762\u7684\u9875\u9762\u5f15\u7528\u5173\u7cfb\uff0c\u5219\u8bf7\u628aApp\u4e2d\u6bcf\u4e2a\u9875\u9762\u548c\u4e0d\u540c\u903b\u8f91\u7684\u72b6\u6001\u5747\u70b9\u51fb\u6d4b\u8bd5\u4e00\u904d\uff0cHBuilder\u4f1a\u81ea\u52a8\u751f\u6210\u9875\u9762\u5f15\u7528\u5173\u7cfb\u3002", new OperateException(null));
        }
        if (isStarted) {
            this.println("\u5e94\u7528" + app.getAppName() + "\u5df2\u542f\u52a8...", new OperateException(null));
            if (needSend) {
                this.sendFlushCommand(ROOT_PATH_COMMAND, true, app);
            }
        } else if (DefaultMobileManager.isCustom()) {
            this.println("\u542f\u52a8\u624b\u673a\u4e0a\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7App\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u542f\u52a8...", new OperateException(null));
        } else {
            this.println("\u542f\u52a8\u624b\u673a\u4e0a\u7684HBuilder\u8c03\u8bd5\u57fa\u5ea7App\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u542f\u52a8...", new OperateException(null));
        }
        return isStarted;
    }

    private void startApp(Apps app) throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                if (line.indexOf("error") > -1) {
                    throw new BreakException(line, true);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "am", "start", "-n", String.valueOf(app.getId()) + "/" + app.getPackageName());
    }

    public boolean checkAppIsStarted(final Apps app) throws OperateException {
        final boolean[] isStarts = new boolean[1];
        if (app == null) {
            return isStarts[0];
        }
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                if (line.endsWith(app.getId())) {
                    isStarts[0] = true;
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "ps");
        return isStarts[0];
    }

    @Override
    public void stopApplication(Apps app) throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "am", "force-stop", app.getId());
    }

    @Override
    public void getApplicationLog(Apps app) {
        this.isLogcating = true;
        final IProject project = app.getProject();
        this.logThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AndroidLauncher.this.executeADBCommand(new IConsoleLineReader(){

                        @Override
                        public boolean readLine(String line) throws BreakException {
                            if (AndroidLauncher.this.logThread.isInterrupted()) {
                                return false;
                            }
                            if (line.startsWith("--------")) {
                                return false;
                            }
                            int index = line.indexOf(":");
                            String lv = null;
                            if (index != -1) {
                                boolean isStreamJson;
                                String start = line.substring(0, index);
                                line = line.substring(index + 1, line.length());
                                boolean bl = isStreamJson = start.contains(".stream_json") || line.contains(".stream_json");
                                if (isStreamJson) {
                                    AndroidLauncher.this.processAppStreamJSonLine(project, line);
                                } else {
                                    String regStr = "\\[.*?\\]";
                                    Pattern pattern = Pattern.compile(regStr);
                                    Matcher matcher = pattern.matcher(line);
                                    while (matcher.find()) {
                                        lv = matcher.group(0);
                                        if (line.indexOf(lv) == -1) continue;
                                        line = line.substring(line.indexOf(lv) + lv.length());
                                        break;
                                    }
                                    line = HMobileDeviceLauncher.transSourceMapLog(line, sourceMap);
                                    if (lv != null && lv.equals("[ERROR]")) {
                                        line = line.replace(": plus is not defined", ": plus is not defined (\u63d0\u793a: \u8bf7\u5728plus ready\u540e\u518d\u8c03\u7528plus api)");
                                        AndroidLauncher.this.println(line, new OperateException(""));
                                    } else {
                                        IAutoTransfor at = HMobileDeviceLauncher.getAutoTransfor();
                                        if (at != null) {
                                            if (line.contains(at.getCompletedLog())) {
                                                at.completed();
                                            } else {
                                                AndroidLauncher.this.println(line, null);
                                            }
                                        } else {
                                            AndroidLauncher.this.println(line, null);
                                        }
                                    }
                                }
                            } else {
                                AndroidLauncher.this.println(line, null);
                            }
                            return false;
                        }
                    }, new String[]{"-s", AndroidLauncher.this.targetMobile.getName(), "logcat", "-s", "console .stream_json"});
                }
                catch (OperateException e) {
                    e.printStackTrace();
                }
            }
        });
        this.logThread.start();
        this.streamAppJSonJob = new Job("Process StreamAppJSon"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    StreamJsonUtil.syncStreamJSon();
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    AndroidLauncher.this.streamAppJSonJob.schedule(10000L);
                }
                return Status.OK_STATUS;
            }
        };
        this.streamAppJSonJob.setSystem(true);
        this.streamAppJSonJob.schedule(10000L);
    }

    @Override
    public void clearApplicationLog(Apps app) throws OperateException {
        StreamJsonUtil.clearFiliationJsonMap();
        if (this.logThread != null) {
            this.logThread.interrupt();
        }
        if (this.streamAppJSonJob != null) {
            this.streamAppJSonJob.cancel();
        }
        if (!this.isLogcating) {
            return;
        }
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                AndroidLauncher.this.println(line, null);
                return false;
            }
        }, "-s", this.targetMobile.getName(), "logcat", "-c");
        try {
            ArrayList<String> pidCMDS = new ArrayList<String>();
            if (PlatformUtil.isWindows()) {
                pidCMDS.add("cmd");
                pidCMDS.add("/c");
                pidCMDS.add(AndroidPlugin.ADB_PATH);
                pidCMDS.add("-s");
                pidCMDS.add(this.targetMobile.getName());
                pidCMDS.add("shell");
                pidCMDS.add("ps");
                pidCMDS.add("|");
                pidCMDS.add("findstr");
                pidCMDS.add("logcat");
            } else {
                pidCMDS.add(AndroidPlugin.ADB_PATH);
                pidCMDS.add("-s");
                pidCMDS.add(this.targetMobile.getName());
                pidCMDS.add("shell");
                pidCMDS.add("ps");
                pidCMDS.add("|");
                pidCMDS.add("grep");
                pidCMDS.add("logcat");
            }
            ProcessBuilder pPB = new ProcessBuilder(pidCMDS);
            Process pidProcess = pPB.start();
            pidProcess.getOutputStream().flush();
            pidProcess.getOutputStream().close();
            Scanner pidIn = new Scanner(pidProcess.getInputStream());
            while (pidIn.hasNextLine()) {
                String line = pidIn.nextLine();
                if (StringUtil.isBlank((String)line)) continue;
                if (line.startsWith("shell")) {
                    line = line.replaceFirst("shell", "").trim();
                }
                String[] pids = line.split(" ");
                String pid = pids[0];
                this.killAdbByPid(pid);
            }
            pidIn.close();
            pidProcess.destroy();
            pPB.directory();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void killAdbByPid(String pid) throws OperateException {
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "kill", "-9", pid);
    }

    public void killADBProcess() {
        this.stopJobs();
        try {
            if (StringUtil.isBlank((String)this.installPath)) {
                this.installPath = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)org.eclipse.core.runtime.Platform.getInstallLocation().getURL()));
                this.installPath = this.installPath.toLowerCase();
            }
            if (PlatformUtil.isWindows()) {
                String pName = "adb.exe";
                Process process = Runtime.getRuntime().exec("wmic process where caption='" + pName + "' get executablePath,handle");
                process.getOutputStream().flush();
                process.getOutputStream().close();
                Scanner in = new Scanner(process.getInputStream(), "GBK");
                String line = null;
                while (in.hasNextLine()) {
                    line = in.nextLine();
                    if (StringUtil.isBlank((String)line) || !(line = line.toLowerCase()).contains(pName)) continue;
                    File adbFile = new File(String.valueOf(this.installPath) + "/tools/adbs/" + pName);
                    String adbFilePath = adbFile.getAbsolutePath();
                    if (line.startsWith(adbFilePath = adbFilePath.toLowerCase())) {
                        line = line.replace(adbFilePath, "");
                        line = line.trim();
                        Runtime.getRuntime().exec("Taskkill /pid " + line + " /F");
                        continue;
                    }
                    adbFile = new File(AndroidPlugin.ADB_PATH_31);
                    adbFilePath = adbFile.getAbsolutePath();
                    if (!line.startsWith(adbFilePath = adbFilePath.toLowerCase())) continue;
                    line = line.replace(adbFilePath, "");
                    line = line.trim();
                    Runtime.getRuntime().exec("Taskkill /pid " + line + " /F");
                }
                in.close();
                process.destroy();
            } else if (PlatformUtil.isMac()) {
                ArrayList<String> pidCMDS = new ArrayList<String>();
                pidCMDS.add("sh");
                pidCMDS.add("-c");
                pidCMDS.add("ps aux | grep adb | awk '{print $2}'");
                ProcessBuilder pidPB = new ProcessBuilder(pidCMDS);
                Process pidProcess = pidPB.start();
                pidProcess.getOutputStream().flush();
                pidProcess.getOutputStream().close();
                Scanner pidIn = new Scanner(pidProcess.getInputStream());
                while (pidIn.hasNextLine()) {
                    String pid = pidIn.nextLine();
                    if (StringUtil.isBlank((String)pid)) continue;
                    this.processPID(pid);
                }
                pidIn.close();
                pidProcess.destroy();
                pidPB.directory();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    public void processPID(String pid) throws Exception {
        ArrayList<String> pathCMDS = new ArrayList<String>();
        pathCMDS.add("sh");
        pathCMDS.add("-c");
        pathCMDS.add("lsof -p " + pid + " | awk '$4 == \"cwd\" { print $9 }'");
        ProcessBuilder pathPB = new ProcessBuilder(pathCMDS);
        Process pathProcess = pathPB.start();
        pathProcess.getOutputStream().flush();
        pathProcess.getOutputStream().close();
        Scanner pathIN = new Scanner(pathProcess.getInputStream());
        while (pathIN.hasNextLine()) {
            String line = pathIN.nextLine();
            if (StringUtil.isBlank((String)line) || !line.toLowerCase().contains("hbuilder.app") && !line.toLowerCase().contains("rcp.app")) continue;
            Runtime.getRuntime().exec("kill -9 " + pid);
        }
        pathIN.close();
        pathProcess.destroy();
        pathPB.directory();
    }

    public String getProcessID(final Apps app) throws OperateException {
        final PrimitiveValue<Object> processId = new PrimitiveValue<Object>(null);
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) throws BreakException {
                if (line.indexOf(app.getId()) > -1) {
                    String[] strArr = line.split(" ");
                    if (app.getId().equals(strArr[strArr.length - 1])) {
                        int index = 0;
                        String[] stringArray = strArr;
                        int n = strArr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            if (StringUtil.isNotEmpty((String)str)) {
                                if (index == 1) {
                                    processId.setValue(str);
                                }
                                ++index;
                            }
                            ++n2;
                        }
                    }
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "ps");
        return processId.getValue();
    }

    @Override
    public void addLauncherListener(IMobileListener listener) {
        this.launcherListener = listener;
    }

    @Override
    public List<Mobile> getMachineList() {
        final ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        try {
            this.checkAdb();
            final boolean[] needReRun = new boolean[1];
            String simUrl = "127.0.0.1:" + LauncherCoreActivator.ANDROID_SIM_PORT;
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws BreakException {
                    if (StringUtil.isNotBlank((String)line) && line.contains("out of date")) {
                        AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_31);
                        needReRun[0] = true;
                    }
                    return false;
                }
            }, "connect", simUrl);
            if (needReRun[0]) {
                this.executeADBCommand(new IConsoleLineReader(){

                    @Override
                    public boolean readLine(String line) throws BreakException {
                        return false;
                    }
                }, "connect", simUrl);
            }
            needReRun[0] = false;
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws BreakException {
                    if (StringUtil.isNotBlank((String)line)) {
                        if (line.contains("out of date")) {
                            AndroidPlugin.setAdbPath((String)AndroidPlugin.ADB_PATH_31);
                            needReRun[0] = true;
                        }
                        if (line.contains("List of devices attached")) {
                            return false;
                        }
                        AndroidLauncher.this.processMobileMessage(mobileList, line);
                    }
                    return false;
                }
            }, "devices");
            if (needReRun[0]) {
                this.executeADBCommand(new IConsoleLineReader(){

                    @Override
                    public boolean readLine(String line) throws BreakException {
                        if (StringUtil.isNotBlank((String)line)) {
                            if (line.contains("List of devices attached")) {
                                return false;
                            }
                            AndroidLauncher.this.processMobileMessage(mobileList, line);
                        }
                        return false;
                    }
                }, "devices");
            }
        }
        catch (OperateException e1) {
            e1.printStackTrace();
        }
        return mobileList;
    }

    private String getIcon() {
        return "/icons/android.png";
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public Apps getTestApp(IProject project) {
        if (DefaultMobileManager.isCustom()) {
            File packageFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)project, (String)("unpackage" + File.separator + "debug" + File.separator + "android_debug.apk"));
            try {
                String packageName = null;
                String appid = null;
                String version = null;
                ZipFile zipfile = new ZipFile(packageFile);
                String androidManifestFileName = "AndroidManifest.xml";
                File file = this.getFileByEntryName(androidManifestFileName, zipfile);
                packageName = this.getPackageName(file);
                ZipEntry entry = this.getManifestZipEntry(zipfile);
                if (entry == null) {
                    throw new OperateException("\u65e0\u6cd5\u8bc6\u522b\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7\u5305\uff0c\u53ef\u4ece\u83dc\u5355\uff1a\u8fd0\u884c-\u771f\u673a\u8fd0\u884c-\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u8c03\u8bd5\u57fa\u5ea7 \u8fdb\u884c\u5236\u4f5c", true, true);
                }
                InputStream input = zipfile.getInputStream(entry);
                String content = IOUtil.read((InputStream)input);
                JsonElement jsonElement = new JsonParser().parse(content);
                JsonObject jsonObiect = jsonElement.getAsJsonObject();
                appid = jsonObiect.get("id").getAsString();
                version = jsonObiect.get("version").getAsJsonObject().get("name").getAsString();
                return new Apps(packageName, "io.dcloud.PandoraEntry", appid, project, packageFile.getAbsolutePath(), version);
            }
            catch (Exception e) {
                this.println("\u65e0\u6cd5\u8bc6\u522b\u7684\u81ea\u5b9a\u4e49\u57fa\u5ea7\u5305\uff0c\u53ef\u4ece\u83dc\u5355\uff1a\u8fd0\u884c-\u771f\u673a\u8fd0\u884c-\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u8c03\u8bd5\u57fa\u5ea7 \u8fdb\u884c\u5236\u4f5c", new OperateException(null));
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                return null;
            }
        }
        return new Apps("io.dcloud.HBuilder", "io.dcloud.PandoraEntry", "HBuilder", project, AndroidPlugin.ANDROID_BASE, AndroidPlugin.ANDROID_BASE_VERSION);
    }

    public ZipEntry getManifestZipEntry(ZipFile zipfile) {
        String manifestFileName = "/www/manifest.json";
        Enumeration<? extends ZipEntry> en = zipfile.entries();
        ZipEntry entry = null;
        while (en.hasMoreElements()) {
            entry = en.nextElement();
            if (entry == null || !entry.getName().endsWith(manifestFileName)) continue;
            return entry;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getPackageName(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getFileByEntryName(String androidManifestFileName, ZipFile zipfile) throws IOException, FileNotFoundException {
        ZipEntry entry = zipfile.getEntry(androidManifestFileName);
        InputStream input = zipfile.getInputStream(entry);
        File file = AndroidPlugin.getDefault().getBundle().getDataFile(androidManifestFileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        int length = -1;
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer)) != -1) {
            bos.write(buffer, 0, length);
        }
        bos.close();
        input.close();
        return file;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }

    @Override
    public void deleteResource(Apps app, String resourceRefPath, String targetPath) throws OperateException {
        String wwwroot = this.getWWWROOTDir(app);
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        this.executeADBCommand(new IConsoleLineReader(){

            @Override
            public boolean readLine(String line) {
                if (line.indexOf("failed") > -1) {
                    AndroidLauncher.this.println(line, new OperateException(line, true));
                } else {
                    AndroidLauncher.this.println(line, null);
                }
                return false;
            }
        }, "-s", this.targetMobile.getName(), "shell", "rm", "-r", String.valueOf(wwwroot) + targetPath);
        this.sendFlushCommand(app, resourceRefPath, targetPath);
    }

    public void sendFlushCommand(Apps app, String resourcePath, String targetPath) throws OperateException {
        Set<String> refrences = HMobileDeviceLauncher.getFileReference(app.getProject(), resourcePath);
        if (refrences != null && !refrences.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String refrence : refrences) {
                sb.append(refrence);
                sb.append("|");
            }
            if (StringUtil.isNotBlank((String)sb.toString())) {
                targetPath = sb.toString();
                if (targetPath.endsWith("|")) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                if (targetPath.startsWith("|")) {
                    targetPath = targetPath.substring(1);
                }
            }
        }
        this.sendFlushCommand(MessageFormat.format(UPDATE_SINGLE_FILE_PATTERN, targetPath), true, app);
    }

    public String getWWWROOTDir(Apps app) {
        return String.valueOf(this.getSdcardDir()) + "/Android/data/" + app.getId() + "/apps/" + app.getAppid() + "/www/";
    }

    public void setJobRunnable(IJobRunnable jobRunnable) {
        this.jobRunnable = jobRunnable;
    }

    public void processMobileMessage(List<Mobile> mobileList, String line) {
        String[] results;
        String mModel = "";
        String sNO = "";
        String[] values = RegularUtils.matchs((String)modelReg, (String)line);
        if (values != null && values.length > 0) {
            mModel = values[0].trim();
        }
        if ((results = line.split("\t")) != null && results.length > 1) {
            sNO = results[0];
        }
        if (StringUtil.isNotEmpty((String)sNO)) {
            Mobile mobile = new Mobile(sNO, this.getIcon());
            mobile.setPlatform(Platform.ANDROID);
            mobile.setUuid(sNO);
            mobileList.add(mobile);
            this.getMobileModelBySerialNum(sNO, mModel, mobile);
        }
    }

    private void getMobileModelBySerialNum(String serialNum, final String mModel, final Mobile mobile) {
        try {
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws BreakException {
                    if (StringUtil.isBlank((String)line)) {
                        return false;
                    }
                    if ((line = line.trim()).startsWith("ro.product.model")) {
                        String model = AndroidLauncher.this.getArrayValue(line);
                        mobile.setModel(StringUtil.isNotBlank((String)model) ? model : mModel);
                    }
                    if (line.startsWith("ro.build.version.incremental")) {
                        String version = AndroidLauncher.this.getArrayValue(line);
                        mobile.setVersion(version);
                    }
                    if (line.startsWith("ro.product.brand")) {
                        String brand = AndroidLauncher.this.getArrayValue(line);
                        mobile.setBrand(brand);
                    }
                    return false;
                }
            }, "-s", serialNum, "shell", "\"cat /system/build.prop | grep -E 'product|ro.build.version.release|ro.build.version.incremental'\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getArrayValue(String line) {
        String[] ss = line.split("=");
        if (ss.length != 2) {
            return null;
        }
        return ss[1];
    }

    public void processAppStreamJSonLine(IProject project, String line) {
        try {
            int index = -1;
            String prefix = ".stream_json";
            index = line.indexOf(prefix);
            if (index > -1 && (index = (line = line.substring(index + prefix.length())).indexOf(":")) != -1) {
                line = line.substring(index + 1, line.length());
            }
            Gson gs = new Gson();
            Map jsonMap = (Map)gs.fromJson(line, Map.class);
            Map obj = (Map)jsonMap.get("resource");
            String htmlFile = "";
            String resource = "";
            boolean isRefer = false;
            if (obj != null) {
                Set s = obj.entrySet();
                for (Map.Entry object : s) {
                    if (!(object instanceof Map.Entry)) continue;
                    htmlFile = object.getKey().toString();
                    resource = object.getValue().toString();
                }
            }
            if ((obj = (Map)jsonMap.get("open")) != null) {
                htmlFile = obj.get("opener").toString();
                resource = obj.get("opened").toString();
                isRefer = true;
            }
            boolean isFiliation = false;
            obj = (Map)jsonMap.get("filiation");
            if (obj != null) {
                htmlFile = obj.get("parent").toString();
                resource = obj.get("child").toString();
                isFiliation = true;
            }
            if (StringUtil.isNotBlank((String)htmlFile) && StringUtil.isNotBlank((String)resource) && !htmlFile.equals(resource)) {
                if (isRefer) {
                    StreamJsonUtil.addReferStreamJsonList((IProject)project, (String)htmlFile, (String)resource);
                } else if (isFiliation) {
                    StreamJsonUtil.addFiliationStreamJsonList((IProject)project, (String)htmlFile, (String)resource);
                } else {
                    StreamJsonUtil.addResourceStreamJsonList((IProject)project, (String)htmlFile, (String)resource);
                }
                return;
            }
            Object typeObject = jsonMap.get("type");
            IAutoTransfor at = HMobileDeviceLauncher.getAutoTransfor();
            if (typeObject != null && at != null) {
                String appid;
                String version;
                String url;
                String type = typeObject.toString();
                if ("notify".equals(type)) {
                    String version2 = jsonMap.get("version").toString();
                    String appid2 = jsonMap.get("appid").toString();
                    at.notifyUpgrade(appid2, version2);
                }
                if ("download".equals(type)) {
                    url = jsonMap.get("url").toString();
                    String filePath = jsonMap.get("file").toString();
                    String version3 = jsonMap.get("version").toString();
                    String appid3 = jsonMap.get("appid").toString();
                    File file = this.pullUpdateFile(at, filePath, appid3);
                    at.notifyDownloadedInfo(appid3, file, url, version3);
                }
                if ("install".equals(type)) {
                    String filePath = jsonMap.get("file").toString();
                    version = jsonMap.get("version").toString();
                    appid = jsonMap.get("appid").toString();
                    File file = this.pullUpdateFile(at, filePath, appid);
                    at.notifyInstalledInfo(appid, file, version);
                }
                if ("openurl".equals(type)) {
                    url = jsonMap.get("url").toString();
                    version = jsonMap.get("version").toString();
                    appid = jsonMap.get("appid").toString();
                    at.notifyOpenUrlInfo(appid, url, version);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File pullUpdateFile(IAutoTransfor at, String filePath, String appid) throws OperateException {
        String path = at.getFileDir();
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        if (StringUtil.isNotBlank((String)filePath)) {
            int index = filePath.lastIndexOf(".");
            String extend = filePath.substring(index);
            file = new File(file, String.valueOf(appid) + extend);
            this.executeADBCommand(new IConsoleLineReader(){

                @Override
                public boolean readLine(String line) throws BreakException, OperateException {
                    return false;
                }
            }, "pull", filePath, file.getAbsolutePath());
            if (file == null || !file.exists()) {
                String sdcardDir = String.valueOf(this.getSdcardDir()) + "/";
                filePath = String.valueOf(sdcardDir) + filePath.substring(filePath.indexOf("Android"));
                this.executeADBCommand(new IConsoleLineReader(){

                    @Override
                    public boolean readLine(String line) throws BreakException, OperateException {
                        return false;
                    }
                }, "pull", filePath, file.getAbsolutePath());
            }
        } else {
            file = null;
        }
        return file;
    }

    public boolean isNeedWarnCache() {
        return this.isNeedWarnCache;
    }

    @Override
    public void setNeedWarnCache(boolean b) {
        this.isNeedWarnCache = b;
    }

    class BreakException
    extends Exception {
        private static final long serialVersionUID = -2226804927530088129L;
        private boolean stop;

        public BreakException() {
            this.stop = false;
        }

        public BreakException(String message, boolean isStop) {
            super(message);
            this.stop = false;
            this.stop = isStop;
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }
    }

    static interface IConsoleLineReader {
        public boolean readLine(String var1) throws BreakException, OperateException;
    }

    class PrimitiveValue<T> {
        private T value = null;

        public PrimitiveValue(T defaultValue) {
            this.value = defaultValue;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

