/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core;

import com.pandora.core.Platform;
import com.pandora.core.auth.ChangePWDListener;
import com.pandora.core.auth.IDEExitListener;
import com.pandora.core.auth.ProxyListener;
import com.pandora.core.auth.RecyleListener;
import com.pandora.core.auth.ThemeListener;
import com.pandora.core.launcher.ILauncherListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.IDEExitUtils;
import com.pandora.core.utils.LauncherUtils;
import com.pandora.core.utils.LoginUtils;
import com.pandora.core.utils.ProxyUtils;
import com.pandora.core.utils.RecycleUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.ThemeUtils;
import com.pandora.launcher.core.ADBExitListener;
import com.pandora.launcher.core.ChangePWD;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.ProxyLibrary;
import com.pandora.launcher.core.RecycleLibrary;
import com.pandora.launcher.core.ThemeLibrary;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.listener.DeviceStartupListener;
import com.pandora.tools.android.AndroidPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class LauncherCoreActivator
extends AbstractUIPlugin
implements ILauncherListener {
    public static String PLUGIN_ID = "com.pandora.launcher.core";
    private static BundleContext context;
    private static List<Mobile> simulatorList;
    private static List<Mobile> machineList;
    private static LauncherCoreActivator plugin;
    public static final boolean IPHONE_START_FIRST = true;
    public static final String IPHONE_LAUNCH_FIRST = "first_launch_iphone";
    public static final String ANDROID_LAUNCH_FIRST = "first_launch_android";
    public static final String IOS_SIM_LAUNCH_FIRST = "first_launch_ios_sim";
    public static String ANDROID_SIM_PORT;
    public static Thread chromeDebugThread;
    public static Process chromeDebugProcess;
    public static final String ANDROID_SIM_PORT_KEY = "ANDROID_SIM_PORT_KEY";
    public static final String AUTO_START_WEBVIEW_REMOTE_DEBUG_VIEW = "AUTO_START_WEBVIEW_REMOTE_DEBUG_VIEW";

    static {
        simulatorList = new ArrayList<Mobile>();
        machineList = new ArrayList<Mobile>();
        ANDROID_SIM_PORT = "26944";
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.getAndroidSimPort();
        LauncherUtils.setLauncherListener((ILauncherListener)this);
        LoginUtils.addChangePWDListener((ChangePWDListener)new ChangePWD());
        ThemeUtils.addChangePWDListener((ThemeListener)new ThemeLibrary());
        ProxyUtils.addProxyListener((ProxyListener)new ProxyLibrary());
        RecycleUtils.addRecyleListener((RecyleListener)new RecycleLibrary());
        IDEExitUtils.addIDEExitListener((IDEExitListener)new ADBExitListener());
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        LauncherCoreActivator.closeChrome();
        context = null;
        if (DeviceStartupListener.getAndroidLauncher() != null) {
            DeviceStartupListener.getAndroidLauncher().stopJobs();
            DeviceStartupListener.getAndroidLauncher().killADBServer(true);
        }
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)"\u542f\u52a8\u5668\u5173\u95ed\uff0c\u5173\u95edADB\u670d\u52a1");
    }

    public static void closeChrome() {
        if (chromeDebugProcess != null) {
            chromeDebugProcess.destroy();
            chromeDebugProcess = null;
        }
        if (chromeDebugThread != null) {
            chromeDebugThread.interrupt();
            chromeDebugThread = null;
        }
    }

    public static List<Mobile> getMachineList() {
        ArrayList<Mobile> result = new ArrayList<Mobile>();
        result.addAll(machineList);
        result.addAll(simulatorList);
        return result;
    }

    public static List<Mobile> getSimulatorList() {
        return simulatorList;
    }

    public static List<Mobile> getMobileList() {
        return machineList;
    }

    public static List<Mobile> getMachineList(Platform platform) {
        ArrayList<Mobile> result = new ArrayList<Mobile>();
        for (Mobile mobile : LauncherCoreActivator.getMachineList()) {
            if (!mobile.getPlatform().equals((Object)platform)) continue;
            result.add(mobile);
        }
        return result;
    }

    public static List<Mobile> getMachineList(Platform platform, DefaultMobileManager.MobileStatus status) {
        ArrayList<Mobile> result = new ArrayList<Mobile>();
        for (Mobile mobile : LauncherCoreActivator.getMachineList()) {
            if (!mobile.getPlatform().equals((Object)platform) || mobile.getStatus() != status) continue;
            result.add(mobile);
        }
        return result;
    }

    public static void addMobile(Mobile mobile) {
        if (mobile == null || LauncherCoreActivator.getMobileList().contains(mobile)) {
            return;
        }
        machineList.add(mobile);
    }

    public static void addSimulator(Mobile mobile) {
        if (mobile == null || mobile.getPlatform() != Platform.IOS_SIMULATOR || LauncherCoreActivator.getSimulatorList().contains(mobile)) {
            return;
        }
        simulatorList.add(mobile);
    }

    public static void removeMobile(String deviceId, Platform platform) {
        Mobile mobile = null;
        for (Mobile m : LauncherCoreActivator.getMachineList()) {
            if (m.getName().equals(deviceId) && m.getPlatform() == platform) {
                mobile = m;
                break;
            }
            if (!deviceId.equals(m.getUuid()) || m.getPlatform() != platform) continue;
            mobile = m;
            break;
        }
        if (mobile != null) {
            Mobile cm = DefaultMobileManager.getCurrentMobile();
            if (cm != null && cm.equals(mobile)) {
                DefaultMobileManager.setCurrentMobile(null);
            }
            simulatorList.remove(mobile);
            machineList.remove(mobile);
        }
    }

    public static LauncherCoreActivator getDefault() {
        return plugin;
    }

    public static void addSimulatorIntoMobile(Mobile mobile) {
        List<Mobile> list = LauncherCoreActivator.getMobileList();
        if (mobile == null || mobile.getPlatform() != Platform.IOS_SIMULATOR || list.contains(mobile)) {
            return;
        }
        Mobile deleteMobile = null;
        for (Mobile m : list) {
            if (m.getPlatform() != Platform.IOS_SIMULATOR) continue;
            deleteMobile = m;
            break;
        }
        if (deleteMobile != null) {
            machineList.remove(deleteMobile);
        }
        machineList.add(mobile);
    }

    public void setAndroidSimPort(int port) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PLUGIN_ID);
        prefs.put(ANDROID_SIM_PORT_KEY, String.valueOf(port));
        try {
            prefs.flush();
            if (!ANDROID_SIM_PORT.equals(String.valueOf(port))) {
                ANDROID_SIM_PORT = String.valueOf(port);
                DeviceStartupListener.startAndroidLauncher();
            }
        }
        catch (BackingStoreException e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    public int getAndroidSimPort() {
        String v = LauncherCoreActivator.getDefault().getPreferenceStore().getString(ANDROID_SIM_PORT_KEY);
        int port = 26944;
        if (StringUtil.isNotBlank((String)v)) {
            try {
                port = Integer.valueOf(v);
            }
            catch (Exception e) {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
                port = 26944;
            }
        }
        ANDROID_SIM_PORT = String.valueOf(port);
        return port;
    }

    public static boolean isAutoStartWebviewRemoteDebugView() {
        try {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PLUGIN_ID);
            return prefs.getBoolean(AUTO_START_WEBVIEW_REMOTE_DEBUG_VIEW, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static void setAutoStartWebviewRemoteDebugView(boolean isAuto) {
        try {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PLUGIN_ID);
            prefs.putBoolean(AUTO_START_WEBVIEW_REMOTE_DEBUG_VIEW, isAuto);
            prefs.flush();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void setCustomADBPath(String path) {
        AndroidPlugin.setCustomADBPath((String)path);
        if (!path.equals(AndroidPlugin.CUSTOM_ADB_PATH)) {
            DeviceStartupListener.startAndroidLauncher();
        }
    }

    public String getCustomADBPath() {
        return AndroidPlugin.getCustomADBPath();
    }
}

