/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core;

import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.SourceMapImpl;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.pandora.console.core.ConsoleActivator;
import com.pandora.console.core.ConsoleThreadStartup;
import com.pandora.console.core.IConsoleListener;
import com.pandora.console.core.MessageQueue;
import com.pandora.core.CoreActivator;
import com.pandora.core.Platform;
import com.pandora.core.exception.ConvertProjectException;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.project.IProjectProcessor;
import com.pandora.core.project.ProcessorResult;
import com.pandora.core.project.ProjectProcessors;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.HMobileUtils;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.IndexUtil;
import com.pandora.core.utils.PerspectiveUtils;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.URIUtils;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.IPrintlnable;
import com.pandora.launcher.core.IProgressMonitorAware;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.Messages;
import com.pandora.launcher.core.MobileEventAdapter;
import com.pandora.launcher.core.MobileSelectDialog;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.factory.LauncherFactory;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.listener.IAutoTransfor;
import com.pandora.projects.core.IResourceChangeListener;
import com.pandora.tools.android.AndroidPlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.ResourceManager;

public class HMobileDeviceLauncher
extends MobileEventAdapter
implements IResourceChangeListener,
IMobileListener,
IPrintlnable,
IConsoleListener {
    private static final String MANIFEST_JSON = "/manifest.json";
    public static final String DEBUG_MODE = "debug";
    public static final String RUN_MODE = "run";
    public static final String LAUNCHER_TYPE = "com.pandora.launcher.ui.hMobileApplication";
    public static final String PROCESS_TYPE = "com.pandora.launcher.ui.hMobileApplication";
    public static final String ATTR_PROJECT = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".ATTR_PROJECT";
    private Mobile targetMobile = null;
    private Apps targetApp = null;
    private ILauncher mobileLauncher = null;
    private boolean isRunning = false;
    private boolean isDebug = false;
    private static HashMap<String, Set<File>> unpackageFiles = new HashMap();
    private Map runEnv = null;
    private static IAutoTransfor autoTransfor;

    public static void launch(IProject project, String mode) {
        HMobileDeviceLauncher.launch(project, mode, null);
    }

    public static void launch(IProject project, String mode, IAutoTransfor at) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            Mobile mobile = DefaultMobileManager.getCurrentMobile();
            if (mobile != null) {
                Stats.addOperateInfo((String)"menu", (String)"ZJLT", (String)(mobile.getPlatform() == null ? "" : mobile.getPlatform().getName()));
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        try {
            HMobileDeviceLauncher.setAutoTransfor(at);
            ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("com.pandora.launcher.ui.hMobileApplication");
            ILaunchConfigurationWorkingCopy workingCopy = launchType.newInstance(null, "MobileDeviceLaucher_" + project.hashCode());
            workingCopy.setMappedResources(new IResource[]{project});
            ILaunchConfiguration launchConfiguration = workingCopy.doSave();
            DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)mode);
        }
        catch (CoreException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
    }

    public static void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        block7: {
            Mobile mobile = DefaultMobileManager.getCurrentMobile();
            if (mobile == null) {
                return;
            }
            try {
                try {
                    IResource[] resources = configuration.getWorkingCopy().getMappedResources();
                    IProject project = null;
                    project = resources != null && resources.length > 0 ? resources[0].getProject() : ProjectUtils.getCurrentProject();
                    if (project == null) break block7;
                    HMobileDeviceLauncher hMobileDeviceLauncher = new HMobileDeviceLauncher();
                    hMobileDeviceLauncher.setRunning(true);
                    hMobileDeviceLauncher.setRunEnv(configuration.getAttributes());
                    ConsoleActivator.getDefault().addConsoleListener((IConsoleListener)hMobileDeviceLauncher);
                    DefaultMobileManager.getInstance().running(project, mobile);
                    String title = "";
                    title = mobile.getPlatform() == Platform.IOS_SIMULATOR ? MessageFormat.format("{0} \u8fd0\u884c\u4e8e IOS Simulator [{1}]", project.getName(), StringUtil.isNotBlank((String)mobile.getModel()) ? mobile.getModel() : mobile.getName()) : MessageFormat.format("{0} \u8fd0\u884c\u4e8e {1}", project.getName(), StringUtil.isNotBlank((String)mobile.getModel()) ? mobile.getModel() : mobile.getName());
                    HMobileDeviceLauncher.startConsoleProcess(launch, project, hMobileDeviceLauncher, title);
                    Map attributes = configuration.getAttributes();
                    configuration.delete();
                    if (DEBUG_MODE.equals(mode)) {
                        hMobileDeviceLauncher.debugDevice(attributes, project, monitor);
                        break block7;
                    }
                    hMobileDeviceLauncher.runDevice(attributes, mobile, project, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    mobile.setCached(true);
                }
            }
            finally {
                mobile.setCached(true);
            }
        }
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    protected static void startConsoleProcess(ILaunch launch, IProject project, HMobileDeviceLauncher deviceLauncher, String title) {
        try {
            Runtime runtime = Runtime.getRuntime();
            String consoleTitle = title;
            String classPath = ConsoleActivator.MAIN_LAUNCHER_PATH;
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)classPath);
            ConsoleThreadStartup.hashcode = deviceLauncher.hashCode();
            String installDir = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)org.eclipse.core.runtime.Platform.getInstallLocation().getURL()));
            String javaPath = "";
            javaPath = PlatformUtil.isWindows() ? String.valueOf(installDir) + "/jre/bin/java.exe" : String.valueOf(new File(installDir).getParent()) + "/jre/Contents/Home/bin/java";
            File file = new File(javaPath);
            if (!file.exists()) {
                javaPath = "java";
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IProcess.ATTR_PROCESS_TYPE, "com.pandora.launcher.ui.hMobileApplication");
            ILaunchConfiguration configuration = launch.getLaunchConfiguration();
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.doSave();
            map.put(ATTR_PROJECT, project.getName());
            LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
            DebugPlugin.newProcess((ILaunch)launch, (Process)runtime.exec(new String[]{javaPath, "-Dfile.encoding=" + launchManager.getEncoding(configuration), "-Djava.net.preferIPv4Stack=true", "-cp", classPath, "com.pandora.console.core.ConsoleLauncher", "" + ConsoleThreadStartup.randomPort}), (String)consoleTitle, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addDebugScript(File resourcePath) {
    }

    protected void startNestedServer() {
    }

    public void debugDevice(Map attributes, IProject project, IProgressMonitor monitor) {
        this.isDebug = true;
        Mobile selectedMobile = HMobileDeviceLauncher.handleMobileList();
        if (selectedMobile == null) {
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.HMobileDeviceLauncher_Not_Selected_Phone);
            this.closeConsole();
            return;
        }
        this.targetMobile = selectedMobile;
        this.mobileLauncher = LauncherFactory.buildLauncher(selectedMobile.getPlatform());
        if (this.mobileLauncher instanceof IProgressMonitorAware) {
            IProgressMonitorAware monitorAware = (IProgressMonitorAware)((Object)this.mobileLauncher);
            monitorAware.setProgressMonitor(monitor);
        }
        this.mobileLauncher.addLauncherListener(this);
        DefaultMobileManager.getInstance().addMobileListener(this);
        this.targetApp = this.mobileLauncher.getTestApp(project);
        HMobileProject hMobileProject = null;
        try {
            hMobileProject = ProjectUtils.convertToHMobile((IProject)project);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
        if (hMobileProject == null) {
            this.closeConsole();
            return;
        }
        this.targetApp.setResourcePath(hMobileProject.getSourceRoot().makeAbsolute().toFile());
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(Messages.HMobileDeviceLauncher_Selected_Phone) + selectedMobile));
        try {
            monitor.beginTask(Messages.HMobileDeviceLauncher_Connection, 100);
            this.printlnToConsole(Messages.HMobileDeviceLauncher_Connection_1);
            if (this.isCanceled(monitor)) {
                return;
            }
            this.setupConnection(this.mobileLauncher, selectedMobile);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.worked(10);
            monitor.setTaskName(Messages.HMobileDeviceLauncher_Installing_App);
            this.printlnToConsole(Messages.HMobileDeviceLauncher_Installing_App);
            if (this.isCanceled(monitor)) {
                return;
            }
            this.addDebugScript(this.targetApp.getResourcePath());
            this.installApplication(this.mobileLauncher, selectedMobile, true);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.setTaskName(Messages.HMobileDeviceLauncher_Starting_App);
            this.printlnToConsole(Messages.HMobileDeviceLauncher_Starting_App);
            this.startNestedServer();
            this.restartApp(this.mobileLauncher);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.worked(15);
            HMobileUtils.getBuilder().addResourceChangeListener((Object)this);
            monitor.done();
        }
        catch (OperateException e) {
            this.printlnToConsole(e.getMessage(), e);
        }
    }

    public void runDevice(Map attributes, Mobile mobile, IProject project, IProgressMonitor monitor) {
        this.isDebug = false;
        Mobile selectedMobile = mobile;
        if (selectedMobile == null) {
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.HMobileDeviceLauncher_Not_Selected_Phone);
            this.closeConsole();
            return;
        }
        this.targetMobile = selectedMobile;
        this.mobileLauncher = LauncherFactory.buildLauncher(selectedMobile.getPlatform());
        if (this.mobileLauncher instanceof IProgressMonitorAware) {
            IProgressMonitorAware monitorAware = (IProgressMonitorAware)((Object)this.mobileLauncher);
            monitorAware.setProgressMonitor(monitor);
        }
        this.mobileLauncher.addLauncherListener(this);
        DefaultMobileManager.getInstance().addMobileListener(this);
        this.targetApp = this.mobileLauncher.getTestApp(project);
        if (this.targetApp == null) {
            return;
        }
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(Messages.HMobileDeviceLauncher_Selected_Phone) + selectedMobile));
        try {
            monitor.beginTask(Messages.HMobileDeviceLauncher_Connection, 100);
            if (selectedMobile.getPlatform() == Platform.IOS_SIMULATOR) {
                this.printlnToConsole("\u6b63\u5728\u542f\u52a8\u6a21\u62df\u5668...");
            } else {
                this.printlnToConsole(Messages.HMobileDeviceLauncher_Connection_1);
            }
            if (this.isCanceled(monitor)) {
                return;
            }
            this.setupConnection(this.mobileLauncher, selectedMobile);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.worked(10);
            if (DefaultMobileManager.isCustom()) {
                monitor.setTaskName("\u6b63\u5728\u5b89\u88c5\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u57fa\u5ea7...");
            } else {
                monitor.setTaskName(Messages.HMobileDeviceLauncher_Installing_App);
            }
            if (this.isCanceled(monitor)) {
                return;
            }
            this.installApplication(this.mobileLauncher, selectedMobile, false);
            if (this.isCanceled(monitor)) {
                return;
            }
            this.restartApp(this.mobileLauncher);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.worked(15);
            HMobileUtils.getBuilder().addResourceChangeListener((Object)this);
            monitor.done();
        }
        catch (OperateException e) {
            this.printlnToConsole(e.getMessage(), e);
            this.consoleStoped();
        }
        catch (Exception e) {
            this.printlnToConsole("\u8fd0\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), new OperateException(""));
            this.consoleStoped();
        }
    }

    protected boolean isCanceled(IProgressMonitor monitor) {
        if (!this.isRunning) {
            monitor.setCanceled(true);
        }
        if (monitor.isCanceled()) {
            monitor.done();
            return true;
        }
        return false;
    }

    private void restartApp(ILauncher launcher) throws OperateException {
        launcher.stopApplication(this.targetApp);
        launcher.startApplication(this.targetApp);
        launcher.getApplicationLog(this.targetApp);
    }

    private void setupConnection(ILauncher launcher, Mobile selectedMobile) throws OperateException {
        DefaultMobileManager.setCurrentMobile(selectedMobile);
        launcher.connect(selectedMobile);
    }

    private void installApplication(ILauncher launcher, Mobile selectedMobile, boolean isDebug) throws OperateException {
        IProject project = this.targetApp.getProject();
        HMobileProject hMobileProject = null;
        try {
            hMobileProject = ProjectUtils.convertToHMobile((IProject)project);
        }
        catch (ConvertProjectException e) {
            e.printStackTrace();
        }
        if (hMobileProject == null) {
            String errorMessage = "\u5f53\u524d\u8fd0\u884c\u7684\u9879\u76ee\u4e0d\u662f\u79fb\u52a8\u5e94\u7528\u9879\u76ee\uff0c\u65e0\u6cd5\u7ee7\u7eed\u8fd0\u884c\u3002";
            this.printlnToConsole(errorMessage, new OperateException(errorMessage, true));
            return;
        }
        this.targetApp.setResourcePath(hMobileProject.getSourceRoot().makeAbsolute().toFile());
        if (isDebug) {
            this.addDebugScript(this.targetApp.getResourcePath());
        }
        IFile configFile = project.getFile("manifest.json");
        File file = null;
        try {
            launcher.setNeedWarnCache(selectedMobile.isCached());
            file = this.getNewManifestJSonFile(configFile, launcher);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperateException("\u540c\u6b65manifest.json\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), true);
        }
        if (launcher.isAppExists(this.targetApp)) {
            this.printlnToConsole(Messages.HMobileDeviceLauncher_AppExist_Synchronizing_Resource);
            launcher.deletePackage(this.targetApp);
            this.targetApp.setResourcePath(HMobileDeviceLauncher.copyProjectFiles(hMobileProject, this.mobileLauncher));
            launcher.pushPackage(this.targetApp);
        } else {
            if (DefaultMobileManager.isCustom()) {
                this.printlnToConsole("\u6b63\u5728\u5b89\u88c5\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u57fa\u5ea7...");
            } else {
                this.printlnToConsole(Messages.HMobileDeviceLauncher_Installing_App);
            }
            launcher.installApplication(this.targetApp);
            this.printlnToConsole(Messages.HMobileDeviceLauncher_AppInstalled_Synchronizing_Resource);
            this.targetApp.setResourcePath(HMobileDeviceLauncher.copyProjectFiles(hMobileProject, this.mobileLauncher));
            launcher.pushPackage(this.targetApp);
        }
        if (file != null && file.exists()) {
            String releasePath = file.getAbsolutePath();
            launcher.pushResource(this.targetApp, releasePath, releasePath, MANIFEST_JSON);
        }
        if (HMobileDeviceLauncher.getAutoTransfor() != null) {
            this.getSpecFiles(project, configFile, launcher);
        }
    }

    private List<File> getSpecFiles(IProject project, IFile configFile, ILauncher launcher) throws OperateException {
        IFile launchFile = this.getNewLaunchFile(configFile, launcher);
        List<File> spFiles = HMobileDeviceLauncher.getAutoTransfor().getSpecFiles(project, launchFile, launcher, this.targetApp);
        return spFiles;
    }

    public IFile getNewLaunchFile(IFile configFile, ILauncher launcher) {
        try {
            Gson gs = new Gson();
            ManifastConfiguration appconfig = (ManifastConfiguration)gs.fromJson(IOUtils.toString((InputStream)configFile.getContents(), (Charset)Charset.forName("UTF-8")), ManifastConfiguration.class);
            String launchPath = appconfig.getLaunch_path();
            IFile launchFile = configFile.getProject().getFile(launchPath);
            if (launchFile != null && launchFile.exists()) {
                String rPath = URIUtils.relativeURI((String)launchPath, (String)HMobileDeviceLauncher.getAutoTransfor().getSpecJsFileName());
                String fName = launchFile.getName();
                String charset = launchFile.getCharset();
                String launchContent = IOUtils.toString((InputStream)launchFile.getContents(), (String)charset);
                launchContent = "<script type=\"text/javascript\" src=\"" + rPath + "\"></script>\r\n" + launchContent;
                File tempFile = AndroidPlugin.getDefault().getBundle().getDataFile(fName);
                FileUtils.writeStringToFile((File)tempFile, (String)launchContent, (String)charset);
                String releasePath = tempFile.getAbsolutePath();
                launcher.pushResource(this.targetApp, releasePath, releasePath, launchPath);
                return launchFile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private File getNewManifestJSonFile(IFile configFile, ILauncher launcher) throws JsonSyntaxException, IOException, CoreException {
        if (configFile != null) {
            Gson gs = new Gson();
            ManifastConfiguration appconfig = (ManifastConfiguration)gs.fromJson(IOUtils.toString((InputStream)configFile.getContents(), (Charset)Charset.forName("UTF-8")), ManifastConfiguration.class);
            if (appconfig != null && appconfig.getPlus() != null) {
                if (this.targetMobile.isCached()) {
                    appconfig.getPlus().setRamcachemode("enable");
                    launcher.setNeedWarnCache(false);
                } else {
                    appconfig.getPlus().setRamcachemode("debugdisable");
                    launcher.setNeedWarnCache(true);
                }
            }
            this.targetApp.setAppName(appconfig.getAppName());
            JsonObject appConfigJson = ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)appconfig, (File)configFile.getLocation().makeAbsolute().toFile(), (IProject)configFile.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)false, (boolean)true);
            String[] basePermissions = new String[]{"Accelerometer", "Audio", "Camera", "Device", "Downloader", "File", "Gallery", "Geolocation", "Invocation", "Orientation", "Proximity", "Storage", "Uploader", "Runtime", "XMLHttpRequest", "Zip", "Barcode", "Webview", "NativeUI", "Navigator", "NativeObj"};
            JsonObject permissionsJsonObject = appConfigJson.get("permissions").getAsJsonObject();
            String[] stringArray = basePermissions;
            int n = basePermissions.length;
            int n2 = 0;
            while (n2 < n) {
                String permission = stringArray[n2];
                if (!permissionsJsonObject.has("permission")) {
                    permissionsJsonObject.add(permission, (JsonElement)new JsonObject());
                }
                ++n2;
            }
            HashSet<File> projectUnpackageFiles = new HashSet<File>();
            try {
                if (appConfigJson.has("unpackage")) {
                    JsonArray array = appConfigJson.getAsJsonArray("unpackage");
                    IPath projectPath = configFile.getProject().getLocation();
                    if (array != null && array.size() > 0) {
                        for (JsonElement jsonElement : array) {
                            if (!jsonElement.isJsonPrimitive()) continue;
                            projectUnpackageFiles.add(configFile.getProject().getLocation().append(jsonElement.getAsString()).toFile());
                        }
                    }
                    unpackageFiles.put(projectPath.toFile().getAbsolutePath(), projectUnpackageFiles);
                }
                appConfigJson.remove("dependencies");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String content = gs.toJson((JsonElement)appConfigJson);
            File file = AndroidPlugin.getDefault().getBundle().getDataFile("manifest.json");
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)Charset.forName("UTF-8"));
            return file;
        }
        return null;
    }

    protected String getRemoteDebugIPAddress() {
        String result = "127.0.0.1";
        if (this.runEnv != null && this.runEnv.get("IPAddress") != null) {
            result = this.runEnv.get("IPAddress").toString();
        }
        if ("127.0.0.1".equals(result)) {
            Enumeration<NetworkInterface> netInterfaces = null;
            try {
                netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        InetAddress address = ips.nextElement();
                        if (address.getHostAddress().indexOf(".") <= 0 || "127.0.0.1".equals(address.getHostAddress())) continue;
                        return address.getHostAddress();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void pushSingleResource(IResource resource, boolean isDelete) {
        block32: {
            if (resource == null) {
                return;
            }
            IProject project = resource.getProject();
            HMobileProject hMobileProject = null;
            try {
                hMobileProject = ProjectUtils.convertToHMobile((IProject)project);
            }
            catch (ConvertProjectException e1) {
                e1.printStackTrace();
            }
            if (hMobileProject != null) {
                File projectFile = hMobileProject.getSourceRoot().makeAbsolute().toFile();
                String srcRootPath = projectFile.getAbsolutePath();
                if (this.mobileLauncher != null) {
                    try {
                        boolean isManifest;
                        File resourceFile = resource.getLocation().makeAbsolute().toFile();
                        String resourcePath = resourceFile.getAbsolutePath();
                        if (!resourcePath.startsWith(srcRootPath)) {
                            return;
                        }
                        if (HMobileDeviceLauncher.isSpecName(projectFile, resourceFile)) {
                            return;
                        }
                        String relativePath = URIUtils.relativeLocation((String)resourcePath, (String)srcRootPath);
                        if (HMobileDeviceLauncher.isSpecFile(relativePath = relativePath.replace("\\", "/"))) {
                            return;
                        }
                        if (MANIFEST_JSON.equals(relativePath) && StreamJsonUtil.isStreamJson) {
                            StreamJsonUtil.isStreamJson = false;
                            return;
                        }
                        boolean bl = isManifest = StringUtil.isNotBlank((String)relativePath) && relativePath.equals(MANIFEST_JSON) && !isDelete;
                        if (isManifest && resource instanceof IFile) {
                            File file = null;
                            try {
                                file = this.getNewManifestJSonFile((IFile)resource, this.mobileLauncher);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new OperateException("\u540c\u6b65manifest.json\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), true);
                            }
                            if (file != null && file.exists()) {
                                resourcePath = file.getAbsolutePath();
                            }
                        }
                        if (this.isDebug) break block32;
                        ProcessorResult result = ProjectProcessors.processorFileInProject((HMobileProject)hMobileProject, (File)resourceFile, (IProjectProcessor.Profile)IProjectProcessor.Profile.DEVELOPMENT);
                        boolean hasJS = false;
                        if (!result.isEmpty()) {
                            boolean isCompileSrcFile = false;
                            for (String compileSrcFile : result.compileSrcFiles) {
                                File srcFile = new File(result.srcDir, compileSrcFile);
                                if (!srcFile.equals(resourceFile)) continue;
                                isCompileSrcFile = true;
                                break;
                            }
                            boolean isCompileDestFile = false;
                            for (String compileDestFile : result.compileDestFiles) {
                                File destFile = new File(result.destDir, compileDestFile);
                                if (!destFile.exists()) continue;
                                if (!isCompileDestFile && new File(result.srcDir, compileDestFile).equals(resourceFile)) {
                                    isCompileDestFile = true;
                                }
                                String destPath = destFile.getAbsolutePath().replace("\\", "/");
                                String destRelativePath = compileDestFile.replace("\\", "/");
                                this.printlnToConsole(String.valueOf(Messages.HMobileDeviceLauncher_Synchronizing) + destRelativePath + Messages.HMobileDeviceLauncher_File);
                                this.mobileLauncher.pushResource(this.targetApp, destPath, destPath, destRelativePath);
                                this.printlnToConsole("\u6587\u4ef6" + destRelativePath + "\u540c\u6b65\u5b8c\u6210...");
                                hasJS = this.isJsFile(destPath, hasJS);
                            }
                            if (isDelete && StringUtil.isNotBlank((String)result.deleteDestFile)) {
                                resourcePath = new File(result.srcDir, result.deleteDestFile).getAbsolutePath().replace("\\", "/");
                                relativePath = result.deleteDestFile;
                                this.printlnToConsole(String.valueOf(Messages.HMobileDeviceLauncher_Synchronizing) + relativePath + Messages.HMobileDeviceLauncher_File);
                                this.mobileLauncher.deleteResource(this.targetApp, resourcePath, relativePath);
                                this.printlnToConsole("\u6587\u4ef6" + relativePath + "\u540c\u6b65\u5b8c\u6210...");
                                hasJS = this.isJsFile(resourcePath, hasJS);
                            } else if (!(isDelete || isCompileSrcFile || isCompileDestFile)) {
                                this.printlnToConsole(String.valueOf(Messages.HMobileDeviceLauncher_Synchronizing) + relativePath + Messages.HMobileDeviceLauncher_File);
                                this.mobileLauncher.pushResource(this.targetApp, resourcePath, resourcePath, relativePath);
                                this.printlnToConsole(String.valueOf(Messages.HMobileDeviceLauncher_Synchronizing) + relativePath + Messages.HMobileDeviceLauncher_File);
                                hasJS = this.isJsFile(resourcePath, hasJS);
                            }
                            for (String sourceMapFilePath : result.sourceMapFiles) {
                                File sourceMapFile = new File(result.destDir, sourceMapFilePath);
                                if (!sourceMapFile.exists()) continue;
                                ILauncher.sourceMap.put(sourceMapFile.getName(), IOUtil.read((InputStream)new FileInputStream(sourceMapFile)));
                            }
                        } else {
                            this.printlnToConsole(String.valueOf(Messages.HMobileDeviceLauncher_Synchronizing) + relativePath + Messages.HMobileDeviceLauncher_File);
                            if (isDelete) {
                                this.mobileLauncher.deleteResource(this.targetApp, resourcePath, relativePath);
                            } else {
                                this.mobileLauncher.pushResource(this.targetApp, resourcePath, resourcePath, relativePath);
                            }
                            this.printlnToConsole("\u6587\u4ef6" + relativePath + "\u540c\u6b65\u5b8c\u6210...");
                            hasJS = this.isJsFile(resourcePath, hasJS);
                        }
                        if (isManifest) {
                            this.printlnToConsole("\u4fee\u6539manifest.json\u53ef\u80fd\u9700\u8981\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8fd0\u884c\uff0c\u56e0\u4e3a\u8be5\u6587\u4ef6\u662fApp\u57fa\u7840\u914d\u7f6e\u6587\u4ef6\u3002", null);
                        }
                        if (!hasJS || project == null || !project.hasNature("com.pandora.projects.ui.Wap2AppNature")) break block32;
                        File file = null;
                        try {
                            file = this.getNewManifestJSonFile(project.getFile(MANIFEST_JSON), this.mobileLauncher);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new OperateException("\u540c\u6b65manifest.json\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), true);
                        }
                        if (file != null && file.exists()) {
                            String manifestPath = file.getAbsolutePath();
                            this.mobileLauncher.pushResource(this.targetApp, manifestPath, manifestPath, MANIFEST_JSON);
                        }
                        this.printlnToConsole("\u6ce8\uff1a\u914d\u7f6e\u89c4\u5219\u53d8\u5316\uff0c\u6b63\u5728\u91cd\u542fwap2app\u9879\u76ee", null);
                        this.mobileLauncher.sendRestartCmd(this.targetApp);
                    }
                    catch (OperateException e) {
                        e.printStackTrace();
                        this.printlnToConsole(e.getMessage(), e);
                        if (e.isNeedStop()) {
                            this.consoleStoped();
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.printlnToConsole("\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), new OperateException(""));
                        return;
                    }
                }
            }
        }
    }

    public boolean isJsFile(String resourcePath, boolean hasJS) {
        if (!hasJS) {
            hasJS = StringUtil.isNotBlank((String)resourcePath) && resourcePath.toLowerCase().endsWith(".js");
        }
        return hasJS;
    }

    public static boolean isSpecFile(String line) {
        if (StringUtil.isBlank((String)line)) {
            return false;
        }
        return line.contains("/.svn/") || line.contains("\\.svn\\") || line.contains("/.git/") || line.contains("\\.git\\") || line.contains("/.settings/") || line.contains("\\.settings\\") || line.contains("/.project") || line.contains("\\.project");
    }

    public static File copyProjectFiles(HMobileProject project, ILauncher mobileLauncher) throws OperateException {
        final File f = new File(project.getProject().getLocationURI());
        File tmp = CoreActivator.getDefault().getBundle().getDataFile("run_tmp");
        if (tmp.exists()) {
            FileUtils.deleteQuietly((File)tmp);
        }
        tmp.mkdirs();
        try {
            FileUtils.copyDirectory((File)f, (File)tmp, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !HMobileDeviceLauncher.isSpecName(f, pathname);
                }
            });
            ProcessorResult result = ProjectProcessors.processorProject((HMobileProject)project, (File)tmp, (File)tmp, (boolean)true, (IProjectProcessor.Profile)IProjectProcessor.Profile.DEVELOPMENT);
            if (!result.isEmpty()) {
                for (String sourceMapFilePath : result.sourceMapFiles) {
                    File sourceMapFile = new File(result.destDir, sourceMapFilePath);
                    if (!sourceMapFile.exists()) continue;
                    ILauncher.sourceMap.put(sourceMapFile.getName(), IOUtil.read((InputStream)new FileInputStream(sourceMapFile)));
                }
            }
        }
        catch (Throwable e) {
            throw new OperateException(e.getMessage());
        }
        return tmp;
    }

    public static String transSourceMapLog(String message, Map<String, String> sourceMap) {
        block12: {
            if (!StringUtil.isNotBlank((String)message) || !message.contains("<anonymous>")) break block12;
            return "";
        }
        try {
            Pattern p = Pattern.compile("at(\\s+)(.*):(\\d+)");
            Matcher m = p.matcher(message);
            String filePath = "";
            int lineNum = 0;
            int rowNum = 0;
            boolean isMached = false;
            if (m.find()) {
                filePath = m.group(2);
                lineNum = Integer.valueOf(m.group(3));
                isMached = true;
            } else {
                p = Pattern.compile("\\((.*):(\\d+):(\\d+)\\)");
                m = p.matcher(message);
                if (m.find()) {
                    filePath = m.group(1);
                    lineNum = Integer.valueOf(m.group(2));
                    rowNum = Integer.valueOf(m.group(3));
                    isMached = true;
                }
            }
            if (isMached) {
                SourceMapImpl map;
                Mapping mapping;
                String contnet;
                File tFile = new File(String.valueOf(filePath) + ".map");
                String fName = tFile.getName();
                if (!sourceMap.containsKey(fName)) {
                    int index = fName.lastIndexOf("=");
                    fName = fName.substring(index + 1);
                }
                if (StringUtil.isNotBlank((String)(contnet = sourceMap.get(fName))) && (mapping = (map = new SourceMapImpl(contnet)).getMapping(lineNum - 1, rowNum)) != null) {
                    String newFilePath = mapping.getSourceFileName();
                    int newLineNum = mapping.getSourceLine() + 1;
                    String rowPrefix = ":" + rowNum;
                    int index = message.lastIndexOf(rowPrefix);
                    if (index > 0) {
                        message = message.substring(0, index);
                    }
                    message = message.replace(filePath, newFilePath);
                    if ((message = message.replace(":" + lineNum, ":" + newLineNum)).trim().startsWith("(")) {
                        message = message.trim();
                        message = message.substring(1, message.length());
                        message = " at " + message;
                    }
                    if (message.endsWith(")")) {
                        message = message.substring(0, message.length() - 1);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return message;
    }

    public static boolean isSpecName(File project, File file) {
        String fileName;
        if (project == null || file == null) {
            return false;
        }
        String projectPath = project.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (unpackageFiles != null && unpackageFiles.containsKey(projectPath)) {
            Set<File> fs = unpackageFiles.get(projectPath);
            if (fs != null && fs.contains(file)) {
                return true;
            }
            for (File f : fs) {
                String dirPath;
                if (!f.isDirectory() || !filePath.startsWith(dirPath = f.getAbsolutePath())) continue;
                return true;
            }
        }
        int length = projectPath.length();
        if (filePath.length() > length - 1) {
            filePath = filePath.substring(length + 1);
            if ((filePath = filePath.replace("\\", "/")).startsWith("unpackage/") || filePath.startsWith("node_modules/") || file.isDirectory() && (filePath.equals("unpackage") || filePath.equals("node_modules"))) {
                return true;
            }
        }
        if (StringUtil.isBlank((String)(fileName = file.getName()))) {
            return false;
        }
        return fileName.equals(".svn") || fileName.equals(".git") || fileName.equals(".settings") || fileName.equals(".project") || fileName.equals(".DS_Store");
    }

    @Override
    public void printlnToConsole(String message) {
        MessageQueue queue;
        if (ConsoleActivator.getDefault() != null && (queue = ConsoleActivator.getDefault().getMessageQueue((IConsoleListener)this)) != null) {
            queue.putMessage(message);
        }
    }

    @Override
    public void printlnToConsole(String message, OperateException e) {
        MessageQueue queue;
        if (ConsoleActivator.getDefault() != null && (queue = ConsoleActivator.getDefault().getMessageQueue((IConsoleListener)this)) != null) {
            queue.putMessage("CONSOLE_ERROR:" + message);
        }
    }

    public static Mobile handleMobileList() {
        final Mobile[] mobiles = new Mobile[1];
        final List<Mobile> mobileList = LauncherCoreActivator.getMachineList();
        if (mobileList == null || mobileList.isEmpty()) {
            HMobileDeviceLauncher.showMessage(Messages.HMobileDeviceLauncher_No_Phone, 8);
        } else {
            if (mobileList.size() == 1) {
                return mobileList.get(0);
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MobileSelectDialog selectDialog = new MobileSelectDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider(){

                        public Image getImage(Object element) {
                            Mobile m = (Mobile)element;
                            return ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)m.getIcon());
                        }

                        public String getText(Object element) {
                            return super.getText(element);
                        }
                    }, (ILabelProvider)new LabelProvider(){

                        public Image getImage(Object element) {
                            Mobile m = (Mobile)element;
                            return ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)m.getIcon());
                        }

                        public String getText(Object element) {
                            return super.getText(element);
                        }
                    });
                    selectDialog.setElements(mobileList.toArray());
                    selectDialog.setTitle(Messages.HMobileDeviceLauncher_Select_Phone);
                    int select = selectDialog.open();
                    if (select == 0) {
                        Object mobile = selectDialog.getSelectMobile();
                        mobiles[0] = (Mobile)mobile;
                    }
                }
            });
        }
        return mobiles[0];
    }

    public static void showMessage(String string, int style) {
    }

    public void resourceChanged(IResource resource, boolean isFullBuild, boolean isDelete) {
        if (isFullBuild) {
            return;
        }
        if (resource.getProject() != this.targetApp.getProject()) {
            return;
        }
        if (this.isRunning && resource != null && resource instanceof IFile) {
            this.pushSingleResource(resource, isDelete);
        }
    }

    @Override
    public void connected(Mobile mobile) {
        if (mobile == this.targetMobile) {
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)("mobile " + mobile.getName() + Messages.HMobileDeviceLauncher_Conected));
        }
    }

    @Override
    public void disConnected(Mobile mobile) {
        if (mobile == this.targetMobile || this.targetMobile.getUuid().equals(mobile.getUuid())) {
            DefaultMobileManager.getInstance().removeMobileListener(this);
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(mobile.getName()) + Messages.HMobileDeviceLauncher_Conected_Existed));
            this.closeConsole();
        }
    }

    public void closeConsole() {
        this.printlnToConsole("EXIT PROCESS FROM ECLIPSE");
    }

    @Override
    public void stoped(IProject project, Mobile mobile) {
        if (mobile != null && mobile.getUuid().equals(this.targetMobile.getUuid())) {
            this.closeConsole();
        }
    }

    public void consoleStarted() {
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.HMobileDeviceLauncher_Console_Start);
    }

    public void consoleStoped() {
        HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.HMobileDeviceLauncher_Console_Stop);
        this.setRunning(false);
        HMobileUtils.getBuilder().removeResourceChangeListener((Object)this);
        DefaultMobileManager.getInstance().stoped(this.targetApp.getProject(), this.targetMobile);
        try {
            this.mobileLauncher.clearApplicationLog(this.targetApp);
        }
        catch (OperateException e) {
            e.printStackTrace();
        }
    }

    public void setRunEnv(Map runEnv) {
        this.runEnv = runEnv;
    }

    public static Set<String> getFileReference(IProject project, String jsFile) {
        return IndexUtil.getFileReference((IProject)project, (String)jsFile);
    }

    public static IAutoTransfor getAutoTransfor() {
        return autoTransfor;
    }

    public static void setAutoTransfor(IAutoTransfor at) {
        autoTransfor = at;
    }

    public static void openPerspective() {
        if (LauncherCoreActivator.isAutoStartWebviewRemoteDebugView()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PerspectiveUtils.openPerspective((String)"com.pandora.view.RemoteDebugPerspective");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

