/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core;

import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.internal.Mobile;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IProject;

public class DefaultMobileManager
implements IMobileListener {
    private static DefaultMobileManager instance = null;
    private static Mobile currentMobile = null;
    private static boolean isCustom = false;
    private Set<IMobileListener> listeners = new CopyOnWriteArraySet<IMobileListener>();

    private DefaultMobileManager() {
    }

    public static DefaultMobileManager getInstance() {
        if (instance == null) {
            instance = new DefaultMobileManager();
        }
        return instance;
    }

    @Override
    public void connected(Mobile mobile) {
        if (mobile.getStatus() == MobileStatus.CONNECTED) {
            return;
        }
        mobile.setStatus(MobileStatus.CONNECTED);
        for (IMobileListener listener : this.listeners) {
            listener.connected(mobile);
        }
    }

    @Override
    public void disConnected(Mobile mobile) {
        if (mobile.getStatus() == MobileStatus.DISCONNECTED) {
            return;
        }
        mobile.setStatus(MobileStatus.DISCONNECTED);
        for (IMobileListener listener : this.listeners) {
            listener.disConnected(mobile);
        }
    }

    @Override
    public void running(IProject project, Mobile mobile) {
        if (mobile.getStatus() == MobileStatus.RUNNING) {
            return;
        }
        this.stopDebug(mobile);
        mobile.setStatus(MobileStatus.RUNNING);
        mobile.setProject(project);
        for (IMobileListener listener : this.listeners) {
            listener.running(project, mobile);
        }
    }

    public void stopDebug(Mobile mobile) {
        if (mobile == null || DefaultMobileManager.getCurrentMobile() == null) {
            return;
        }
        if (DefaultMobileManager.getCurrentMobile() == mobile) {
            LauncherCoreActivator.closeChrome();
        }
    }

    @Override
    public void stoped(IProject project, Mobile mobile) {
        if (mobile.getStatus() == MobileStatus.STOPED) {
            return;
        }
        this.stopDebug(mobile);
        mobile.setStatus(MobileStatus.STOPED);
        for (IMobileListener listener : this.listeners) {
            listener.stoped(project, mobile);
        }
        mobile.setProject(null);
    }

    public void addMobileListener(IMobileListener listener) {
        this.listeners.add(listener);
    }

    public void removeMobileListener(IMobileListener listener) {
        this.listeners.remove(listener);
    }

    public static Mobile getCurrentMobile() {
        return currentMobile;
    }

    public static void setCurrentMobile(Mobile mobile) {
        currentMobile = mobile;
    }

    public static boolean isCustom() {
        return isCustom;
    }

    public static void setCustom(boolean isCustom) {
        DefaultMobileManager.isCustom = isCustom;
    }

    public static enum MobileStatus {
        CONNECTED,
        RUNNING,
        STOPED,
        DISCONNECTED;

    }
}

