/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sourcemap;

import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapImpl;
import com.atlassian.sourcemap.SourceMapJoiner;
import java.io.IOException;
import java.io.InputStream;

public class Util {
    public static String generateSourceMapComment(String sourceMapUrl, String type) {
        if ("js".equals(type)) {
            return "//# sourceMappingURL=" + sourceMapUrl;
        }
        if ("css".equals(type)) {
            return "/*# sourceMappingURL=" + sourceMapUrl + " */";
        }
        throw new RuntimeException("invalid source map type " + type);
    }

    public static SourceMap create1to1SourceMap(CharSequence source, String sourceUrl) {
        SourceMapImpl map = new SourceMapImpl();
        int line = 0;
        map.addMapping(line, 0, line, 0, sourceUrl);
        int i = 0;
        while (i < source.length()) {
            if (source.charAt(i) == '\n') {
                map.addMapping(++line, 0, line, 0, sourceUrl);
            }
            ++i;
        }
        return map;
    }

    public static int countLines(InputStream stream) {
        try {
            int c = stream.read();
            int counter = 0;
            while (c != -1) {
                if (c == 10) {
                    ++counter;
                }
                c = stream.read();
            }
            return counter + 1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int countLines(CharSequence stream) {
        int counter = 0;
        int i = 0;
        while (i < stream.length()) {
            if (stream.charAt(i) == '\n') {
                ++counter;
            }
            ++i;
        }
        return counter + 1;
    }

    public static SourceMap offset(SourceMap sourceMap, int offset) {
        return new SourceMapImpl(sourceMap, offset);
    }

    public static SourceMap rebase(SourceMap sourceMap, final SourceMap previousSourceMap) {
        final SourceMapImpl rebasedMap = new SourceMapImpl();
        sourceMap.eachMapping(new SourceMap.EachMappingCallback(){

            @Override
            public void apply(Mapping mapping) {
                Mapping rebasedMapping = previousSourceMap.getMapping(mapping.getSourceLine(), mapping.getSourceColumn());
                if (rebasedMapping != null) {
                    rebasedMap.addMapping(mapping.getGeneratedLine(), mapping.getGeneratedColumn(), rebasedMapping.getSourceLine(), rebasedMapping.getSourceColumn(), rebasedMapping.getSourceFileName(), rebasedMapping.getSourceSymbolName());
                }
            }
        });
        return rebasedMap;
    }

    public static SourceMapJoiner joiner() {
        return new SourceMapJoiner();
    }
}

