/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sourcemap;

import com.atlassian.sourcemap.Consumer;
import com.atlassian.sourcemap.Generator;
import com.atlassian.sourcemap.InternalUtil;
import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.MappingImpl;
import com.atlassian.sourcemap.SourceMap;
import java.util.ArrayList;
import java.util.List;

public class SourceMapImpl
implements SourceMap {
    private State state;

    public SourceMapImpl(String sourceMap) {
        this.state = new Read(this, new Consumer(sourceMap));
    }

    public SourceMapImpl() {
        this.state = new None(this);
    }

    protected SourceMapImpl(SourceMap sourceMap, int offset) {
        this.state = new DeferredOffset(this, sourceMap, offset);
    }

    @Override
    public void addMapping(int generatedLine, int generatedColumn, int sourceLine, int sourceColumn, String sourceFileName) {
        this.addMapping(generatedLine, generatedColumn, sourceLine, sourceColumn, sourceFileName, null);
    }

    @Override
    public void addMapping(int generatedLine, int generatedColumn, int sourceLine, int sourceColumn, String sourceFileName, String sourceSymbolName) {
        this.addMapping(new MappingImpl(generatedLine, generatedColumn, sourceLine, sourceColumn, sourceFileName, sourceSymbolName));
    }

    @Override
    public void addMapping(Mapping mapping) {
        this.state.addMapping(mapping);
    }

    @Override
    public Mapping getMapping(int lineNumber, int column) {
        return this.state.getMapping(lineNumber, column);
    }

    @Override
    public String generate() {
        return this.state.generate();
    }

    @Override
    public String generateForHumans() {
        Consumer consumer = new Consumer(this.generate());
        final StringBuilder buff = new StringBuilder();
        buff.append("{\n");
        buff.append("  sources  : [\n    " + InternalUtil.join(consumer.getSourceFileNames(), "\n    ") + "\n  ]\n");
        buff.append("  mappings : [\n    ");
        final int[] previousLine = new int[]{-1};
        consumer.eachMapping(new SourceMap.EachMappingCallback(){

            @Override
            public void apply(Mapping mapping) {
                if (mapping.getGeneratedLine() != previousLine[0] && previousLine[0] != -1) {
                    buff.append("\n    ");
                } else if (previousLine[0] != -1) {
                    buff.append(", ");
                }
                previousLine[0] = mapping.getGeneratedLine();
                String shortName = mapping.getSourceFileName().replaceAll(".*/", "");
                buff.append("(" + mapping.getGeneratedLine() + ":" + mapping.getGeneratedColumn() + " -> " + shortName + ":" + mapping.getSourceLine() + ":" + mapping.getSourceColumn() + ")");
            }
        });
        buff.append("\n  ]\n}");
        return buff.toString();
    }

    @Override
    public List<String> getSourceFileNames() {
        return this.state.getSourceFileNames();
    }

    @Override
    public void eachMapping(SourceMap.EachMappingCallback callback) {
        this.state.eachMapping(callback);
    }

    private static class DeferredOffset
    implements State {
        private final SourceMap sourceMapWithoutOffset;
        private int offset = 0;
        private SourceMapImpl thisSourceMap;

        public DeferredOffset(SourceMapImpl thisSourceMap, SourceMap sourceMapWithoutOffset, int offset) {
            this.thisSourceMap = thisSourceMap;
            this.sourceMapWithoutOffset = sourceMapWithoutOffset;
            this.offset = offset;
        }

        @Override
        public void addMapping(Mapping mapping) {
            throw new RuntimeException("operation addMapping not supported in " + this.getClass().getSimpleName() + " state!");
        }

        @Override
        public String generate() {
            return this.calculateOffsetAndSwitchIntoWriteState().generate();
        }

        @Override
        public void eachMapping(SourceMap.EachMappingCallback callback) {
            this.calculateOffsetAndSwitchIntoWriteState().eachMapping(callback);
        }

        @Override
        public Mapping getMapping(int lineNumber, int column) {
            return this.calculateOffsetAndSwitchIntoWriteState().getMapping(lineNumber, column);
        }

        @Override
        public List<String> getSourceFileNames() {
            return this.calculateOffsetAndSwitchIntoWriteState().getSourceFileNames();
        }

        private State calculateOffsetAndSwitchIntoWriteState() {
            final Write write = new Write(this.thisSourceMap);
            this.sourceMapWithoutOffset.eachMapping(new SourceMap.EachMappingCallback(){

                @Override
                public void apply(Mapping mapping) {
                    write.addMapping(new MappingImpl(DeferredOffset.this.offset + mapping.getGeneratedLine(), mapping.getGeneratedColumn(), mapping.getSourceLine(), mapping.getSourceColumn(), mapping.getSourceFileName(), mapping.getSourceSymbolName()));
                }
            });
            this.thisSourceMap.state = write;
            return write;
        }
    }

    private static class None
    implements State {
        private final SourceMapImpl thisSourceMap;

        public None(SourceMapImpl thisSourceMap) {
            this.thisSourceMap = thisSourceMap;
        }

        @Override
        public void addMapping(Mapping mapping) {
            this.switchIntoWriteState().addMapping(mapping);
        }

        @Override
        public String generate() {
            return this.switchIntoReadState().generate();
        }

        @Override
        public void eachMapping(SourceMap.EachMappingCallback callback) {
            this.switchIntoReadState().eachMapping(callback);
        }

        @Override
        public Mapping getMapping(int lineNumber, int column) {
            return this.switchIntoReadState().getMapping(lineNumber, column);
        }

        @Override
        public List<String> getSourceFileNames() {
            return this.switchIntoReadState().getSourceFileNames();
        }

        private State switchIntoReadState() {
            this.thisSourceMap.state = new Read(this.thisSourceMap, new Consumer("{\n  \"version\":3,\n  \"sources\":[],\n  \"names\":[],\n  \"mappings\":\"\"\n}"));
            return this.thisSourceMap.state;
        }

        private State switchIntoWriteState() {
            this.thisSourceMap.state = new Write(this.thisSourceMap);
            return this.thisSourceMap.state;
        }
    }

    private static class Read
    implements State {
        private Consumer consumer;
        private SourceMapImpl thisSourceMap;

        public Read(SourceMapImpl thisSourceMap, Consumer consumer) {
            this.thisSourceMap = thisSourceMap;
            this.consumer = consumer;
        }

        @Override
        public void eachMapping(SourceMap.EachMappingCallback callback) {
            this.consumer.eachMapping(callback);
        }

        @Override
        public Mapping getMapping(int lineNumber, int column) {
            return this.consumer.getMapping(lineNumber, column);
        }

        @Override
        public List<String> getSourceFileNames() {
            return new ArrayList<String>(this.consumer.getSourceFileNames());
        }

        @Override
        public void addMapping(Mapping mapping) {
            throw new RuntimeException("operation getSourceFileNames not supported in " + this.getClass().getSimpleName() + " state!");
        }

        @Override
        public String generate() {
            final Generator generator = new Generator();
            this.eachMapping(new SourceMap.EachMappingCallback(){

                @Override
                public void apply(Mapping mapping) {
                    generator.addMapping(mapping);
                }
            });
            return generator.generate();
        }
    }

    private static interface State {
        public void addMapping(Mapping var1);

        public String generate();

        public void eachMapping(SourceMap.EachMappingCallback var1);

        public Mapping getMapping(int var1, int var2);

        public List<String> getSourceFileNames();
    }

    private static class Write
    implements State {
        private SourceMapImpl thisSourceMap;
        private Generator generator;
        private int lastGeneratedLine = 0;
        private int lastGeneratedColumn = 0;

        public Write(SourceMapImpl thisSourceMap) {
            this.thisSourceMap = thisSourceMap;
            this.generator = new Generator();
        }

        @Override
        public void addMapping(Mapping mapping) {
            if (this.lastGeneratedLine > mapping.getGeneratedLine()) {
                throw new RuntimeException("mappings should be added in a proper order!");
            }
            if (this.lastGeneratedLine == mapping.getGeneratedLine() && this.lastGeneratedColumn > mapping.getGeneratedColumn()) {
                throw new RuntimeException("mappings should be added in a proper order!");
            }
            this.lastGeneratedLine = mapping.getGeneratedLine();
            this.lastGeneratedColumn = mapping.getGeneratedColumn();
            this.generator.addMapping(mapping);
        }

        @Override
        public String generate() {
            return this.generator.generate();
        }

        @Override
        public void eachMapping(SourceMap.EachMappingCallback callback) {
            this.performanceInefficientSwitchIntoReadState().eachMapping(callback);
        }

        @Override
        public Mapping getMapping(int lineNumber, int column) {
            return this.performanceInefficientSwitchIntoReadState().getMapping(lineNumber, column);
        }

        @Override
        public List<String> getSourceFileNames() {
            return this.performanceInefficientSwitchIntoReadState().getSourceFileNames();
        }

        private Read performanceInefficientSwitchIntoReadState() {
            Read read = new Read(this.thisSourceMap, new Consumer(this.generate()));
            this.thisSourceMap.state = read;
            return read;
        }
    }
}

