/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.preferences;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.DelayedTextAttribute;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.RGBa;
import com.aptana.theme.TextmateImporter;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemeExporter;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import com.aptana.theme.preferences.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.themes.ITheme;
import org.osgi.service.prefs.BackingStoreException;

public class ThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
IInputValidator,
IPropertyChangeListener {
    public static final String ID = "com.aptana.theme.preferencePage";
    private static final String THEME_DIRECTORY = "themeDirectory";
    private static final String THEME_EXPORT_DIRECTORY = "themeExportDirectory";
    private static List<String> tokenTypeNames = new ArrayList<String>();
    private static final int ROW_HEIGHT = 20;
    protected Theme fSelectedTheme;
    private ColorSelector fgSelector;
    private ColorSelector bgSelector;
    private ColorSelector lineHighlightSelector;
    private ColorSelector selectionSelector;
    private ColorSelector caretSelector;
    private ColorSelector tabSelector;
    private Combo fThemeCombo;
    private TableViewer tableViewer;
    private Set<TableEditor> fTableEditors;
    private Button renameThemeButton;
    private Button deleteThemeButton;
    private HashMap<Integer, Font> fFonts;
    private Button fInvasiveThemeCheckbox;
    private Button fInvasiveFontCheckbox;
    private Button fAddThemeButton;
    private Button fImportButton;
    private Button fAddTokenButton;
    private Button fRemoveTokenButton;
    private Combo fScopeText;
    private Button fExportButton;
    private Font fFont;
    private Text fFontText;
    private boolean reorderingRules = false;
    private ControlDecoration fScopeSelectorDecoration;
    private Button fAptanaEditorsOnlyCheckbox;

    static {
        tokenTypeNames.add("comment");
        tokenTypeNames.add("comment.block");
        tokenTypeNames.add("comment.documentation");
        tokenTypeNames.add("comment.line");
        tokenTypeNames.add("constant");
        tokenTypeNames.add("constant.character");
        tokenTypeNames.add("constant.language");
        tokenTypeNames.add("constant.numeric");
        tokenTypeNames.add("constant.other");
        tokenTypeNames.add("console.error");
        tokenTypeNames.add("console.input");
        tokenTypeNames.add("console.output");
        tokenTypeNames.add("console.prompt");
        tokenTypeNames.add("console.warning");
        tokenTypeNames.add("entity.name");
        tokenTypeNames.add("entity.name.class");
        tokenTypeNames.add("entity.name.function");
        tokenTypeNames.add("entity.name.tag");
        tokenTypeNames.add("entity.other");
        tokenTypeNames.add("entity.other.attribute-name");
        tokenTypeNames.add("entity.other.inherited-class");
        tokenTypeNames.add("invalid");
        tokenTypeNames.add("invalid.deprecated");
        tokenTypeNames.add("invalid.illegal");
        tokenTypeNames.add("keyword");
        tokenTypeNames.add("keyword.control");
        tokenTypeNames.add("keyword.operator");
        tokenTypeNames.add("keyword.other");
        tokenTypeNames.add("storage");
        tokenTypeNames.add("storage.modifier");
        tokenTypeNames.add("storage.other");
        tokenTypeNames.add("storage.type");
        tokenTypeNames.add("string");
        tokenTypeNames.add("string.interpolated");
        tokenTypeNames.add("string.other");
        tokenTypeNames.add("string.quoted");
        tokenTypeNames.add("string.regexp");
        tokenTypeNames.add("string.unquoted");
        tokenTypeNames.add("support");
        tokenTypeNames.add("support.class");
        tokenTypeNames.add("support.constant");
        tokenTypeNames.add("support.function");
        tokenTypeNames.add("support.other");
        tokenTypeNames.add("support.type");
        tokenTypeNames.add("variable");
        tokenTypeNames.add("variable.language");
        tokenTypeNames.add("variable.other");
        tokenTypeNames.add("variable.parameter");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createThemeListControls((Composite)group);
        this.createGlobalColorControls((Composite)group);
        this.createTokenEditTable((Composite)group);
        this.createFontArea(composite);
        this.createInvasivePrefArea(composite);
        this.setTheme(this.getThemeManager().getCurrentTheme().getName());
        return composite;
    }

    private void createFontArea(Composite composite) {
        Composite themesComp = new Composite(composite, 0);
        themesComp.setLayout((Layout)new GridLayout(3, false));
        themesComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(themesComp, 0);
        label.setText(Messages.ThemePreferencePage_FontNameLabel);
        this.fFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        this.fFontText = new Text(themesComp, 2060);
        this.fFontText.setText(ThemePreferencePage.toString(this.fFont));
        this.fFontText.setFont(this.fFont);
        this.fFontText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button selectFontButton = new Button(themesComp, 8);
        selectFontButton.setText(Messages.ThemePreferencePage_SelectFontButtonLabel);
        selectFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog fontDialog = new FontDialog(ThemePreferencePage.this.getShell());
                fontDialog.setFontList(ThemePreferencePage.this.fFont.getFontData());
                FontData data = fontDialog.open();
                if (data != null) {
                    ThemePreferencePage.this.setFont(new Font(ThemePreferencePage.this.fFont.getDevice(), fontDialog.getFontList()));
                }
            }
        });
    }

    private static String toString(Font font) {
        if (font == null || font.getFontData() == null || font.getFontData().length <= 0) {
            return "";
        }
        FontData data = font.getFontData()[0];
        return MessageFormat.format(Messages.ThemePreferencePage_FontName, data.getName(), data.getHeight());
    }

    private void createInvasivePrefArea(Composite composite) {
        Composite themesComp = new Composite(composite, 0);
        themesComp.setLayout((Layout)new GridLayout(1, false));
        this.fInvasiveThemeCheckbox = new Button(themesComp, 32);
        this.fInvasiveThemeCheckbox.setText(Messages.ThemePreferencePage_ApplyToAllViews);
        this.fInvasiveThemeCheckbox.setSelection(ThemePlugin.applyToViews());
        this.fInvasiveThemeCheckbox.addSelectionListener((SelectionListener)this);
        this.fInvasiveThemeCheckbox.setToolTipText(Messages.ThemePreferencePage_ApplyToAllViewsToolTip);
        this.fInvasiveThemeCheckbox.setVisible(false);
        this.fAptanaEditorsOnlyCheckbox = new Button(themesComp, 32);
        this.fAptanaEditorsOnlyCheckbox.setText(Messages.ThemePreferencePage_ApplyToAllEditors);
        this.fAptanaEditorsOnlyCheckbox.setSelection(ThemePlugin.applyToAllEditors());
        this.fAptanaEditorsOnlyCheckbox.addSelectionListener((SelectionListener)this);
        this.fAptanaEditorsOnlyCheckbox.setVisible(false);
        this.fInvasiveFontCheckbox = new Button(themesComp, 32);
        this.fInvasiveFontCheckbox.setText(Messages.ThemePreferencePage_InvasiveFontLBL);
        this.fInvasiveFontCheckbox.setSelection(Platform.getPreferencesService().getBoolean("com.aptana.theme", "enable_invasive_font", false, null));
        this.fInvasiveFontCheckbox.addSelectionListener((SelectionListener)this);
        this.fInvasiveFontCheckbox.setToolTipText(Messages.ThemePreferencePage_InvasiveFontToolTip);
        this.fInvasiveFontCheckbox.setVisible(false);
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    private void createThemeListControls(Composite composite) {
        Composite themesComp = new Composite(composite, 0);
        themesComp.setLayout((Layout)new GridLayout(6, false));
        this.fThemeCombo = new Combo(themesComp, 12);
        this.loadThemeNames();
        this.fThemeCombo.addSelectionListener((SelectionListener)this);
        this.fAddThemeButton = new Button(themesComp, 0x800008);
        this.fAddThemeButton.setText(Messages.ThemePreferencePage_AddTokenLabel);
        this.fAddThemeButton.addSelectionListener((SelectionListener)this);
        this.renameThemeButton = new Button(themesComp, 0x800008);
        this.renameThemeButton.setText(CoreStrings.RENAME);
        this.renameThemeButton.addSelectionListener((SelectionListener)this);
        this.deleteThemeButton = new Button(themesComp, 0x800008);
        this.deleteThemeButton.setText(Messages.ThemePreferencePage_RemoveTokenLabel);
        this.deleteThemeButton.addSelectionListener((SelectionListener)this);
        this.fImportButton = new Button(themesComp, 0x800008);
        this.fImportButton.setText(Messages.ThemePreferencePage_ImportLabel);
        this.fImportButton.addSelectionListener((SelectionListener)this);
        this.fExportButton = new Button(themesComp, 0x800008);
        this.fExportButton.setText(Messages.ThemePreferencePage_ExportLabel);
        this.fExportButton.addSelectionListener((SelectionListener)this);
    }

    private void loadThemeNames() {
        this.fThemeCombo.removeAll();
        ArrayList<String> themeNames = new ArrayList<String>(this.getThemeManager().getThemeNames());
        Collections.sort(themeNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String themeName : themeNames) {
            this.fThemeCombo.add(themeName);
        }
    }

    private void createGlobalColorControls(Composite composite) {
        Composite colors = new Composite(composite, 0);
        colors.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_ForegroundLabel);
        this.fgSelector = new ColorSelector(colors);
        this.fgSelector.addListener((IPropertyChangeListener)this);
        label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_SelectionLabel);
        this.selectionSelector = new ColorSelector(colors);
        this.selectionSelector.addListener((IPropertyChangeListener)this);
        label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_BackgroundLabel);
        this.bgSelector = new ColorSelector(colors);
        this.bgSelector.addListener((IPropertyChangeListener)this);
        label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_LineHighlightLabel);
        this.lineHighlightSelector = new ColorSelector(colors);
        this.lineHighlightSelector.addListener((IPropertyChangeListener)this);
        label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_CaretLabel);
        this.caretSelector = new ColorSelector(colors);
        this.caretSelector.addListener((IPropertyChangeListener)this);
        label = new Label(colors, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(Messages.ThemePreferencePage_tabLabel);
        this.tabSelector = new ColorSelector(colors);
        this.tabSelector.addListener((IPropertyChangeListener)this);
    }

    private void createTokenEditTable(Composite composite) {
        Composite comp = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        comp.setLayoutData((Object)gridData);
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayout((Layout)layout);
        final Table table = new Table(comp, 66052);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 0x10) != 0 && event.index == 0) {
                    TableItem item = (TableItem)event.item;
                    ThemeRule token = (ThemeRule)item.getData();
                    if ((token.getTextAttribute().style & 0x40000000) != 0) {
                        int y = event.getBounds().y + event.getBounds().height - 6;
                        int x2 = event.getBounds().width;
                        Color oldFG = event.gc.getForeground();
                        RGBa rgb = token.getTextAttribute().foreground;
                        Color fg = rgb == null ? ThemePlugin.getDefault().getColorManager().getColor(ThemePreferencePage.this.getTheme().getForeground()) : ThemePlugin.getDefault().getColorManager().getColor(rgb.toRGB());
                        event.gc.setForeground(fg);
                        event.gc.drawLine(0, y, x2, y);
                        event.gc.setForeground(oldFG);
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }
        });
        Listener selectionOverride = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0) {
                    Scrollable scrollable = (Scrollable)event.widget;
                    Rectangle clientArea = scrollable.getClientArea();
                    int clientWidth = clientArea.width;
                    GC gc = event.gc;
                    Color oldBackground = gc.getBackground();
                    gc.setBackground(ThemePlugin.getDefault().getColorManager().getColor(ThemePreferencePage.this.getTheme().getSelectionAgainstBG()));
                    gc.fillRectangle(clientArea.x, event.y, clientWidth, event.height);
                    gc.setBackground(oldBackground);
                    event.detail &= 0xFFFFFFFD;
                    event.detail &= 0xFFFFFFF7;
                    gc.setForeground(ThemePlugin.getDefault().getColorManager().getColor(ThemePreferencePage.this.getTheme().getForeground()));
                }
            }
        };
        table.addListener(40, selectionOverride);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Theme theme;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.theme = (Theme)newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.theme.getTokens().toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TokenLabelProvider());
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Table table = ThemePreferencePage.this.tableViewer.getTable();
                int fgColX = table.getColumn(0).getWidth();
                int fgColWidth = table.getColumn(1).getWidth();
                int bgColX = fgColX + fgColWidth;
                int bgColWidth = table.getColumn(2).getWidth() + 2;
                if (e.x > fgColX && e.x < fgColX + fgColWidth) {
                    ColorDialog colorDialog = new ColorDialog(table.getShell());
                    colorDialog.setRGB(ThemePreferencePage.this.getTheme().getForeground());
                    RGB newRGB = colorDialog.open();
                    if (newRGB == null) {
                        return;
                    }
                    TableItem tableItem = table.getItem(new Point(e.x, e.y));
                    ThemeRule token = (ThemeRule)tableItem.getData();
                    int index = table.indexOf(tableItem);
                    ThemePreferencePage.this.getTheme().updateRule(index, token.updateFG(new RGBa(newRGB)));
                } else if (e.x > bgColX && e.x < bgColX + bgColWidth) {
                    ColorDialog colorDialog = new ColorDialog(table.getShell());
                    colorDialog.setRGB(ThemePreferencePage.this.getTheme().getBackground());
                    RGB newRGB = colorDialog.open();
                    if (newRGB == null) {
                        return;
                    }
                    TableItem tableItem = table.getItem(new Point(e.x, e.y));
                    ThemeRule token = (ThemeRule)tableItem.getData();
                    int index = table.indexOf(tableItem);
                    ThemePreferencePage.this.getTheme().updateRule(index, token.updateBG(new RGBa(newRGB)));
                } else {
                    return;
                }
                ThemePreferencePage.this.tableViewer.refresh();
                ThemePreferencePage.this.addCustomTableEditorControls();
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tokenName = column.getColumn();
        tokenName.setText("Element");
        layout.setColumnData((Widget)tokenName, (ColumnLayoutData)new ColumnWeightData(100, true));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ThemeRule token = (ThemeRule)element;
                return token.getName();
            }

            public Color getForeground(Object element) {
                ThemeRule token = (ThemeRule)element;
                RGBa fg = token.getTextAttribute().foreground;
                if (fg == null) {
                    return ThemePlugin.getDefault().getColorManager().getColor(ThemePreferencePage.this.getTheme().getForeground());
                }
                return ThemePlugin.getDefault().getColorManager().getColor(fg.toRGB());
            }

            public Color getBackground(Object element) {
                ThemeRule token = (ThemeRule)element;
                RGBa bg = token.getTextAttribute().background;
                if (bg == null) {
                    return ThemePlugin.getDefault().getColorManager().getColor(ThemePreferencePage.this.getTheme().getBackground());
                }
                return ThemePlugin.getDefault().getColorManager().getColor(bg.toRGB());
            }

            public Font getFont(Object element) {
                ThemeRule token = (ThemeRule)element;
                if (token.getTextAttribute().style == 0) {
                    return ThemePreferencePage.this.fFont;
                }
                return ThemePreferencePage.this.lazyFont(ThemePreferencePage.this.fFont, token.getTextAttribute().style);
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            private TextCellEditor cellEditor;

            protected void setValue(Object element, Object value) {
                String newName = (String)value;
                ThemeRule token = (ThemeRule)element;
                if (newName.equals(token.getName())) {
                    return;
                }
                int index = ThemePreferencePage.this.getTheme().getTokens().indexOf(token);
                ThemePreferencePage.this.getTheme().updateRule(index, token.setName(newName));
                ThemePreferencePage.this.tableViewer.refresh();
            }

            protected Object getValue(Object element) {
                ThemeRule token = (ThemeRule)element;
                return token.getName();
            }

            protected CellEditor getCellEditor(Object element) {
                ThemeRule token = (ThemeRule)element;
                this.cellEditor = new TextCellEditor((Composite)table);
                this.cellEditor.setValue((Object)token.getName());
                return this.cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column = new TableViewerColumn(this.tableViewer, 0);
        TableColumn foreground = column.getColumn();
        foreground.setResizable(false);
        foreground.setText(Messages.ThemePreferencePage_ForegroundColumnLabel);
        layout.setColumnData((Widget)foreground, (ColumnLayoutData)new ColumnPixelData(30, false));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        column = new TableViewerColumn(this.tableViewer, 0);
        TableColumn background = column.getColumn();
        background.setResizable(false);
        background.setText(Messages.ThemePreferencePage_BackgroundColumnLabel);
        layout.setColumnData((Widget)background, (ColumnLayoutData)new ColumnPixelData(30, false));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        TableColumn fontStyle = new TableColumn(table, 0);
        fontStyle.setResizable(false);
        fontStyle.setText(Messages.ThemePreferencePage_FontStyleColumnLabel);
        layout.setColumnData((Widget)fontStyle, (ColumnLayoutData)new ColumnPixelData(75, false));
        Composite editTokenList = new Composite(composite, 0);
        editTokenList.setLayoutData((Object)new GridData(768));
        GridLayout grid = new GridLayout(2, false);
        editTokenList.setLayout((Layout)grid);
        Composite buttons = new Composite(editTokenList, 0);
        GridLayout buttonsLayout = new GridLayout(2, true);
        buttonsLayout.marginWidth = 0;
        buttonsLayout.horizontalSpacing = 0;
        buttons.setLayout((Layout)buttonsLayout);
        this.fAddTokenButton = new Button(buttons, 0x800008);
        this.fAddTokenButton.setBounds(0, 0, 16, 16);
        this.fAddTokenButton.setLayoutData((Object)new GridData(1808));
        this.fAddTokenButton.setText(Messages.ThemePreferencePage_AddTokenLabel);
        this.fAddTokenButton.addSelectionListener((SelectionListener)this);
        this.fRemoveTokenButton = new Button(buttons, 0x800008);
        this.fRemoveTokenButton.setLayoutData((Object)new GridData(1808));
        this.fRemoveTokenButton.setText(Messages.ThemePreferencePage_RemoveTokenLabel);
        this.fRemoveTokenButton.addSelectionListener((SelectionListener)this);
        Composite textField = new Composite(editTokenList, 0);
        textField.setLayoutData((Object)new GridData(768));
        textField.setLayout((Layout)new GridLayout(2, false));
        Label addTokenLabel = new Label(textField, 131072);
        addTokenLabel.setText(Messages.ThemePreferencePage_ScopeSelectoreLabel);
        this.fScopeText = new Combo(textField, 2052);
        GridData data = new GridData(768);
        this.fScopeText.setLayoutData((Object)data);
        for (String preset : tokenTypeNames) {
            this.fScopeText.add(preset);
        }
        table.addSelectionListener((SelectionListener)this);
        this.fScopeSelectorDecoration = new ControlDecoration((Control)this.fScopeText, 131072);
        this.fScopeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableItem[] selection = table.getSelection();
                if (selection == null || selection.length == 0) {
                    return;
                }
                TableItem item = selection[0];
                ThemeRule rule = (ThemeRule)item.getData();
                String scopeSelectorText = ThemePreferencePage.this.fScopeText.getText();
                ScopeSelector selector = new ScopeSelector(scopeSelectorText);
                ThemeRule match = ThemePreferencePage.this.getTheme().getRuleForSelector((IScopeSelector)selector);
                if (scopeSelectorText.length() > 0 && match != null && match != rule) {
                    FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                    ThemePreferencePage.this.fScopeSelectorDecoration.setImage(dec.getImage());
                    ThemePreferencePage.this.fScopeSelectorDecoration.setDescriptionText(MessageFormat.format(Messages.ThemePreferencePage_DuplicateScopeSelectorRules, match.getName()));
                    ThemePreferencePage.this.fScopeText.setForeground(Display.getDefault().getSystemColor(3));
                } else {
                    ThemePreferencePage.this.fScopeSelectorDecoration.setDescriptionText(null);
                    ThemePreferencePage.this.fScopeSelectorDecoration.setImage(null);
                    ThemePreferencePage.this.fScopeText.setForeground(null);
                }
                int index = table.indexOf(item);
                ThemeRule newRule = rule.setScopeSelector(selector);
                ThemePreferencePage.this.getTheme().updateRule(index, newRule);
                item.setData((Object)newRule);
            }
        });
        this.addDNDToTable(table);
    }

    private void addDNDToTable(final Table table) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)table, 2);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                ThemePreferencePage.this.reorderingRules = true;
                super.dragStart(event);
            }

            public void dragFinished(DragSourceEvent event) {
                ThemePreferencePage.this.reorderingRules = false;
                super.dragFinished(event);
            }

            public void dragSetData(DragSourceEvent event) {
                DragSource ds = (DragSource)event.widget;
                Table table = (Table)ds.getControl();
                int selected = table.getSelectionIndex();
                event.data = Integer.toString(selected);
            }
        });
        DropTarget target = new DropTarget((Control)table, 2);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = ThemePreferencePage.this.reorderingRules ? 14 : 8;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String data = (String)event.data;
                    if (data.startsWith("button:")) {
                        String[] parts = data.split(":");
                        int row = Integer.parseInt(parts[1]);
                        int fgBg = Integer.parseInt(parts[2]);
                        TableItem item = table.getItem(row);
                        Rectangle bounds = item.getBounds(fgBg);
                        if ((bounds = event.display.map((Control)table, null, bounds)).contains(event.x, event.y)) {
                            return;
                        }
                        ThemeRule rule = (ThemeRule)item.getData();
                        if (fgBg == 1) {
                            ThemePreferencePage.this.getTheme().updateRule(row, rule.updateFG(null));
                        } else {
                            ThemePreferencePage.this.getTheme().updateRule(row, rule.updateBG(null));
                        }
                        ThemePreferencePage.this.tableViewer.refresh(true);
                        event.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ThemePreferencePage.this.addCustomTableEditorControls();
                            }
                        });
                        return;
                    }
                    DropTarget target = (DropTarget)event.widget;
                    Table table2 = (Table)target.getControl();
                    int selectionIndex = Integer.parseInt(data);
                    TableItem item = (TableItem)event.item;
                    int insertionIndex = table2.indexOf(item);
                    ThemePreferencePage.this.getTheme().reorderRule(selectionIndex, insertionIndex);
                    ThemePreferencePage.this.tableViewer.refresh(true);
                    ThemePreferencePage.this.addCustomTableEditorControls();
                }
            }
        });
    }

    protected Font lazyFont(Font font, int style) {
        Font returnFont;
        if (this.fFonts == null) {
            this.fFonts = new HashMap();
        }
        if ((returnFont = this.fFonts.get(style)) == null) {
            returnFont = new Font(font.getDevice(), font.getFontData()[0].getName(), font.getFontData()[0].getHeight(), style);
            this.fFonts.put(style, returnFont);
        }
        return returnFont;
    }

    protected void setTheme(Theme newTheme) {
        this.fSelectedTheme = newTheme;
        newTheme.save(false);
        Theme theme = this.getTheme();
        this.fgSelector.setColorValue(theme.getForeground());
        this.bgSelector.setColorValue(theme.getBackground());
        this.lineHighlightSelector.setColorValue(theme.getLineHighlight().toRGB());
        this.caretSelector.setColorValue(theme.getCaret());
        this.tabSelector.setColorValue(theme.getTabcolor());
        this.selectionSelector.setColorValue(theme.getSelection().toRGB());
        this.fThemeCombo.setText(theme.getName());
        this.tableViewer.setInput((Object)theme);
        this.addCustomTableEditorControls();
        if (this.getThemeManager().isBuiltinTheme(theme.getName())) {
            this.renameThemeButton.setEnabled(false);
            this.deleteThemeButton.setEnabled(false);
        } else {
            this.renameThemeButton.setEnabled(true);
            this.deleteThemeButton.setEnabled(true);
        }
    }

    private void addCustomTableEditorControls() {
        this.clearTableEditors();
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            ThemeRule rule = (ThemeRule)items[i].getData();
            if (rule.getTextAttribute().foreground != null) {
                this.createButton(table, items[i], 1, rule.getTextAttribute().foreground);
            }
            if (rule.getTextAttribute().background != null) {
                this.createButton(table, items[i], 2, rule.getTextAttribute().background);
            }
            this.createFontStyle(table, items[i], rule.getTextAttribute());
            ++i;
        }
    }

    private void clearTableEditors() {
        if (this.fTableEditors == null) {
            this.fTableEditors = new HashSet<TableEditor>();
        }
        for (TableEditor tableEditor : this.fTableEditors) {
            tableEditor.getEditor().dispose();
            tableEditor.dispose();
        }
        this.fTableEditors.clear();
    }

    private void createFontStyle(final Table table, final TableItem item, DelayedTextAttribute text) {
        boolean isBold = (text.style & 1) != 0;
        boolean isItalic = (text.style & 2) != 0;
        boolean isUnderline = (text.style & 0x40000000) != 0;
        TableEditor editor = new TableEditor(table);
        Composite buttons = new Composite((Composite)table, 0);
        GridLayout grid = new GridLayout(3, true);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 0;
        buttons.setLayout((Layout)grid);
        final Button b = new Button(buttons, 0x800002);
        b.setText(Messages.ThemePreferencePage_BoldButtonLabel);
        b.setSelection(isBold);
        b.setSize(16, 16);
        b.setLayoutData((Object)new GridData(1808));
        final Button italic = new Button(buttons, 0x800002);
        italic.setText(Messages.ThemePreferencePage_ItalicButtonLabel);
        italic.setSelection(isItalic);
        italic.setLayoutData((Object)new GridData(1808));
        italic.setSize(16, 16);
        final Button u = new Button(buttons, 0x800002);
        u.setText(Messages.ThemePreferencePage_UnderlineButtonLabel);
        u.setSelection(isUnderline);
        u.setLayoutData((Object)new GridData(1808));
        u.setSize(16, 16);
        buttons.pack();
        editor.minimumWidth = buttons.getSize().x;
        editor.horizontalAlignment = 16384;
        editor.setEditor((Control)buttons, item, 3);
        this.fTableEditors.add(editor);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemeRule token = (ThemeRule)item.getData();
                int style = 0;
                if (u.getSelection()) {
                    style |= 0x40000000;
                }
                if (b.getSelection()) {
                    style |= 1;
                }
                if (italic.getSelection()) {
                    style |= 2;
                }
                int index = table.indexOf(item);
                ThemePreferencePage.this.getTheme().updateRule(index, token.updateFontStyle(style));
                ThemePreferencePage.this.tableViewer.refresh();
            }
        };
        b.addSelectionListener((SelectionListener)selectionAdapter);
        italic.addSelectionListener((SelectionListener)selectionAdapter);
        u.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createButton(final Table table, final TableItem tableItem, final int index, final RGBa color) {
        TableEditor editor = new TableEditor(table);
        Button button = new Button((Composite)table, 0x800008);
        Image image = this.createColorImage(table, color);
        button.setImage(image);
        button.pack();
        editor.minimumWidth = button.getSize().x - 4;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)button, tableItem, index);
        this.fTableEditors.add(editor);
        button.setData("color", (Object)color);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(table.getShell());
                Button self = (Button)e.widget;
                RGBa theColor = (RGBa)self.getData("color");
                if (theColor == null) {
                    theColor = color;
                }
                colorDialog.setRGB(theColor.toRGB());
                RGB newRGB = colorDialog.open();
                if (newRGB == null) {
                    return;
                }
                ThemeRule token = (ThemeRule)tableItem.getData();
                RGBa newColor = new RGBa(newRGB);
                if (index == 1) {
                    ThemePreferencePage.this.getTheme().updateRule(table.indexOf(tableItem), token.updateFG(newColor));
                } else {
                    ThemePreferencePage.this.getTheme().updateRule(table.indexOf(tableItem), token.updateBG(newColor));
                }
                self.setImage(ThemePreferencePage.this.createColorImage(table, newColor));
                self.setData("color", (Object)newColor);
                ThemePreferencePage.this.tableViewer.refresh();
            }
        });
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)button, 2);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = "button:" + table.indexOf(tableItem) + ":" + index;
            }
        });
    }

    protected Image createColorImage(Table table, RGBa color) {
        Image image = new Image((Device)table.getDisplay(), 16, 16);
        GC gc = new GC((Drawable)image);
        if (color != null) {
            gc.setBackground(ThemePlugin.getDefault().getColorManager().getColor(color.toRGB()));
        }
        gc.fillRectangle(0, 0, 16, 16);
        gc.dispose();
        return image;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.performOkFonts();
        this.getTheme().save(false);
        this.getThemeManager().setCurrentTheme(this.getTheme());
        this.getThemeManager().postChangeEvent(this.getTheme(), this.fFont);
        return super.performOk();
    }

    protected void performOkFonts() {
        String[] fontIds = new String[]{"org.eclipse.jface.textfont", "org.eclipse.ui.workbench.texteditor.blockSelectionModeFont"};
        FontData[] data = this.fFont.getFontData();
        String[] stringArray = fontIds;
        int n = fontIds.length;
        int n2 = 0;
        while (n2 < n) {
            String fontId = stringArray[n2];
            this.setFont(fontId, data);
            ++n2;
        }
        data = this.fFont.getFontData();
        FontData[] smaller = new FontData[data.length];
        int i = 0;
        FontData[] fontDataArray = data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            FontData fd = fontDataArray[n4];
            int height = fd.getHeight();
            if (height >= 12) {
                fd.setHeight(height - 2);
            } else if (height >= 10) {
                fd.setHeight(height - 1);
            }
            smaller[i++] = fd;
            ++n4;
        }
        this.setFont("com.aptana.explorer.font", smaller);
    }

    private void setFont(String fontId, FontData[] data) {
        String fdString = PreferenceConverter.getStoredRepresentation((FontData[])data);
        Font existing = JFaceResources.getFont((String)fontId);
        String existingString = "";
        if (!existing.isDisposed()) {
            existingString = PreferenceConverter.getStoredRepresentation((FontData[])existing.getFontData());
        }
        if (!existingString.equals(fdString)) {
            JFaceResources.getFontRegistry().put(fontId, data);
            ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            String key = ThemeElementHelper.createPreferenceKey((ITheme)currentTheme, (String)fontId);
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.setValue(key, fdString);
        }
    }

    protected void performDefaults() {
        this.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        try {
            Theme theme = this.getTheme();
            theme.loadFromDefaults();
            this.setTheme(this.fSelectedTheme);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
        super.performDefaults();
    }

    protected Theme getTheme() {
        return this.fSelectedTheme;
    }

    public void dispose() {
        if (this.fFonts != null) {
            for (Font font : this.fFonts.values()) {
                font.dispose();
            }
            this.fFonts.clear();
            this.fFonts = null;
        }
        this.fFont = null;
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fInvasiveThemeCheckbox) {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
            prefs.putBoolean("enable_invasive_themes", this.fInvasiveThemeCheckbox.getSelection());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e1) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e1);
            }
        } else if (source == this.fAptanaEditorsOnlyCheckbox) {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
            prefs.putBoolean("apply_to_all_editors", this.fAptanaEditorsOnlyCheckbox.getSelection());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e1) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e1);
            }
        } else if (source == this.fInvasiveFontCheckbox) {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
            prefs.putBoolean("enable_invasive_font", this.fInvasiveFontCheckbox.getSelection());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e1) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e1);
            }
        } else if (source == this.fThemeCombo) {
            this.setTheme(this.fThemeCombo.getText());
        } else if (source == this.fAddThemeButton) {
            InputDialog dialog = new InputDialog(this.getShell(), Messages.ThemePreferencePage_NewThemeTitle, Messages.ThemePreferencePage_NewThemeMsg, this.getUniqueNewThemeName(this.fSelectedTheme.getName()), (IInputValidator)this);
            if (dialog.open() == 0) {
                Theme newTheme = this.getTheme().copy(dialog.getValue());
                this.getThemeManager().setCurrentTheme(newTheme);
                this.loadThemeNames();
                this.setTheme(newTheme.getName());
            }
        } else if (source == this.renameThemeButton) {
            InputDialog dialog = new InputDialog(this.getShell(), Messages.ThemePreferencePage_RenameThemeTitle, Messages.ThemePreferencePage_RenameThemeMsg, this.fSelectedTheme.getName(), (IInputValidator)this);
            if (dialog.open() == 0) {
                Theme oldTheme = this.getTheme();
                Theme newTheme = oldTheme.copy(dialog.getValue());
                this.getThemeManager().setCurrentTheme(newTheme);
                oldTheme.delete();
                this.loadThemeNames();
                this.setTheme(newTheme.getName());
            }
        } else if (source == this.deleteThemeButton) {
            boolean ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)MessageFormat.format(Messages.ThemePreferencePage_DeleteThemeTitle, this.fSelectedTheme.getName()), (String)MessageFormat.format(Messages.ThemePreferencePage_DeleteThemeMsg, this.fSelectedTheme.getName()));
            if (ok) {
                this.getTheme().delete();
                this.loadThemeNames();
                this.setTheme(this.getThemeManager().getCurrentTheme().getName());
            }
        } else if (source == this.fImportButton) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            IDialogSettings editorSettings = ThemePlugin.getDefault().getDialogSettings();
            String value = editorSettings.get(THEME_DIRECTORY);
            if (value != null) {
                fileDialog.setFilterPath(value);
            }
            fileDialog.setFilterExtensions(new String[]{"*.tmTheme"});
            String path = fileDialog.open();
            if (path == null) {
                return;
            }
            File themeFile = new File(path);
            editorSettings.put(THEME_DIRECTORY, themeFile.getParent());
            Theme theme = new TextmateImporter().convert(themeFile);
            if (theme != null) {
                this.getThemeManager().addTheme(theme);
                this.getThemeManager().setCurrentTheme(theme);
                this.loadThemeNames();
                this.setTheme(theme.getName());
            }
        } else if (source == this.fExportButton) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            IDialogSettings editorSettings = ThemePlugin.getDefault().getDialogSettings();
            String value = editorSettings.get(THEME_EXPORT_DIRECTORY);
            if (value != null) {
                fileDialog.setFilterPath(value);
            }
            fileDialog.setFileName(String.valueOf(this.getTheme().getName()) + ".tmTheme");
            String path = fileDialog.open();
            if (path == null) {
                return;
            }
            File themeFile = new File(path);
            editorSettings.put(THEME_EXPORT_DIRECTORY, themeFile.getParent());
            new ThemeExporter().export(themeFile, this.getTheme());
        } else if (source == this.fAddTokenButton) {
            Theme theme = this.getTheme();
            String newName = "untitled";
            int index = this.tableViewer.getTable().getSelectionIndex();
            index = index == -1 ? this.tableViewer.getTable().getItemCount() : ++index;
            theme.addNewDefaultToken(index, newName);
            this.setTheme(this.fSelectedTheme);
            Object newElement = this.tableViewer.getElementAt(index);
            if (newElement != null) {
                this.tableViewer.editElement(newElement, 0);
                this.fScopeText.setText("");
            }
        } else if (source == this.fRemoveTokenButton) {
            TableItem[] items = this.tableViewer.getTable().getSelection();
            if (items == null || items.length == 0) {
                return;
            }
            Theme theme = this.getTheme();
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                ThemeRule entry = (ThemeRule)tableItem.getData();
                theme.remove(entry);
                ++n2;
            }
            theme.save(false);
            this.setTheme(this.fSelectedTheme);
        } else if (source == this.tableViewer.getTable()) {
            TableItem item = (TableItem)e.item;
            ThemeRule token = (ThemeRule)item.getData();
            this.fScopeText.setText(token.getScopeSelector().toString());
        }
    }

    private String getUniqueNewThemeName(String themeName) {
        String newName = MessageFormat.format(Messages.ThemePreferencePage_NewThemeDefaultName, themeName);
        int index = 2;
        while (this.getThemeManager().getTheme(newName) != null) {
            newName = MessageFormat.format(Messages.ThemePreferencePage_NewThemeDefaultName_2, index++, themeName);
        }
        return newName;
    }

    private void setTheme(String text) {
        this.setTheme(this.getThemeManager().getTheme(text));
    }

    public String isValid(String newText) {
        IStatus status = this.getThemeManager().validateThemeName(newText);
        if (status.isOK()) {
            return null;
        }
        return status.getMessage();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value = event.getNewValue();
        if (value == null) {
            return;
        }
        RGB newColor = (RGB)value;
        Theme theme = this.getTheme();
        Object source = event.getSource();
        if (source == this.fgSelector) {
            theme.updateFG(newColor);
        } else if (source == this.selectionSelector) {
            theme.updateSelection(newColor);
        } else if (source == this.bgSelector) {
            theme.updateBG(newColor);
        } else if (source == this.lineHighlightSelector) {
            theme.updateLineHighlight(newColor);
        } else if (source == this.caretSelector) {
            theme.updateCaret(newColor);
        } else if (source == this.tabSelector) {
            theme.updateTabcolor(newColor);
        }
        this.setTheme(this.fSelectedTheme);
    }

    protected void setFont(Font font) {
        if (this.fFont.equals((Object)font)) {
            return;
        }
        this.fFont = font;
        this.fFontText.setFont(this.fFont);
        this.fFontText.setText(ThemePreferencePage.toString(this.fFont));
        if (this.fFonts != null) {
            this.fFonts.clear();
        }
        this.tableViewer.refresh();
    }

    static class TokenLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        TokenLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ThemeRule commit = (ThemeRule)element;
            if (commit == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return commit.getName();
                }
                case 1: {
                    return commit.getTextAttribute().foreground == null ? "" : commit.getTextAttribute().foreground.toString();
                }
                case 2: {
                    return commit.getTextAttribute().background == null ? "" : commit.getTextAttribute().background.toString();
                }
            }
            return "";
        }
    }
}

