/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemer;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;

class ControlThemer
implements IControlThemer {
    protected static final boolean isWindows = PlatformUtil.isWindows();
    protected static final boolean isMacOSX = PlatformUtil.isMac();
    protected static final boolean isCocoa = Platform.getWS().equals("cocoa");
    protected static final boolean isUbuntu = PlatformUtil.isOSName((String)"Ubuntu");
    private Control control;
    private Color defaultBg;
    private Listener selectionOverride;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;

    public ControlThemer(Control control) {
        this(control, null);
    }

    public ControlThemer(Control control, Color defaultBg) {
        this.control = control;
        this.defaultBg = defaultBg;
    }

    @Override
    public void apply() {
        this.addThemeChangeListener();
        this.applyTheme();
    }

    protected void applyTheme() {
        if (this.invasiveThemesEnabled() && !this.controlIsDisposed()) {
            this.getControl().setRedraw(false);
            this.applyControlColors();
            this.applyControlFont();
            this.getControl().setRedraw(true);
        }
    }

    protected void applyControlColors() {
        this.getControl().setBackground(this.getBackground());
        this.getControl().setForeground(this.getForeground());
    }

    protected void applyControlFont() {
        if (this.useEditorFont() && !this.controlIsDisposed()) {
            this.getControl().setFont(this.getFont());
        }
    }

    protected boolean controlIsDisposed() {
        Control control = this.getControl();
        if (control == null) {
            return true;
        }
        return control.isDisposed();
    }

    protected boolean invasiveThemesEnabled() {
        return ThemePlugin.applyToViews();
    }

    protected boolean useEditorFont() {
        return Platform.getPreferencesService().getBoolean("com.aptana.theme", "enable_invasive_font", false, null);
    }

    @Override
    public void dispose() {
        this.unapplyTheme();
        this.removeThemeListener();
    }

    protected void unapplyTheme() {
        if (!this.controlIsDisposed()) {
            this.getControl().setRedraw(false);
            this.unapplyControlColors();
            this.unapplyControlFont();
            this.getControl().setRedraw(true);
        }
    }

    protected void unapplyControlColors() {
        this.getControl().setBackground(this.defaultBg);
        this.getControl().setForeground(null);
    }

    protected void unapplyControlFont() {
        if (!this.controlIsDisposed()) {
            if (this.useEditorFont()) {
                this.getControl().setFont(this.getFont());
            } else {
                this.getControl().setFont(null);
            }
        }
    }

    protected Font getFont() {
        Font font = JFaceResources.getFont((String)"com.aptana.explorer.font");
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        return font;
    }

    protected Theme getCurrentTheme() {
        return this.getThemeManager().getCurrentTheme();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected Color getBackground() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getBackground());
    }

    protected Color getForeground() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getForeground());
    }

    protected Color getSelection() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getSelectionAgainstBG());
    }

    protected Color getSelectionFG() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getSelectionFG());
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    protected Control getControl() {
        return this.control;
    }

    protected void addSelectionColorOverride() {
        if (this.controlIsDisposed()) {
            return;
        }
        this.selectionOverride = new Listener(){

            public void handleEvent(Event event) {
                Color controlBG;
                if (!ControlThemer.this.invasiveThemesEnabled()) {
                    return;
                }
                GC gc = event.gc;
                Color oldBackground = gc.getBackground();
                if ((event.detail & 2) != 0) {
                    Scrollable scrollable = (Scrollable)event.widget;
                    Rectangle clientArea = scrollable.getClientArea();
                    gc.setBackground(ControlThemer.this.getSelection());
                    gc.fillRectangle(clientArea.x, event.y, clientArea.width + 2, event.height);
                    event.detail &= 0xFFFFFFFD;
                    event.detail &= 0xFFFFFFF7;
                    gc.setBackground(oldBackground);
                } else if (!isWindows && !isMacOSX && (controlBG = ControlThemer.this.control.getBackground()).getRGB().equals((Object)oldBackground.getRGB())) {
                    gc.setBackground(ControlThemer.this.getBackground());
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                    event.detail &= 0xFFFFFFF7;
                    gc.setBackground(oldBackground);
                }
                gc.setForeground(ControlThemer.this.getForeground());
            }
        };
        this.getControl().addListener(40, this.selectionOverride);
    }

    protected void removeSelectionOverride() {
        if (this.selectionOverride != null && !this.controlIsDisposed()) {
            this.getControl().removeListener(40, this.selectionOverride);
        }
        this.selectionOverride = null;
    }

    private void addThemeChangeListener() {
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    ControlThemer.this.applyTheme();
                } else if (event.getKey().equals("enable_invasive_font")) {
                    if (Boolean.parseBoolean((String)event.getNewValue())) {
                        ControlThemer.this.applyControlFont();
                    } else {
                        ControlThemer.this.unapplyControlFont();
                    }
                } else if (event.getKey().equals("enable_invasive_themes")) {
                    if (Boolean.parseBoolean((String)event.getNewValue())) {
                        ControlThemer.this.applyTheme();
                    } else {
                        ControlThemer.this.unapplyTheme();
                    }
                }
            }
        };
        EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    private void removeThemeListener() {
        if (this.fThemeChangeListener != null) {
            EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
            this.fThemeChangeListener = null;
        }
    }
}

