/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.theme.Theme;
import com.aptana.theme.internal.ControlThemer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class AlphaBlendThemer
extends ControlThemer {
    private int alpha;

    public AlphaBlendThemer(Control control, int alpha, Color defaultBg) {
        super(control, defaultBg);
        this.alpha = alpha;
    }

    @Override
    protected void applyControlColors() {
        super.applyControlColors();
        this.setBlendedColor();
    }

    @Override
    protected void unapplyControlColors() {
        super.unapplyControlColors();
        this.setBlendedColor();
    }

    private void setBlendedColor() {
        if (!this.controlIsDisposed()) {
            Control c = this.getControl();
            c.setForeground(this.getColorManager().getColor(Theme.alphaBlend(c.getBackground().getRGB(), c.getForeground().getRGB(), this.alpha)));
        }
    }
}

