/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.extensions;

import com.aptana.core.logging.IdeLog;
import com.aptana.theme.ConsoleThemer;
import com.aptana.theme.ThemePlugin;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConsoleThemePageParticipant
implements IConsolePageParticipant {
    public static final String THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE = "themeConsoleStreamToColor";
    private ConsoleThemer extension;
    private IPageBookViewPage page;

    public void init(IPageBookViewPage page, IConsole console) {
        TextConsole textConsole;
        Object themeConsoleStreamToColor;
        if (console instanceof TextConsole && (themeConsoleStreamToColor = (textConsole = (TextConsole)console).getAttribute(THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE)) instanceof Map) {
            Map m = (Map)themeConsoleStreamToColor;
            Set entrySet = m.entrySet();
            for (Map.Entry entry : entrySet) {
                if (entry.getKey() instanceof IOConsoleOutputStream && entry.getValue() instanceof String) continue;
                return;
            }
            this.extension = new ConsoleThemer(textConsole, (Map)themeConsoleStreamToColor);
        }
        this.page = page;
    }

    public void activated() {
        if (this.page != null && ThemePlugin.applyToViews()) {
            Control control = this.page.getControl();
            if (control != null && !control.isDisposed()) {
                ThemePlugin.getDefault().getControlThemerFactory().apply(control);
            }
            try {
                if (this.page instanceof IOConsolePage && this.extension != null && this.extension.getConsole() != null && "true".equals(this.extension.getConsole().getAttribute("ATTRIBUTE_NEED_REFLUSH"))) {
                    this.page.getControl().redraw();
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            }
        }
    }

    public void deactivated() {
    }

    public void dispose() {
        if (this.extension != null) {
            this.extension.dispose();
            this.extension = null;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

