/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3.inspect;

import com.pandora.browser.remote.debug.RemoteDebugActivator;
import com.pandora.cef3.inspect.InspectNodeStructure;
import com.pandora.cef3.inspect.InspectNodeStructureListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InspectNodeStructureListenerManager {
    private Set<InspectNodeStructureListener> inspectNodeStructureListeners = new LinkedHashSet<InspectNodeStructureListener>();
    private static InspectNodeStructureListenerManager inspectNodeStructureListenerManager = null;

    private InspectNodeStructureListenerManager() {
    }

    public static InspectNodeStructureListenerManager getInstence() {
        if (inspectNodeStructureListenerManager == null) {
            inspectNodeStructureListenerManager = new InspectNodeStructureListenerManager();
        }
        return inspectNodeStructureListenerManager;
    }

    public void addInspectNodeStructureListener(InspectNodeStructureListener inspectNodeStructureListener) {
        if (inspectNodeStructureListener != null) {
            this.inspectNodeStructureListeners.add(inspectNodeStructureListener);
        }
    }

    public void removeInspectNodeStructureListener(InspectNodeStructureListener inspectNodeStructureListener) {
        if (inspectNodeStructureListener != null) {
            this.inspectNodeStructureListeners.remove(inspectNodeStructureListener);
        }
    }

    public void notifySelectNode(final String nodesStr) {
        Job job = new Job("notify Select Node job"){

            protected IStatus run(IProgressMonitor monitor) {
                if (StringUtil.isNotBlank((String)nodesStr)) {
                    String[] nodes;
                    System.out.println(nodesStr);
                    InspectNodeStructure nodeStructure = new InspectNodeStructure();
                    String[] stringArray = nodes = nodesStr.split(" ");
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String node = stringArray[n2];
                        if (node.matches("[a-zA-Z]+.*")) {
                            if (node.contains(":")) {
                                String[] nameAndNum = node.split(":");
                                if (nameAndNum.length > 1) {
                                    nodeStructure.addNode(nameAndNum[0], Integer.parseInt(nameAndNum[1]));
                                } else {
                                    nodeStructure.addNode(nameAndNum[0], 0);
                                }
                            } else {
                                nodeStructure.addNode(node, 0);
                            }
                        }
                        ++n2;
                    }
                    if (nodeStructure.getSize() > 0) {
                        for (InspectNodeStructureListener listener : InspectNodeStructureListenerManager.this.inspectNodeStructureListeners) {
                            try {
                                listener.notify(nodeStructure);
                            }
                            catch (Throwable e) {
                                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                            }
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

