/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

final class MenuHandler
extends CefContextMenuHandlerAdapter {
    private final CEF3Browser browser;

    public MenuHandler(CEF3Browser browser) {
        this.browser = browser;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser cefBrowser, CefContextMenuParams params, CefMenuModel model) {
        if (this.browser.isDevTools(cefBrowser)) {
            return;
        }
        if (!this.browser.enableDefaultMenu()) {
            model.clear();
        } else {
            LinkedHashMap<Integer, String> commandIds = new LinkedHashMap<Integer, String>();
            HashMap<Integer, Boolean> commandEnables = new HashMap<Integer, Boolean>();
            int i = 0;
            while (i < model.getCount()) {
                int commandId = model.getCommandIdAt(i);
                switch (commandId) {
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        commandIds.put(commandId, model.getLabel(commandId));
                        commandEnables.put(commandId, model.isEnabled(commandId));
                    }
                }
                ++i;
            }
            model.clear();
            if (!commandIds.isEmpty()) {
                Iterator iterator = commandIds.keySet().iterator();
                while (iterator.hasNext()) {
                    int commandId = (Integer)iterator.next();
                    model.addItem(commandId, (String)commandIds.get(commandId));
                    model.setEnabled(commandId, (Boolean)commandEnables.get(commandId));
                }
                model.addSeparator();
            }
            model.addItem(100, "\u8fd4\u56de(&B)");
            model.addItem(101, "\u524d\u8fdb(&F)");
            model.addItem(102, "\u5237\u65b0(&R)");
            model.setEnabled(100, cefBrowser.canGoBack());
            model.setEnabled(101, cefBrowser.canGoForward());
            if (Platform.inDevelopmentMode() || this.browser.enableDevTools()) {
                model.addSeparator();
                if (this.browser.isDevToolsDialogOpened()) {
                    model.addItem(26500, "\u67e5\u627e\u4ee3\u7801\u4e2d\u5bf9\u5e94dom\u8282\u70b9(&J)");
                }
                model.addItem(28500, "\u6253\u5f00Chrome\u63a7\u5236\u53f0(&N)");
            }
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser cefBrowser, CefContextMenuParams params, int commandId, int eventFlags) {
        if (this.browser.isDevTools(cefBrowser)) {
            return false;
        }
        switch (commandId) {
            case 26500: {
                final int x = params.getXCoord();
                final int y = params.getYCoord();
                Job job = new Job("right mouse inspect Node job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        Point point = new Point(x, y);
                        MenuHandler.this.browser.highlight(point);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
                return true;
            }
            case 28500: {
                Job job = new Job("open dev tools"){

                    protected IStatus run(IProgressMonitor monitor) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MenuHandler.this.browser.openDevTools();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
                return true;
            }
        }
        return false;
    }
}

