/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Widget;

final class LoadHandler
extends CefLoadHandlerAdapter {
    public static final int TOTAL_PROGRESS = 100;
    private final CEF3Browser cef3Browser;
    private int loadStarted = 0;
    private int loadCompleted = 0;
    private int devToolsLoadStarted = 0;
    private int devToolsLoadCompleted = 0;
    private String loadingURL;

    public LoadHandler(CEF3Browser browser) {
        this.cef3Browser = browser;
    }

    @Override
    public void onLoadStart(CefBrowser browser, int frameIdentifer) {
        browser.setZoomLevel(Math.log(PlatformUtil.getDPIScale()) / Math.log(1.2));
        boolean isDevTools = this.cef3Browser.isDevTools(browser);
        if (!isDevTools && frameIdentifer == 1) {
            this.loadingURL = browser.getURL();
        }
        if (isDevTools) {
            ++this.devToolsLoadStarted;
        } else {
            ++this.loadStarted;
        }
    }

    @Override
    public void onLoadEnd(CefBrowser browser, int frameIdentifier, int httpStatusCode) {
        boolean isDevTools = this.cef3Browser.isDevTools(browser);
        if (isDevTools && this.devToolsLoadStarted > 0 || !isDevTools && this.loadStarted > 0) {
            ProgressEvent event = new ProgressEvent((Widget)this.cef3Browser);
            event.total = 100;
            Object object = event.data = isDevTools ? "DEV_TOOLS" : null;
            if (frameIdentifier == 1) {
                event.current = 100;
                if (isDevTools) {
                    this.devToolsLoadCompleted = 0;
                    this.devToolsLoadStarted = 0;
                } else {
                    this.loadCompleted = 0;
                    this.loadStarted = 0;
                }
                this.cef3Browser.notifyListeners((TypedEvent)event);
            } else if (!isDevTools && ++this.loadCompleted < this.loadStarted) {
                event.current = 100 * this.loadCompleted / this.loadStarted;
                this.cef3Browser.notifyListeners((TypedEvent)event);
            } else if (isDevTools && ++this.devToolsLoadCompleted < this.devToolsLoadStarted) {
                event.current = 100 * this.devToolsLoadCompleted / this.devToolsLoadStarted;
                this.cef3Browser.notifyListeners((TypedEvent)event);
            }
        }
        if (!isDevTools && frameIdentifier == 1) {
            this.cef3Browser.setLoadingURL(null);
            if ("data:text/html,chromewebdata".equals(browser.getURL())) {
                String url = StringUtil.isBlank((String)this.loadingURL) ? this.cef3Browser.getUrl() : this.loadingURL;
                this.loadingURL = null;
                browser.loadString("<html><body><h1>\u65e0\u6cd5\u8bbf\u95ee\u9875\u9762" + url + "</h1></body></html>", url);
            } else if (this.cef3Browser.getUrl() != null && !this.cef3Browser.getUrl().equalsIgnoreCase(browser.getURL())) {
                this.loadingURL = null;
                browser.loadURL(this.cef3Browser.getUrl());
            }
        }
    }

    @Override
    public void onLoadError(CefBrowser browser, int frameIdentifer, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        if (frameIdentifer == 1) {
            boolean isDevTools = this.cef3Browser.isDevTools(browser);
            if (!isDevTools && !CefLoadHandler.ErrorCode.ERR_NONE.equals(errorText)) {
                this.cef3Browser.setLoadingURL(null);
            }
            ProgressEvent event = new ProgressEvent((Widget)this.cef3Browser);
            event.total = 100;
            event.current = 100;
            event.data = isDevTools ? "DEV_TOOLS" : null;
            this.cef3Browser.notifyListeners((TypedEvent)event);
        }
    }

    @Override
    public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
    }
}

