/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import java.lang.reflect.Array;

public class ListenerList<T> {
    private T[] listeners;
    private Class<T> elementType;

    public ListenerList(Class<T> elementType) {
        this.elementType = elementType;
        this.listeners = (Object[])Array.newInstance(elementType, 0);
    }

    public void add(T listener) {
        Object[] newListeners = (Object[])Array.newInstance(this.elementType, this.listeners.length + 1);
        System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
        newListeners[newListeners.length - 1] = listener;
        this.listeners = newListeners;
    }

    public void remove(T listener) {
        if (this.listeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.listeners.length) {
            if (listener == this.listeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.listeners.length == 1) {
            this.listeners = (Object[])Array.newInstance(this.elementType, 0);
            return;
        }
        Object[] newListeners = (Object[])Array.newInstance(this.elementType, this.listeners.length - 1);
        System.arraycopy(this.listeners, 0, newListeners, 0, index);
        System.arraycopy(this.listeners, index + 1, newListeners, index, this.listeners.length - index - 1);
        this.listeners = newListeners;
    }

    public T[] getListeners() {
        return this.listeners;
    }
}

