/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.CloseWindowEvent;
import com.pandora.cef3.OpenWindowEvent;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.eclipse.swt.events.TypedEvent;

final class LifeSpanHandler
extends CefLifeSpanHandlerAdapter {
    private final CEF3Browser cef3Browser;
    private boolean sentCloseEvent = false;

    public LifeSpanHandler(CEF3Browser browser) {
        this.cef3Browser = browser;
    }

    @Override
    public boolean onBeforePopup(CefBrowser browser, String target_url, String target_frame_name) {
        if (this.cef3Browser.isDevTools(browser)) {
            return false;
        }
        if (this.cef3Browser.isSame(browser)) {
            OpenWindowEvent event = new OpenWindowEvent(this.cef3Browser);
            event.required = true;
            event.location = target_url;
            this.cef3Browser.notifyListeners((TypedEvent)event);
        }
        return true;
    }

    @Override
    public void onAfterCreated(CefBrowser cefBrowser) {
        this.cef3Browser.onCreated(cefBrowser);
    }

    @Override
    public boolean runModal(CefBrowser cefBrowser) {
        return false;
    }

    @Override
    public boolean doClose(CefBrowser cefBrowser) {
        if (this.cef3Browser.isDevTools(cefBrowser)) {
            return false;
        }
        CloseWindowEvent event = new CloseWindowEvent(this.cef3Browser);
        event.browser = this.cef3Browser;
        this.cef3Browser.notifyListeners((TypedEvent)event);
        this.sentCloseEvent = true;
        return event.doit;
    }

    @Override
    public void onBeforeClose(CefBrowser cefBrowser) {
        if (this.cef3Browser.isDevTools(cefBrowser)) {
            return;
        }
        this.cef3Browser.onClose();
        if (this.sentCloseEvent) {
            return;
        }
        CloseWindowEvent event = new CloseWindowEvent(this.cef3Browser);
        event.browser = this.cef3Browser;
        this.cef3Browser.notifyListeners((TypedEvent)event);
    }
}

