/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.misc.BoolRef;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

final class KeyboardHandler
extends CefKeyboardHandlerAdapter
implements FocusListener {
    private final CEF3Browser browser;
    private Stack<Integer> charCodes = new Stack();
    private Map<Integer, Integer> charMaps = new HashMap<Integer, Integer>();
    private List<String> commandIds = Arrays.asList("com.pandora.ui.realdevpPer.command");

    public KeyboardHandler(CEF3Browser browser) {
        this.charMaps.put(16, 131072);
        this.charMaps.put(17, 262144);
        this.charMaps.put(18, 65536);
        this.browser = browser;
        if (this.browser != null) {
            this.browser.addFocusListener(this);
        }
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent cefEvent) {
        if (this.browser.isDevTools(browser)) {
            return false;
        }
        int code = cefEvent.windows_key_code;
        int modifiers = cefEvent.modifiers;
        boolean isSystemKey = cefEvent.is_system_key;
        if (this.charMaps.get(code) != null) {
            if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                this.charCodes.add(this.charMaps.get(code));
            } else if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYUP) {
                this.charCodes.remove(this.charMaps.get(code));
            }
            return true;
        }
        Event event = new Event();
        event.widget = this.browser;
        event.item = this.browser;
        event.character = cefEvent.character;
        event.keyCode = code;
        while (!this.charCodes.isEmpty()) {
            event.stateMask |= this.charCodes.pop().intValue();
        }
        if (Platform.inDevelopmentMode()) {
            if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYDOWN) {
                System.out.println("KEYEVENT_KEYDOWN " + code + " " + modifiers + " " + isSystemKey);
            } else if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYUP) {
                System.out.println("KEYEVENT_KEYUP " + code + " " + modifiers + " " + isSystemKey);
            } else if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_CHAR) {
                System.out.println("KEYEVENT_CHAR " + code + " " + modifiers + " " + isSystemKey);
            } else if (cefEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                System.out.println("KEYEVENT_RAWKEYDOWN " + code + " " + modifiers + " " + isSystemKey);
            }
        }
        if (modifiers > 0) {
            try {
                List keyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes((Event)event);
                if (keyStrokes != null && !keyStrokes.isEmpty()) {
                    ParameterizedCommand parameterizedCommand;
                    KeyStroke keyStroke = (KeyStroke)keyStrokes.get(0);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
                    Binding binding = ((BindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).getPerfectMatch((TriggerSequence)keySequence);
                    if (binding != null && (parameterizedCommand = binding.getParameterizedCommand()) != null && parameterizedCommand.getId() != null && this.commandIds.contains(parameterizedCommand.getId())) {
                        this.browser.notifyEventListeners(1, event);
                    }
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.charCodes.clear();
    }
}

