/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.core.utils.StringUtil;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

final class FocusHandler
extends CefFocusHandlerAdapter {
    private final CEF3Browser cef3Browser;

    public FocusHandler(CEF3Browser browser) {
        this.cef3Browser = browser;
    }

    @Override
    public void onTakeFocus(CefBrowser cefBrowser, final boolean next) {
        if (this.cef3Browser.isDevTools(cefBrowser)) {
            return;
        }
        this.cef3Browser.runInUI(new Runnable(){

            @Override
            public void run() {
                FocusHandler.this.cef3Browser.traverse(next ? 16 : 8);
            }
        });
    }

    @Override
    public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
        if (browser == null || this.cef3Browser.getCefBrowser() != browser || this.cef3Browser.isDevTools(browser)) {
            if (StringUtil.isBlank((String)browser.getURL())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FocusHandler.this.cef3Browser.getShell().setActive();
                    }
                });
            }
            return true;
        }
        Event event = new Event();
        event.widget = this.cef3Browser;
        this.cef3Browser.notifyEventListeners(15, event);
        return true;
    }

    @Override
    public void onGotFocus(CefBrowser browser) {
        super.onGotFocus(browser);
    }
}

