/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.awt.Frame;
import org.cef.browser.CefBrowser;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DevToolsDialog {
    private CefBrowser devTools_;
    private Control browser;
    private CefBrowser cefBrowser;
    private Shell shell;

    public DevToolsDialog(Control browser, CefBrowser cefBrowser) {
        this.browser = browser;
        this.cefBrowser = cefBrowser;
    }

    public void createContent() {
        if (this.browser == null || this.cefBrowser == null || this.shell != null && !this.shell.isDisposed()) {
            return;
        }
        this.devTools_ = this.cefBrowser.getDevTools();
        this.shell = new Shell(this.browser.getShell(), 525556);
        this.shell.setText("\u63a7\u5236\u53f0");
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setImage(Window.getDefaultImage());
        this.shell.setSize(400, 400);
        this.shell.setLocation(this.browser.getShell().getLocation().x + 200, this.browser.getShell().getLocation().y + 200);
        Composite comp = new Composite((Composite)this.shell, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)comp);
        frame.add(this.devTools_.getUIComponent());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DevToolsDialog.this.devTools_.close();
                DevToolsDialog.this.devTools_ = null;
            }
        });
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DevToolsDialog.this.shell.dispose();
            }
        });
    }

    public void open(boolean transparent) {
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                if (transparent) {
                    this.shell.setAlpha(0);
                }
                this.shell.layout();
                this.shell.setVisible(true);
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public boolean isDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    public boolean isVisible() {
        return this.shell != null && this.shell.isVisible() && this.shell.getAlpha() != 0;
    }

    public void setVisible() {
        if (this.shell != null) {
            this.shell.setAlpha(255);
            this.shell.setVisible(true);
        }
    }

    public boolean isMinimized() {
        return this.shell != null && this.shell.getMinimized();
    }

    public void setMinimized(boolean minimized) {
        if (this.shell != null) {
            this.shell.setMinimized(minimized);
        }
    }

    public void setFocus() {
        if (this.shell != null) {
            this.shell.setFocus();
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public CefBrowser getDevToolsBrowser() {
        return this.devTools_;
    }
}

