/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.BrowserFunction;
import com.pandora.cef3.BrowserFunctionCallback;
import com.pandora.cef3.BrowserFunctionRouterHandler;
import com.pandora.cef3.CloseWindowEvent;
import com.pandora.cef3.DevToolsDialog;
import com.pandora.cef3.DeviceScreen;
import com.pandora.cef3.DisplayHandler;
import com.pandora.cef3.FocusHandler;
import com.pandora.cef3.JSDialogHandler;
import com.pandora.cef3.KeyboardHandler;
import com.pandora.cef3.LifeSpanHandler;
import com.pandora.cef3.ListenerList;
import com.pandora.cef3.LoadHandler;
import com.pandora.cef3.LocationChangingEvent;
import com.pandora.cef3.MenuHandler;
import com.pandora.cef3.OSHelper;
import com.pandora.cef3.OpenWindowEvent;
import com.pandora.cef3.RequestHandler;
import com.pandora.cef3.inspect.InspectNodeStructureListenerManager;
import com.pandora.cef3.listener.ConsoleMessageEvent;
import com.pandora.cef3.listener.ConsoleMessageListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.StringUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefStringVisitor;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public final class CEF3Browser
extends Composite {
    static final String URL_BLANK = "about:blank";
    private static final String URL_TEXT = "html:internal";
    private static final String URL_SCRIPT = "javascript:";
    public static final String DEV_TOOLS_DATA = "DEV_TOOLS";
    private static final String ERROR_ID = "com.hbuilder.swt.cef3.error";
    private static boolean hasCreateBrowser = false;
    private static Shell defaultBrowser;
    private Set<ShellListener> devToolShellListeners = new HashSet<ShellListener>();
    private CefClient browserClient;
    private CefBrowser cefBrowser;
    private CefBrowser devCefBrowser;
    private BrowserFunctionRouterHandler browserFunctionRouterHandler;
    private String loadURL;
    private String loadText;
    private CefRequest loadRequest;
    private static int remoteDebuggingPort;
    private boolean devToolsInited = false;
    boolean enableLoad = true;
    private boolean enableDefaultMenu = true;
    private boolean enableDevTools;
    private boolean initDevToolsDialogSize;
    private DevToolsDialog devToolsDialog = null;
    private DeviceScreen deviceScreen = DeviceScreen.DEFAULT;
    private String loadingURL = null;
    private ListenerList<CloseWindowListener> closeWindowListeners = new ListenerList<CloseWindowListener>(CloseWindowListener.class);
    private ListenerList<LocationListener> locationListeners = new ListenerList<LocationListener>(LocationListener.class);
    private ListenerList<OpenWindowListener> openWindowListeners = new ListenerList<OpenWindowListener>(OpenWindowListener.class);
    private ListenerList<ProgressListener> progressListeners = new ListenerList<ProgressListener>(ProgressListener.class);
    private ListenerList<ProgressListener> devToolsProgressListeners = new ListenerList<ProgressListener>(ProgressListener.class);
    private ListenerList<StatusTextListener> statusTextListeners = new ListenerList<StatusTextListener>(StatusTextListener.class);
    private ListenerList<TitleListener> titleListeners = new ListenerList<TitleListener>(TitleListener.class);
    private ListenerList<ConsoleMessageListener> consoleMessageListeners = new ListenerList<ConsoleMessageListener>(ConsoleMessageListener.class);
    private static boolean hasInited;

    static {
        remoteDebuggingPort = -1;
        hasInited = false;
    }

    public CEF3Browser(Composite parent, int style) {
        this(parent, style, null);
    }

    public CEF3Browser(Composite parent, int style, DeviceScreen deviceScreen) {
        super(parent, 0x1000000);
        this.deviceScreen = deviceScreen;
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.init(true);
    }

    private CEF3Browser(Composite parent) {
        super(parent, 0x1000000);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.init(false);
    }

    protected void checkWidget() {
        super.checkWidget();
    }

    public int getRemoteDebuggingPort() {
        return remoteDebuggingPort;
    }

    boolean isSame(CefBrowser cefBrowser) {
        return this.cefBrowser == null || !this.cefBrowser.equals(cefBrowser);
    }

    private void createBrowser() {
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.cefBrowser = this.browserClient.createBrowser(this.loadURL, OS.isLinux(), false);
        frame.add(this.cefBrowser.getUIComponent());
    }

    void createFunction(BrowserFunction function) {
        this.registerFunction(function);
    }

    void destroyFunction(BrowserFunction function) {
        this.deregisterFunction(function);
    }

    private void registerFunction(BrowserFunction function) {
        this.browserFunctionRouterHandler.addBrowserFunction(function);
    }

    private void deregisterFunction(BrowserFunction function) {
        this.browserFunctionRouterHandler.removeBrowserFunction(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCEF() {
        String string = ERROR_ID;
        synchronized (ERROR_ID) {
            if (!hasInited) {
                CefApp.getInstance(new String[]{"-log-severity=disable", "-lang=zh-CH", "-proxy-server"});
                hasInited = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void init(boolean initListener) {
        CEF3Browser.initCEF();
        if (initListener && (!hasCreateBrowser && defaultBrowser == null || defaultBrowser != null && defaultBrowser.isDisposed())) {
            UIJob job = new UIJob("create default browser"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        defaultBrowser = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 524296);
                        defaultBrowser.setSize(1, 1);
                        defaultBrowser.setLayout((Layout)new FillLayout());
                        new CEF3Browser((Composite)defaultBrowser, null).setUrl(CEF3Browser.URL_BLANK);
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        OSHelper.initJNIPath();
        this.browserClient = CefApp.getInstance().createClient();
        hasCreateBrowser = true;
        if (!initListener) {
            return;
        }
        this.browserClient.addLifeSpanHandler(new LifeSpanHandler(this));
        this.browserClient.addDisplayHandler(new DisplayHandler(this));
        this.browserClient.addLoadHandler(new LoadHandler(this));
        this.browserClient.addFocusHandler(new FocusHandler(this));
        this.browserClient.addContextMenuHandler(new MenuHandler(this));
        this.browserClient.addJSDialogHandler(new JSDialogHandler(this));
        this.browserClient.addKeyboardHandler(new KeyboardHandler(this));
        this.browserClient.addRequestHandler(new RequestHandler(this));
        this.browserFunctionRouterHandler = new BrowserFunctionRouterHandler();
        CefMessageRouter msgRouter = CefMessageRouter.create(this.browserFunctionRouterHandler);
        this.browserClient.addMessageRouter(msgRouter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CEF3Browser.this.onDispose();
                        break;
                    }
                    case 11: {
                        CEF3Browser.this.onResize(CEF3Browser.this.cefBrowser);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(1, listener);
        this.addListener(11, listener);
        this.initDevTools();
    }

    public void initDevTools() {
        try {
            if (!this.enableDevTools || this.devToolsInited) {
                this.enableLoad = true;
                return;
            }
            this.devToolsInited = true;
            this.enableLoad = !DeviceScreen.isMobile(this.deviceScreen);
            this.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    CEF3Browser.this.removeLocationListener(this);
                    final String url = ((LocationChangingEvent)event).location;
                    CEF3Browser.this.devToolsProgressListeners.add(new ProgressListener(){

                        public void completed(ProgressEvent event) {
                            boolean reload = !(this).CEF3Browser.this.enableLoad;
                            (this).CEF3Browser.this.enableLoad = true;
                            CEF3Browser.this.devToolsProgressListeners.remove(this);
                            CEF3Browser.this.devToolsDialog.getShell().setVisible(false);
                            CEF3Browser.this.devToolsDialog.getShell().setAlpha(255);
                            CEF3Browser.this.innerSetDeviceScreen(reload, url);
                        }

                        public void changed(ProgressEvent event) {
                        }
                    });
                    CEF3Browser.this.openDevTools(false);
                }

                public void changed(LocationEvent event) {
                }
            });
            this.registerFunction(new BrowserFunction(this, "__notifySelectNode"){

                @Override
                public void function(Object[] arguments, BrowserFunctionCallback callback) throws Exception {
                    if (arguments != null && arguments.length == 1) {
                        InspectNodeStructureListenerManager.getInstence().notifySelectNode((String)arguments[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void setDeviceScreen(DeviceScreen deviceScreen, boolean reload) {
        if (this.devCefBrowser == null) {
            this.deviceScreen = deviceScreen == null ? DeviceScreen.DEFAULT : deviceScreen;
            return;
        }
        if (Objects.equals(this.deviceScreen, deviceScreen) || this.deviceScreen == DeviceScreen.DEFAULT && deviceScreen == null) {
            return;
        }
        if (DeviceScreen.isMobile(this.deviceScreen) && !DeviceScreen.isMobile(deviceScreen) || !DeviceScreen.isMobile(this.deviceScreen) && DeviceScreen.isMobile(deviceScreen)) {
            reload = true;
        }
        this.deviceScreen = deviceScreen == null ? DeviceScreen.DEFAULT : deviceScreen;
        this.innerSetDeviceScreen(reload, null);
    }

    private void innerSetDeviceScreen(boolean reload, String url) {
        if (this.devCefBrowser == null) {
            return;
        }
        try {
            String script = "(function(){ function __DeviceScreen(){if(!WebInspector.overridesSupport){setTimeout(__DeviceScreen.bind(this), 100)}else{";
            script = this.deviceScreen == null || this.deviceScreen == DeviceScreen.DEFAULT ? String.valueOf(script) + "WebInspector.overridesSupport.reset();" : String.valueOf(script) + "var _metrics = '" + this.deviceScreen.toString() + "', _touch=" + this.deviceScreen.isTouch() + ",_mobile=" + this.deviceScreen.isMobile() + ", _wos = WebInspector.overridesSupport;" + "_wos._deviceMetricsChangedListenerMuted = true;" + "_wos._userAgentChangedListenerMuted = true;" + "WebInspector.settings.deviceMetrics.set(_metrics);" + "WebInspector.settings.overrideDeviceMetrics.set(true);" + "WebInspector.settings.emulateTouchEvents.set(_touch);" + "WebInspector.settings.emulateViewport.set(_mobile);" + "delete _wos._deviceMetricsChangedListenerMuted;" + "_wos._deviceMetricsChanged();";
            if (reload) {
                script = String.valueOf(script) + (StringUtil.isBlank((String)url) ? "WebInspector.console.evaluate('location.reload()');" : "PageAgent.navigate('" + url + "');");
            }
            script = String.valueOf(script) + "}}__DeviceScreen();})()";
            this.devCefBrowser.executeJavaScript(script, URL_SCRIPT, 0);
            return;
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            return;
        }
    }

    public DeviceScreen getDeviceScreen() {
        return this.deviceScreen;
    }

    public void highlight(String selectorStr) {
        if (!this.isDevToolsDialogOpened()) {
            return;
        }
        String script = "WebInspector.domModel.querySelector(WebInspector.domModel._document.id, '" + selectorStr + "', function(nodeid){WebInspector.domModel.highlightDOMNodeForTwoSeconds(nodeid)});";
        this.devCefBrowser.executeJavaScript(script, URL_SCRIPT, 0);
    }

    public void highlight(Point location) {
        if (!this.isDevToolsDialogOpened()) {
            return;
        }
        if (DeviceScreen.isMobile(this.deviceScreen)) {
            boolean heightLess;
            double screenWidth = (double)this.deviceScreen.getWidth() / this.deviceScreen.getDpr();
            double screenHeight = (double)this.deviceScreen.getHeight() / this.deviceScreen.getDpr();
            final Point[] compositeSize = new Point[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    compositeSize[0] = CEF3Browser.this.getSize();
                }
            });
            int border = 20;
            int compositeWidth = compositeSize[0].x;
            int compositeHeight = compositeSize[0].y;
            int compositeWidthWithoutBorder = compositeSize[0].x - border;
            int compositeHeightWithoutBorder = compositeSize[0].y - border;
            boolean widthLess = (double)compositeWidthWithoutBorder < screenWidth;
            boolean bl = heightLess = (double)compositeHeightWithoutBorder < screenHeight;
            if (widthLess || heightLess) {
                double screenWidthScale = screenWidth / screenHeight;
                double compositeWidthScale = (double)compositeWidthWithoutBorder / ((double)compositeHeightWithoutBorder * 1.0);
                if (widthLess && heightLess && screenWidthScale < compositeWidthScale || widthLess && !heightLess) {
                    int newX = (int)((double)(location.x - border / 2) * (screenWidth / (double)compositeWidthWithoutBorder));
                    location.y = (int)(((double)location.y - ((double)compositeHeight - screenHeight * (double)compositeWidthWithoutBorder / screenWidth) / 2.0) * screenWidth / (double)compositeWidthWithoutBorder);
                    location.x = newX;
                } else {
                    int newY = (int)((double)(location.y - border / 2) * (screenHeight / (double)compositeHeightWithoutBorder));
                    location.x = (int)(((double)location.x - ((double)compositeWidth - screenWidth * (double)compositeHeightWithoutBorder / screenHeight) / 2.0) * screenHeight / (double)compositeHeightWithoutBorder);
                    location.y = newY;
                }
            } else {
                location.x = (int)((double)location.x - ((double)compositeWidth - screenWidth) / 2.0);
                location.y = (int)((double)location.y - ((double)compositeHeight - screenHeight) / 2.0);
            }
            if (location.x < 0 || location.y < 0) {
                return;
            }
        }
        String script = "DOMAgent.getNodeForLocation(" + location.x + ", " + location.y + ", function(error, nodeid){" + "var highlight = false;" + "var pn = WebInspector.domModel.nodeForId(nodeid);" + "console.log(pn);" + "if(pn&&pn.parentNode&&pn._nodeName!='#document'){" + "var nodes=null;" + "while(pn._nodeName!='#document'){var name=pn._nodeName;if(pn._isInShadowTree||name.indexOf('<')===0){pn=pn.parentNode;continue;}else if(!highlight){highlight = true;WebInspector.domModel.highlightDOMNodeForTwoSeconds(pn.id);}var num=1;if(pn.parentNode){var childs=pn.parentNode._children;if(childs&&childs.length>1){for(i=0;i<childs.length;i++){if(childs[i]===pn){break}if(childs[i]._nodeName==pn._nodeName){num++}}}};name=(name+':'+(num-1));if(nodes){nodes=name+' '+nodes}else{nodes=name}pn=pn.parentNode};" + "if(nodes){window.cefQuery({request: '__notifySelectNode?'  + nodes});}" + "}})";
        this.devCefBrowser.executeJavaScript(script, URL_SCRIPT, 0);
    }

    private void onDispose() {
        this.browserFunctionRouterHandler.clearBrowserFunction();
    }

    private void onResize(CefBrowser cefBrowser) {
    }

    void onCreated(CefBrowser cefBrowser) {
    }

    void onClose() {
    }

    void notifyEventListeners(final int eventType, final Event event) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CEF3Browser.this.isDisposed()) {
                    return;
                }
                CEF3Browser.this.notifyListeners(eventType, event);
            }
        });
    }

    void runInUI(Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(runnable);
    }

    void notifyListeners(final TypedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CEF3Browser.this.notifyListenersInternal(event);
            }
        });
    }

    private void notifyListenersInternal(TypedEvent event) {
        block15: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        if (this.isDisposed()) {
                                            return;
                                        }
                                        event.display = this.getDisplay();
                                        if (!(event instanceof OpenWindowEvent)) break block14;
                                        OpenWindowEvent openWindowEvent = (OpenWindowEvent)event;
                                        OpenWindowListener[] openWindowListenerArray = this.openWindowListeners.getListeners();
                                        int n = openWindowListenerArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            OpenWindowListener listener = openWindowListenerArray[n2];
                                            listener.open((WindowEvent)openWindowEvent);
                                            ++n2;
                                        }
                                        break block15;
                                    }
                                    if (!(event instanceof CloseWindowEvent)) break block16;
                                    CloseWindowEvent closeWindowEvent = (CloseWindowEvent)event;
                                    CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners.getListeners();
                                    int n = closeWindowListenerArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        CloseWindowListener listener = closeWindowListenerArray[n3];
                                        listener.close((WindowEvent)closeWindowEvent);
                                        ++n3;
                                    }
                                    break block15;
                                }
                                if (!(event instanceof LocationChangingEvent)) break block17;
                                LocationChangingEvent locationEvent = (LocationChangingEvent)event;
                                LocationListener[] locationListenerArray = this.locationListeners.getListeners();
                                int n = locationListenerArray.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    LocationListener listener = locationListenerArray[n4];
                                    listener.changing((LocationEvent)locationEvent);
                                    ++n4;
                                }
                                break block15;
                            }
                            if (!(event instanceof LocationEvent)) break block18;
                            LocationEvent locationEvent = (LocationEvent)event;
                            LocationListener[] locationListenerArray = this.locationListeners.getListeners();
                            int n = locationListenerArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                LocationListener listener = locationListenerArray[n5];
                                try {
                                    listener.changed(locationEvent);
                                }
                                catch (Exception e) {
                                    HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                                }
                                ++n5;
                            }
                            break block15;
                        }
                        if (!(event instanceof TitleEvent)) break block19;
                        TitleEvent titleEvent = (TitleEvent)event;
                        TitleListener[] titleListenerArray = this.titleListeners.getListeners();
                        int n = titleListenerArray.length;
                        int n6 = 0;
                        while (n6 < n) {
                            TitleListener listener = titleListenerArray[n6];
                            listener.changed(titleEvent);
                            ++n6;
                        }
                        break block15;
                    }
                    if (!(event instanceof ProgressEvent)) break block20;
                    ProgressEvent progressEvent = (ProgressEvent)event;
                    ListenerList<ProgressListener> pListeners = null;
                    pListeners = event.data == DEV_TOOLS_DATA ? this.devToolsProgressListeners : this.progressListeners;
                    if (progressEvent.current == progressEvent.total) {
                        ProgressListener[] progressListenerArray = pListeners.getListeners();
                        int n = progressListenerArray.length;
                        int n7 = 0;
                        while (n7 < n) {
                            ProgressListener listener = progressListenerArray[n7];
                            listener.completed(progressEvent);
                            ++n7;
                        }
                    } else {
                        ProgressListener[] progressListenerArray = pListeners.getListeners();
                        int n = progressListenerArray.length;
                        int n8 = 0;
                        while (n8 < n) {
                            ProgressListener listener = progressListenerArray[n8];
                            listener.changed(progressEvent);
                            ++n8;
                        }
                    }
                    break block15;
                }
                if (!(event instanceof StatusTextEvent)) break block21;
                StatusTextEvent statusTextEvent = (StatusTextEvent)event;
                StatusTextListener[] statusTextListenerArray = this.statusTextListeners.getListeners();
                int n = statusTextListenerArray.length;
                int n9 = 0;
                while (n9 < n) {
                    StatusTextListener listener = statusTextListenerArray[n9];
                    listener.changed(statusTextEvent);
                    ++n9;
                }
                break block15;
            }
            if (!(event instanceof ConsoleMessageEvent)) break block15;
            ConsoleMessageEvent consoleMessageEvent = (ConsoleMessageEvent)event;
            ConsoleMessageListener[] consoleMessageListenerArray = this.consoleMessageListeners.getListeners();
            int n = consoleMessageListenerArray.length;
            int n10 = 0;
            while (n10 < n) {
                ConsoleMessageListener listener = consoleMessageListenerArray[n10];
                listener.onConsoleMessage(consoleMessageEvent);
                ++n10;
            }
        }
    }

    public boolean isloading() {
        if (this.cefBrowser != null) {
            return this.cefBrowser.isLoading();
        }
        return false;
    }

    private void prepareLoad() {
        this.initDevTools();
        if (this.cefBrowser == null) {
            this.createBrowser();
        } else if (this.isloading()) {
            this.cefBrowser.stopLoad();
        }
    }

    private void loadURL() {
        this.loadText = null;
        this.loadRequest = null;
        boolean setUrlInInit = this.cefBrowser == null;
        this.prepareLoad();
        if (setUrlInInit) {
            return;
        }
        this.cefBrowser.loadURL(this.loadURL != null ? this.loadURL : URL_BLANK);
    }

    private void loadRequest() {
        this.loadText = null;
        this.loadURL = null;
        this.prepareLoad();
        if (this.cefBrowser != null) {
            this.cefBrowser.loadRequest(this.loadRequest);
            this.loadRequest = null;
        }
    }

    private void loadText() {
        this.loadURL = null;
        this.loadRequest = null;
        this.prepareLoad();
        if (this.cefBrowser != null) {
            this.cefBrowser.loadString(this.loadText, URL_TEXT);
            this.loadText = null;
        }
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeWindowListeners.add(listener);
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.locationListeners.add(listener);
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.openWindowListeners.add(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.progressListeners.add(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.statusTextListeners.add(listener);
    }

    public void addConsoleMessageListener(ConsoleMessageListener listener) {
        this.consoleMessageListeners.add(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.titleListeners.add(listener);
    }

    public boolean back() {
        this.checkWidget();
        if (this.cefBrowser != null && this.cefBrowser.canGoBack()) {
            this.cefBrowser.goBack();
            return true;
        }
        return false;
    }

    public boolean execute(String script) {
        if (script == null) {
            SWT.error((int)4);
        }
        if (this.cefBrowser != null) {
            this.cefBrowser.executeJavaScript(script, URL_SCRIPT, 1);
            return true;
        }
        return false;
    }

    public void dispose() {
        String url;
        if (PlatformUI.getWorkbench().isClosing() && this.cefBrowser != null && StringUtil.isNotEmpty((String)(url = this.cefBrowser.getURL())) && !url.equals(URL_BLANK) && !url.startsWith("data:") && !url.startsWith("chrome-devtools:")) {
            this.setUrl(URL_BLANK);
            int i = 0;
            while (i < 20 && StringUtil.isNotEmpty((String)this.cefBrowser.getURL())) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        if (this.browserClient != null) {
            this.browserClient.dispose();
        }
        super.dispose();
    }

    public boolean forward() {
        this.checkWidget();
        if (this.cefBrowser != null && this.cefBrowser.canGoForward()) {
            this.cefBrowser.goForward();
            return true;
        }
        return false;
    }

    public String getText() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            CefStringVisitor visitor = new CefStringVisitor(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public void visit(String string) {
                    this.builder.append(string);
                }

                public String toString() {
                    return this.builder.toString();
                }
            };
            this.cefBrowser.getSource(visitor);
            return visitor.toString();
        }
        return "";
    }

    public String getUrl() {
        if (this.cefBrowser != null) {
            String url = this.cefBrowser.getURL();
            if (url == null || url.isEmpty() || "data:text/html,chromewebdata".equals(url)) {
                return this.loadURL;
            }
            return url;
        }
        return "";
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return this.cefBrowser != null && this.cefBrowser.canGoBack();
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return this.cefBrowser != null && this.cefBrowser.canGoForward();
    }

    public void refresh() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            if (URL_TEXT.equals(this.cefBrowser.getURL())) {
                this.cefBrowser.loadString(this.getText(), URL_TEXT);
                return;
            }
            this.cefBrowser.reloadIgnoreCache();
        }
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeWindowListeners.remove(listener);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.locationListeners.remove(listener);
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.openWindowListeners.remove(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.progressListeners.remove(listener);
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.statusTextListeners.remove(listener);
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.titleListeners.remove(listener);
    }

    public void setJavascriptEnabled(boolean enabled) {
        this.checkWidget();
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error((int)4);
        }
        this.loadText = html;
        this.loadText();
        return true;
    }

    public boolean setUrl(String url) {
        this.loadURL = url;
        this.loadURL();
        return true;
    }

    public boolean setUrl(String url, String postData, HashMap<String, String> headerMap) {
        this.checkWidget();
        if (url == null) {
            SWT.error((int)4);
        }
        CefRequest request = CefRequest.create();
        request.setURL(url);
        if (postData != null) {
            CefPostData pdata = CefPostData.create();
            CefPostDataElement element = CefPostDataElement.create();
            if (postData.length() > 0) {
                try {
                    byte[] bytes = postData.getBytes("UTF-8");
                    element.setToBytes(bytes.length, bytes);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                element.setToEmpty();
            }
            pdata.addElement(element);
            request.setPostData(pdata);
        }
        if (headerMap != null) {
            request.setHeaderMap(headerMap);
        }
        this.loadRequest = request;
        this.loadRequest();
        return true;
    }

    public void stop() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            this.cefBrowser.stopLoad();
        }
    }

    public CefBrowser getCefBrowser() {
        return this.cefBrowser;
    }

    public void setMenu(Menu menu) {
        this.enableDefaultMenu = menu == null;
        super.setMenu(menu);
    }

    public boolean enableDefaultMenu() {
        return this.enableDefaultMenu;
    }

    public void setEnableDefaultMenu(boolean enableDefaultMenu) {
        this.enableDefaultMenu = enableDefaultMenu;
    }

    public boolean enableDevTools() {
        return this.enableDevTools;
    }

    public void setEnableDevTools(boolean enable) {
        this.enableDevTools = enable;
    }

    public static void closeAll() {
        if (defaultBrowser != null && !defaultBrowser.isDisposed()) {
            defaultBrowser.dispose();
        }
        if (hasCreateBrowser) {
            CefApp.getInstance().dispose();
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void openDevTools() {
        this.openDevTools(true);
    }

    private void openDevTools(final boolean show) {
        if (this.devToolsDialog == null || this.devToolsDialog.isDisposed()) {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CEF3Browser.this.devToolsDialog = new DevToolsDialog((Control)CEF3Browser.this, CEF3Browser.this.getCefBrowser());
                    CEF3Browser.this.devToolsDialog.createContent();
                    for (ShellListener listener : CEF3Browser.this.devToolShellListeners) {
                        if (listener == null) continue;
                        CEF3Browser.this.devToolsDialog.getShell().addShellListener(listener);
                    }
                    CEF3Browser.this.devToolsDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

                        public void shellIconified(ShellEvent e) {
                            e.doit = false;
                            CEF3Browser.this.devToolsDialog.getShell().setVisible(false);
                        }

                        public void shellClosed(ShellEvent e) {
                            e.doit = false;
                            CEF3Browser.this.devToolsDialog.getShell().setVisible(false);
                        }
                    });
                    if (show) {
                        CEF3Browser.this.devToolsDialog.getShell().setSize(800, 600);
                        CEF3Browser.this.initDevToolsDialogSize = true;
                        CEF3Browser.this.devToolsDialog.open(false);
                    } else {
                        CEF3Browser.this.devToolsDialog.getShell().setSize(100, 100);
                        CEF3Browser.this.devToolsDialog.getShell().setLocation(CEF3Browser.this.getShell().getLocation().x + CEF3Browser.this.getShell().getSize().x - 100, CEF3Browser.this.getShell().getLocation().y + CEF3Browser.this.getShell().getSize().y - 100);
                        CEF3Browser.this.devToolsDialog.open(true);
                    }
                    CEF3Browser.this.devCefBrowser = CEF3Browser.this.devToolsDialog.getDevToolsBrowser();
                }
            });
        } else {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (show) {
                            if (!CEF3Browser.this.devToolsDialog.isVisible()) {
                                if (!CEF3Browser.this.initDevToolsDialogSize) {
                                    CEF3Browser.this.initDevToolsDialogSize = true;
                                    CEF3Browser.this.devToolsDialog.getShell().setLocation(CEF3Browser.this.getShell().getLocation().x + 100, CEF3Browser.this.getShell().getLocation().y + 100);
                                    CEF3Browser.this.devToolsDialog.getShell().setSize(800, 600);
                                }
                                CEF3Browser.this.devToolsDialog.setVisible();
                            }
                            if (CEF3Browser.this.devToolsDialog.isMinimized()) {
                                CEF3Browser.this.devToolsDialog.setMinimized(false);
                            } else {
                                CEF3Browser.this.devToolsDialog.setFocus();
                            }
                        }
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            });
        }
    }

    public void addDevToolsDialoglistener(ShellListener listener) {
        if (this.devToolsDialog != null && !this.devToolsDialog.isDisposed()) {
            this.devToolsDialog.getShell().addShellListener(listener);
        }
        if (listener != null) {
            this.devToolShellListeners.add(listener);
        }
    }

    public void removeDevToolsDialoglistener(ShellListener listener) {
        if (listener != null) {
            this.devToolShellListeners.remove(listener);
        }
    }

    public boolean isDevToolsDialogOpened() {
        return this.devToolsDialog != null && !this.devToolsDialog.isDisposed();
    }

    /*
     * Exception decompiling
     */
    public static int findFreePort(int defaultPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getLoadingURL() {
        return this.loadingURL;
    }

    public void setLoadingURL(String loadingURL) {
        this.loadingURL = loadingURL;
    }

    protected boolean isDevTools(CefBrowser browser) {
        return this.isDevTools(browser.getURL()) || browser == this.devCefBrowser;
    }

    protected boolean isDevTools(String url) {
        return "chrome-devtools://devtools/devtools.html".equals(url);
    }

    /* synthetic */ CEF3Browser(Composite composite, CEF3Browser cEF3Browser) {
        this(composite);
    }
}

