/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.BrowserFunction;
import com.pandora.cef3.BrowserFunctionCallback;
import java.util.HashMap;
import java.util.Map;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class BrowserFunctionRouterHandler
extends CefMessageRouterHandlerAdapter {
    private Map<String, BrowserFunction> allFunctions = new HashMap<String, BrowserFunction>();

    public void addBrowserFunction(BrowserFunction browserFunction) {
        if (browserFunction != null) {
            this.allFunctions.put(browserFunction.getName(), browserFunction);
        }
    }

    public void removeBrowserFunction(BrowserFunction browserFunction) {
        if (browserFunction != null) {
            this.allFunctions.remove(browserFunction.getName());
        }
    }

    public BrowserFunction getBrowserFunction(String name) {
        return this.allFunctions.get(name);
    }

    public void clearBrowserFunction() {
        for (BrowserFunction function : this.allFunctions.values()) {
            function.dispose(false);
        }
        this.allFunctions.clear();
    }

    @Override
    public boolean onQuery(CefBrowser browser, long query_id, String request, boolean persistent, CefQueryCallback callback) {
        if (request != null) {
            Object[] arguments = null;
            int s = request.indexOf("?");
            String name = request;
            if (s > 0) {
                name = request.substring(0, s);
                arguments = request.substring(s + 1).split("&");
            }
            BrowserFunction function = this.allFunctions.get(name);
            Object[] argumentsF = arguments;
            if (function != null) {
                try {
                    function.function(argumentsF, new BrowserFunctionCallback(callback));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onQueryCanceled(CefBrowser browser, long query_id) {
        super.onQueryCanceled(browser, query_id);
    }

    public Map<String, BrowserFunction> getAllFunctions() {
        return this.allFunctions;
    }
}

