/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.parsing;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.dtd.text.rules.DTDNameDetector;
import com.aptana.editor.xml.parsing.lexer.XMLTokenType;
import com.aptana.editor.xml.text.rules.XMLAttributeRule;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

class XMLAttributeScanner
extends RuleBasedScanner {
    XMLAttributeScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new MultiLineRule("\"", "\"", this.createToken((Object)XMLTokenType.VALUE), '\\'));
        rules.add(new MultiLineRule("'", "'", this.createToken((Object)XMLTokenType.VALUE), '\\'));
        rules.add((Object)new XMLAttributeRule(this.createToken((Object)XMLTokenType.ATTRIBUTE)));
        rules.add(new WordRule((IWordDetector)new DTDNameDetector(), this.createToken((Object)XMLTokenType.OTHER), true));
        CharacterMapRule characterRule = new CharacterMapRule();
        characterRule.add('<', this.createToken((Object)XMLTokenType.OTHER));
        characterRule.add('>', this.createToken((Object)XMLTokenType.OTHER));
        characterRule.add('=', this.createToken((Object)XMLTokenType.OTHER));
        rules.add(characterRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.createToken((Object)XMLTokenType.OTHER));
    }

    protected IToken createToken(Object data) {
        return new Token(data);
    }

    public String getText() {
        String result = null;
        try {
            result = this.fDocument.get(this.getTokenOffset(), this.getTokenLength());
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }
}

