/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist.model;

import com.aptana.editor.dtd.parsing.ast.DTDAttListDeclNode;
import com.aptana.editor.dtd.parsing.ast.DTDAttributeNode;
import com.aptana.editor.dtd.parsing.ast.DTDElementDeclNode;
import com.aptana.editor.dtd.parsing.ast.DTDParseRootNode;
import com.aptana.editor.dtd.parsing.ast.DTDTreeWalker;
import com.aptana.editor.xml.contentassist.model.AttributeElement;
import com.aptana.editor.xml.contentassist.model.ElementElement;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DTDTransformer {
    private List<ElementElement> _elements;
    private List<AttributeElement> _attributes;

    public void transform(String source) {
        IParseRootNode root = this.parse(source);
        if (root instanceof DTDParseRootNode) {
            NodeCollector collector = new NodeCollector();
            collector.visit((DTDParseRootNode)root);
            this._elements = collector.getElements();
            Collections.sort(this._elements, new Comparator<ElementElement>(){

                @Override
                public int compare(ElementElement o1, ElementElement o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this._attributes = collector.getAttributes();
            Collections.sort(this._attributes, new Comparator<AttributeElement>(){

                @Override
                public int compare(AttributeElement o1, AttributeElement o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    public List<AttributeElement> getAttributes() {
        return this._attributes;
    }

    public List<ElementElement> getElements() {
        return this._elements;
    }

    protected IParseRootNode parse(String source) {
        IParseRootNode result = null;
        try {
            result = ParserPoolFactory.parse((String)"com.aptana.contenttype.dtd", (String)source).getRootNode();
        }
        catch (Exception exception) {}
        return result;
    }

    private static class NodeCollector
    extends DTDTreeWalker {
        private Map<String, ElementElement> _elementMap = new HashMap<String, ElementElement>();
        private Set<AttributeElement> _attributes = new HashSet<AttributeElement>();

        private NodeCollector() {
        }

        public List<AttributeElement> getAttributes() {
            return new ArrayList<AttributeElement>(this._attributes);
        }

        public List<ElementElement> getElements() {
            return new ArrayList<ElementElement>(this._elementMap.values());
        }

        public void visit(DTDElementDeclNode node) {
            String elementName = node.getName();
            if (!this._elementMap.containsKey(elementName)) {
                ElementElement element = new ElementElement();
                element.setName(elementName);
                this._elementMap.put(elementName, element);
            }
        }

        public void visit(DTDAttributeNode node) {
            String elementName;
            ElementElement element;
            IParseNode parent = node.getParent();
            if (parent instanceof DTDAttListDeclNode && (element = this._elementMap.get(elementName = ((DTDAttListDeclNode)parent).getName())) != null) {
                String attributeName = node.getName();
                AttributeElement attribute = new AttributeElement();
                attribute.setName(attributeName);
                attribute.setElement(elementName);
                element.addAttribute(attributeName);
                this._attributes.add(attribute);
            }
        }
    }
}

