/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist.index;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.xml.contentassist.index.IKeyProvider;
import com.aptana.editor.xml.contentassist.model.AttributeElement;
import com.aptana.editor.xml.contentassist.model.ElementElement;
import com.aptana.index.core.Index;
import java.net.URI;

public class XMLIndexWriter {
    private IKeyProvider _keyProvider;

    public XMLIndexWriter(IKeyProvider keyProvider) {
        this._keyProvider = keyProvider;
    }

    protected URI getDocumentPath() {
        return URI.create(this._keyProvider.getMetadataLocation());
    }

    public void writeAttribute(Index index, AttributeElement attribute) {
        this.writeAttribute(index, attribute, this.getDocumentPath());
    }

    public void writeAttribute(Index index, AttributeElement attribute, URI location) {
        String[] columns = new String[]{attribute.getName(), attribute.getElement(), attribute.getDescription(), ""};
        String key = StringUtil.join((String)"\u0000", (String[])columns);
        index.addEntry(this._keyProvider.getAttributeKey(), key, location);
    }

    public void writeElement(Index index, ElementElement element) {
        this.writeElement(index, element, this.getDocumentPath());
    }

    public void writeElement(Index index, ElementElement element, URI location) {
        String[] columns = new String[]{element.getName(), element.getDisplayName(), StringUtil.join((String)",", element.getAttributes()), element.getDescription()};
        String key = StringUtil.join((String)"\u0000", (String[])columns);
        index.addEntry(this._keyProvider.getElementKey(), key, location);
    }
}

