/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.contentassist.XMLIndexQueryHelper;
import com.aptana.editor.xml.contentassist.model.AttributeElement;
import com.aptana.editor.xml.contentassist.model.ElementElement;
import com.aptana.editor.xml.contentassist.model.ValueElement;
import com.aptana.editor.xml.parsing.XMLParserScanner;
import com.aptana.editor.xml.parsing.lexer.XMLLexemeProvider;
import com.aptana.editor.xml.parsing.lexer.XMLTokenType;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;

public class XMLContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final Image ELEMENT_ICON = XMLPlugin.getImage("/icons/assistant/element.png");
    private static final Image ATTRIBUTE_ICON = XMLPlugin.getImage("/icons/assistant/attribute.png");
    protected Map<String, LocationType> locationMap;
    private XMLIndexQueryHelper _queryHelper = new XMLIndexQueryHelper();
    private Lexeme<XMLTokenType> _currentLexeme;
    private IRange _replaceRange;
    private IDocument _document;

    public XMLContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
        this.buildLocationMap();
    }

    protected List<ICompletionProposal> addAttributeProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String elementName = this.getElementName(lexemeProvider, offset);
        ElementElement element = this._queryHelper.getElement(elementName);
        if (element != null) {
            int length = 2;
            String postfix = "=\"\"";
            switch ((XMLTokenType)((Object)this._currentLexeme.getType())) {
                case EQUAL: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    if (index <= 0) break;
                    this._currentLexeme = lexemeProvider.getLexeme(index - 1);
                    this._replaceRange = this._currentLexeme;
                    postfix = "";
                    length = 0;
                    break;
                }
                case END_TAG: {
                    this._replaceRange = null;
                    break;
                }
                default: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    Lexeme nextlexeme = lexemeProvider.getLexeme(index + 1);
                    if (nextlexeme == null || nextlexeme.getType() != XMLTokenType.EQUAL) break;
                    postfix = "";
                    length = 0;
                }
            }
            for (String attribute : element.getAttributes()) {
                proposals.add((ICompletionProposal)this.createProposal(attribute, String.valueOf(attribute) + postfix, ATTRIBUTE_ICON, null, null, this.getCoreLocation(), offset, attribute.length() + length));
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> addAttributeValueProposals(int offset, String elementName, String attributeName) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        AttributeElement attribute = this._queryHelper.getAttribute(elementName, attributeName);
        if (attribute != null) {
            for (ValueElement value : attribute.getValues()) {
                String name = value.getName();
                Image icon = ATTRIBUTE_ICON;
                String description = value.getDescription();
                this.addProposal(proposals, name, icon, description, null, offset);
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> addAttributeValueProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String attributeName = this.getAttributeName(lexemeProvider, offset);
        if (attributeName != null && attributeName.length() > 0) {
            switch ((XMLTokenType)((Object)this._currentLexeme.getType())) {
                case SINGLE_QUOTED_STRING: 
                case DOUBLE_QUOTED_STRING: {
                    if (this._currentLexeme.getLength() < 2) break;
                    int startingOffset = this._currentLexeme.getStartingOffset() + 1;
                    int endingOffset = this._currentLexeme.getEndingOffset() - 1;
                    this._replaceRange = new Range(startingOffset, endingOffset);
                    break;
                }
                case EQUAL: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
            }
            String elementName = this.getElementName(lexemeProvider, offset);
            proposals.addAll(this.addAttributeValueProposals(offset, elementName, attributeName));
        }
        return proposals;
    }

    private List<ICompletionProposal> addCloseTagProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        List<ElementElement> elements;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Set<String> unclosedElements = this.getUnclosedTagNames(offset);
        if (unclosedElements != null && !unclosedElements.isEmpty()) {
            for (String unclosedElement : unclosedElements) {
                ElementElement element = this._queryHelper.getElement(unclosedElement);
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, offset));
            }
            if (!proposals.isEmpty()) {
                return proposals;
            }
        }
        if ((elements = this._queryHelper.getElements()) != null) {
            for (ElementElement element : elements) {
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, offset));
            }
        }
        return proposals;
    }

    protected List<ICompletionProposal> addElementProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        List<ElementElement> elements = this._queryHelper.getElements();
        if (elements == null) {
            return Collections.emptyList();
        }
        boolean close = true;
        int replaceLength = 0;
        if (this._currentLexeme.getType() == XMLTokenType.END_TAG) {
            replaceLength = 1;
        } else if (this._currentLexeme.getType() != XMLTokenType.START_TAG) {
            Lexeme nextLexeme;
            int index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme.getEndingOffset() + 1);
            if (index == -1 || index >= lexemeProvider.size()) {
                index = lexemeProvider.size() - 1;
            }
            if ((nextLexeme = lexemeProvider.getLexeme(index)) != null) {
                offset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                if (!nextLexeme.equals(this._currentLexeme)) {
                    if (nextLexeme.getType() == XMLTokenType.END_TAG) {
                        replaceLength += nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset();
                    } else if (nextLexeme.getType() != XMLTokenType.START_TAG) {
                        close = false;
                    }
                }
            }
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ElementElement element : elements) {
            String replaceString = element.getName();
            int cursorPosition = replaceString.length();
            if (close) {
                if (element.getName().charAt(0) == '!') {
                    replaceString = String.valueOf(replaceString) + " >";
                    ++cursorPosition;
                } else {
                    Document doc = new Document(this._document.get());
                    try {
                        doc.replace(offset, replaceLength, String.valueOf(element.getName()) + ">");
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            CommonCompletionProposal proposal = new CommonCompletionProposal(replaceString, offset, replaceLength, cursorPosition, ELEMENT_ICON, element.getName(), null, element.getDescription());
            proposal.setFileLocation(this.getCoreLocation());
            proposals.add((ICompletionProposal)proposal);
        }
        return proposals;
    }

    private void addOpenTagPropsals(List<ICompletionProposal> proposals, ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        LocationType location = this.getOpenTagLocationType(lexemeProvider, offset);
        switch (location) {
            case IN_ELEMENT_NAME: {
                proposals.addAll(this.addElementProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_NAME: {
                proposals.addAll(this.addAttributeProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_VALUE: {
                proposals.addAll(this.addAttributeValueProposals(lexemeProvider, offset));
                break;
            }
        }
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, Map<String, String> userAgents, int offset) {
        this.addProposal(proposals, name, image, description, userAgents, this.getCoreLocation(), offset);
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, Map<String, String> userAgents, String fileLocation, int offset) {
        CommonCompletionProposal proposal = this.createProposal(name, image, description, userAgents, fileLocation, offset);
        proposals.add((ICompletionProposal)proposal);
    }

    protected void buildLocationMap() {
        this.locationMap = new HashMap<String, LocationType>();
        this.locationMap.put("__xml__dftl_partition_content_type", LocationType.IN_TEXT);
        this.locationMap.put("__xml_comment", LocationType.IN_COMMENT);
        this.locationMap.put("__xml_cdata", LocationType.IN_TEXT);
        this.locationMap.put("__xml_pre_processor", LocationType.IN_TEXT);
        this.locationMap.put("__xml_tag", LocationType.IN_OPEN_TAG);
        this.locationMap.put("__dftl_partition_content_type", LocationType.IN_TEXT);
    }

    private CommonCompletionProposal createCloseTagProposal(ElementElement element, int offset) {
        String replaceString = element.getName();
        int cursorPosition = replaceString.length();
        int replaceLength = 0;
        CommonCompletionProposal proposal = new CommonCompletionProposal(replaceString, offset, replaceLength, cursorPosition, ELEMENT_ICON, element.getName(), null, element.getDescription());
        proposal.setFileLocation(this.getCoreLocation());
        return proposal;
    }

    ILexemeProvider<XMLTokenType> createLexemeProvider(IDocument document, int offset) {
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new XMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new XMLParserScanner());
    }

    private CommonCompletionProposal createProposal(String name, Image image, String description, Map<String, String> userAgents, String fileLocation, int offset) {
        return this.createProposal(name, name, image, description, userAgents, fileLocation, offset, name.length());
    }

    protected CommonCompletionProposal createProposal(String displayName, String name, Image image, String description, Map<String, String> userAgents, String fileLocation, int offset, int length) {
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this._document = viewer.getDocument();
        ILexemeProvider<XMLTokenType> lexemeProvider = this.createLexemeProvider(this._document, offset);
        this._currentLexeme = lexemeProvider.getFloorLexeme(offset);
        this._replaceRange = this._currentLexeme;
        LocationType location = this.getCoarseLocationType(this._document, lexemeProvider, offset);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        switch (location) {
            case IN_OPEN_TAG: {
                this.addOpenTagPropsals(result, lexemeProvider, offset);
                break;
            }
            case IN_CLOSE_TAG: {
                result.addAll(this.addCloseTagProposals(lexemeProvider, offset));
                break;
            }
            case IN_TEXT: {
                break;
            }
        }
        Collections.sort(result, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
            }
        });
        ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
        if (this._replaceRange != null) {
            try {
                String text = this._document.get(this._replaceRange.getStartingOffset(), this._replaceRange.getLength());
                this.setSelectedProposal(text, proposals);
            }
            catch (BadLocationException badLocationException) {}
        }
        return proposals;
    }

    private String getAttributeName(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        String name = null;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            if (lexeme.getType() == XMLTokenType.EQUAL) {
                if (index < 1 || (lexeme = lexemeProvider.getLexeme(index - 1)) == null) break;
                name = lexeme.getText();
                break;
            }
            --index;
        }
        return name;
    }

    LocationType getCoarseLocationType(IDocument document, ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        LocationType result;
        block24: {
            result = LocationType.ERROR;
            try {
                ITypedRegion partition = document.getPartition(offset);
                String type = partition.getType();
                if (!this.locationMap.containsKey(type)) break block24;
                result = this.locationMap.get(type);
                Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
                if (firstLexeme != null) {
                    switch (result) {
                        case IN_OPEN_TAG: {
                            Lexeme lastLexeme = lexemeProvider.getLastLexeme();
                            if (lastLexeme != null && lastLexeme.getEndingOffset() == offset - 1) {
                                result = LocationType.IN_TEXT;
                                break;
                            }
                            if (firstLexeme.getStartingOffset() == offset) {
                                if (offset == 0) {
                                    result = LocationType.IN_TEXT;
                                    break;
                                }
                                ITypedRegion previousPartition = document.getPartition(offset - 1);
                                String src = document.get(previousPartition.getOffset(), previousPartition.getLength()).trim();
                                if (src.charAt(src.length() - 1) == '>') {
                                    result = LocationType.IN_TEXT;
                                    break;
                                }
                            } else if ("</".equals(firstLexeme.getText())) {
                                result = LocationType.IN_CLOSE_TAG;
                                break;
                            }
                            break block24;
                        }
                        case IN_TEXT: {
                            if (firstLexeme.getStartingOffset() >= offset) break block24;
                            Lexeme lastLexeme = lexemeProvider.getLastLexeme();
                            if ("<".equals(firstLexeme.getText())) {
                                switch ((XMLTokenType)((Object)lastLexeme.getType())) {
                                    case END_TAG: 
                                    case TAG_SELF_CLOSE: {
                                        if (offset <= lastLexeme.getStartingOffset()) {
                                            result = LocationType.IN_OPEN_TAG;
                                            break;
                                        }
                                        break block24;
                                    }
                                    case META: {
                                        if (lastLexeme.getText().equalsIgnoreCase("DOCTYPE")) {
                                            result = LocationType.IN_DOCTYPE;
                                            break;
                                        }
                                        result = LocationType.IN_OPEN_TAG;
                                        break;
                                    }
                                    default: {
                                        result = LocationType.IN_OPEN_TAG;
                                        break;
                                    }
                                }
                                break block24;
                            }
                            if (!"</".equals(firstLexeme.getText())) break block24;
                            switch ((XMLTokenType)((Object)lastLexeme.getType())) {
                                case END_TAG: 
                                case TAG_SELF_CLOSE: {
                                    if (offset <= lastLexeme.getStartingOffset()) {
                                        result = LocationType.IN_CLOSE_TAG;
                                        break;
                                    }
                                    break block24;
                                }
                                default: {
                                    result = LocationType.IN_CLOSE_TAG;
                                    break;
                                }
                            }
                            break block24;
                        }
                    }
                    break block24;
                }
                result = LocationType.IN_TEXT;
            }
            catch (BadLocationException badLocationException) {}
        }
        return result;
    }

    protected String getCoreLocation() {
        return "XML Core";
    }

    private String getElementName(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        int index;
        String result = null;
        int i = index = lexemeProvider.getLexemeFloorIndex(offset);
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == XMLTokenType.START_TAG) {
                result = lexeme.getText();
                break;
            }
            --i;
        }
        return result;
    }

    LocationType getOpenTagLocationType(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        LocationType result = LocationType.ERROR;
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index < 0) {
            int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
            Lexeme lexeme = lexemeProvider.getLexeme(candidateIndex);
            if (lexeme != null && lexeme.getEndingOffset() == offset - 1) {
                index = candidateIndex;
            } else {
                result = LocationType.IN_ATTRIBUTE_NAME;
            }
        }
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            block0 : switch ((XMLTokenType)((Object)lexeme.getType())) {
                case ATTRIBUTE: {
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case EQUAL: {
                    result = offset <= lexeme.getStartingOffset() ? LocationType.IN_ATTRIBUTE_NAME : LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case START_TAG: {
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case END_TAG: {
                    Lexeme previous;
                    if (index < 1 || (previous = lexemeProvider.getLexeme(index - 1)).getEndingOffset() >= offset - 1) break;
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case META: {
                    Lexeme previous;
                    if (index >= 1) {
                        previous = lexemeProvider.getLexeme(index - 1);
                        switch ((XMLTokenType)((Object)previous.getType())) {
                            case SINGLE_QUOTED_STRING: 
                            case DOUBLE_QUOTED_STRING: 
                            case META: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ATTRIBUTE_NAME;
                                break block0;
                            }
                            case START_TAG: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ELEMENT_NAME;
                                break block0;
                            }
                        }
                        break;
                    }
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case SINGLE_QUOTED_STRING: 
                case DOUBLE_QUOTED_STRING: {
                    if (lexeme.getEndingOffset() < offset) {
                        result = LocationType.IN_ATTRIBUTE_NAME;
                        this._replaceRange = null;
                        break;
                    }
                    result = LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
            }
            if (result != LocationType.ERROR) break;
            --index;
        }
        return result;
    }

    protected Set<String> getUnclosedTagNames(int offset) {
        HashSet<String> unclosedElements = new HashSet<String>();
        try {
            ITypedRegion[] partitions;
            ITypedRegion[] iTypedRegionArray = partitions = this._document.computePartitioning(0, offset);
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] parts;
                String src;
                int lessThanIndex;
                ITypedRegion partition = iTypedRegionArray[n2];
                if (!partition.getType().equals("__xml_tag") || (lessThanIndex = (src = this._document.get(partition.getOffset(), partition.getLength())).indexOf(60)) == -1 || lessThanIndex >= src.length() - 1 || (parts = (src = src.substring(lessThanIndex + 1).trim()).split("\\W")) == null || parts.length == 0) {
                    // empty if block
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        return unclosedElements;
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.xml";
    }

    public static enum LocationType {
        ERROR,
        IN_OPEN_TAG,
        IN_CLOSE_TAG,
        IN_DOCTYPE,
        IN_COMMENT,
        IN_TEXT,
        IN_ELEMENT_NAME,
        IN_ATTRIBUTE_NAME,
        IN_ATTRIBUTE_VALUE;

    }
}

